/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.file.service.legacy.internal;

import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.file.service.legacy.api.RemotableFileStreamAccessService;
import de.rcenvironment.core.communication.fileaccess.api.RemoteFileConnection;
import de.rcenvironment.core.datamanagement.FileDataService;
import de.rcenvironment.core.datamanagement.backend.MetaDataBackendService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.core.utils.incubator.Assertions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class RemotableFileStreamAccessServiceImpl
implements RemotableFileStreamAccessService {
    private static final String PARAMETER_UUID = "uuid";
    private static final String ERROR_INPUT_STREAM_NOT_FOUND = "The input stream could not be found: ";
    private static final String ERROR_PARAMETERS_NULL = "The parameter \"%s\" must not be null.";
    private static final Log LOGGER = LogFactory.getLog(RemotableFileStreamAccessServiceImpl.class);
    private static Map<String, InputStream> inputStreamMap = Collections.synchronizedMap(new HashMap());
    private FileDataService dataService;
    private MetaDataBackendService metaDataBackendService;

    protected void bindMetadataBackendService(MetaDataBackendService newService) {
        this.metaDataBackendService = newService;
    }

    protected void bindFileDataService(FileDataService newFileDataService) {
        this.dataService = newFileDataService;
    }

    @Override
    @AllowRemoteAccess
    public void close(String uuid) throws IOException {
        Assertions.isDefined((Object)uuid, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{PARAMETER_UUID}));
        if (inputStreamMap.containsKey(uuid)) {
            inputStreamMap.get(uuid).close();
            inputStreamMap.remove(uuid);
        }
    }

    @Override
    @AllowRemoteAccess
    public String open(RemoteFileConnection.FileType type, String uri) throws IOException {
        InputStream inputStream;
        Assertions.isDefined((Object)type, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"type"}));
        Assertions.isDefined((Object)uri, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"uri"}));
        LOGGER.debug((Object)("Received request for file: " + uri));
        String uuid = UUID.randomUUID().toString();
        if (type == RemoteFileConnection.FileType.RCE_DM) {
            try {
                inputStream = this.dataService.getStreamFromDataReference(this.metaDataBackendService.getDataReference(uri));
            }
            catch (CommunicationException e) {
                throw new RuntimeException(StringUtils.format((String)"Failed to get data reference from %s: ", (Object[])new Object[]{uri}), e.getCause());
            }
            if (inputStream == null) {
                throw new IOException("The file could not be found in the RCE data management: " + uri);
            }
        } else {
            throw new IOException("Only the RCE data management and the file system are supported.");
        }
        inputStreamMap.put(uuid, inputStream);
        return uuid;
    }

    @Override
    public int read(String uuid) throws IOException {
        Assertions.isDefined((Object)uuid, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{PARAMETER_UUID}));
        InputStream inputStream = inputStreamMap.get(uuid);
        if (inputStream == null) {
            throw new IOException(ERROR_INPUT_STREAM_NOT_FOUND + uuid);
        }
        return inputStream.read();
    }

    @Override
    @AllowRemoteAccess
    public byte[] read(String uuid, Integer len) throws IOException {
        Assertions.isDefined((Object)uuid, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{PARAMETER_UUID}));
        Assertions.isDefined((Object)len, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"len"}));
        InputStream inputStream = inputStreamMap.get(uuid);
        if (inputStream == null) {
            throw new IOException(ERROR_INPUT_STREAM_NOT_FOUND + uuid);
        }
        byte[] buffer = new byte[len.intValue()];
        int nRead = inputStream.read(buffer, 0, len);
        if (nRead == len) {
            return buffer;
        }
        if (nRead < 0) {
            inputStream.close();
            inputStreamMap.remove(uuid);
            return new byte[0];
        }
        byte[] resultBuffer = new byte[nRead];
        System.arraycopy(buffer, 0, resultBuffer, 0, nRead);
        return resultBuffer;
    }

    @Override
    public long skip(String uuid, Long n) throws IOException {
        Assertions.isDefined((Object)uuid, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{PARAMETER_UUID}));
        Assertions.isDefined((Object)n, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"n"}));
        InputStream inputStream = inputStreamMap.get(uuid);
        if (inputStream == null) {
            throw new IOException(ERROR_INPUT_STREAM_NOT_FOUND + uuid);
        }
        return inputStream.skip(n);
    }
}

