/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.gui.workflow.view.WorkflowRunEditor;
import de.rcenvironment.core.gui.workflow.view.WorkflowRunEditorService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.expressions.PropertyTester;

public class RuntimeEditorPropertyTester
extends PropertyTester {
    private final WorkflowRunEditorService workflowRunEditorService = (WorkflowRunEditorService)ServiceRegistry.createAccessFor((Object)((Object)this)).getService(WorkflowRunEditorService.class);
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Optional<WorkflowRunEditor> wre = this.workflowRunEditorService.getCurrentWorkflowRunEditor();
        if (!wre.isPresent()) {
            return false;
        }
        WorkflowState state = wre.get().getCurrentEditorWorkflowState();
        switch (property) {
            case "enableResume": {
                return state.isResumable();
            }
            case "enablePause": {
                return state.isPausable();
            }
            case "enableCancel": {
                return state.isCancellable();
            }
        }
        this.log.error((Object)StringUtils.format((String)"Unknown property: '%s'. Expected one of ['enableResume', 'enablePause', 'enableCancel']", (Object[])new Object[]{property}));
        return false;
    }
}

