/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.gui.workflow.execute.ColorPalette;
import de.rcenvironment.core.gui.workflow.execute.Updatable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;

public class CheckboxLabelProvider
extends StyledCellLabelProvider {
    private static final String COLOR = "COLOR";
    private Updatable updater;
    private List<Button> btnList = new ArrayList<Button>();
    private boolean isSet = false;

    public void update(ViewerCell cell) {
        this.setRowColor(cell);
        this.updater.updateCheckBoxColumn(cell);
    }

    void clearButtonList() {
        for (Button btn : this.btnList) {
            TableEditor editor;
            if (btn.getData("EDITOR") instanceof TableEditor) {
                editor = (TableEditor)btn.getData("EDITOR");
                editor.dispose();
            } else {
                editor = (TreeEditor)btn.getData("EDITOR");
                editor.dispose();
            }
            btn.dispose();
        }
        this.btnList.clear();
    }

    private void setRowColor(ViewerCell cell) {
        Color color;
        if (!this.isSet) {
            if (cell.getViewerRow().getItem().getData(COLOR) == null || ((Color)cell.getViewerRow().getItem().getData(COLOR)).isDisposed()) {
                Color firstrow = ColorPalette.getInstance().getFirstRowColor();
                cell.getViewerRow().setBackground(0, firstrow);
                cell.getViewerRow().setBackground(1, firstrow);
                cell.getViewerRow().setBackground(2, firstrow);
                color = firstrow;
                cell.getViewerRow().getItem().setData(COLOR, (Object)color);
            } else {
                Color c = (Color)cell.getViewerRow().getItem().getData(COLOR);
                cell.getViewerRow().setBackground(0, c);
                cell.getViewerRow().setBackground(1, c);
                cell.getViewerRow().setBackground(2, c);
                color = (Color)cell.getViewerRow().getItem().getData(COLOR);
            }
            this.isSet = true;
        } else {
            if (cell.getViewerRow().getItem().getData(COLOR) == null) {
                Color secondRow = ColorPalette.getInstance().getSecondRowColor();
                cell.getViewerRow().setBackground(0, secondRow);
                cell.getViewerRow().setBackground(1, secondRow);
                cell.getViewerRow().setBackground(2, secondRow);
                color = secondRow;
                cell.getViewerRow().getItem().setData(COLOR, (Object)color);
            } else {
                Color c = (Color)cell.getViewerRow().getItem().getData(COLOR);
                cell.getViewerRow().setBackground(0, c);
                cell.getViewerRow().setBackground(1, c);
                cell.getViewerRow().setBackground(2, c);
                color = (Color)cell.getViewerRow().getItem().getData(COLOR);
            }
            this.isSet = false;
        }
        this.updater.setComboColor(color);
    }

    public void setUpdater(Updatable updater) {
        this.updater = updater;
    }

    public List<Button> getBtnList() {
        return this.btnList;
    }
}

