/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.properties;

import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.model.api.WorkflowLabel;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.editor.properties.Messages;
import de.rcenvironment.core.gui.workflow.parts.ConnectionPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowExecutionInformationPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowLabelPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowNodePart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowPart;
import de.rcenvironment.core.utils.common.StringUtils;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;

public final class WorkflowLabelProvider
extends LabelProvider {
    public String getText(Object objects) {
        String value = "";
        if (objects == null || objects.equals(StructuredSelection.EMPTY)) {
            value = Messages.noItemSelected;
        } else if (((IStructuredSelection)objects).size() > 1) {
            value = String.valueOf(((IStructuredSelection)objects).size()) + Messages.itemSelected;
        } else {
            Object object = ((IStructuredSelection)objects).getFirstElement();
            if (object instanceof WorkflowNodePart) {
                value = StringUtils.format((String)"Component Properties: %s", (Object[])new Object[]{org.apache.commons.lang3.StringUtils.abbreviate((String)((WorkflowNode)((WorkflowNodePart)object).getModel()).getName(), (int)40)});
            } else if (object instanceof WorkflowExecutionInformationPart) {
                value = StringUtils.format((String)"Workflow: %s", (Object[])new Object[]{org.apache.commons.lang3.StringUtils.abbreviate((String)((WorkflowExecutionInformation)((WorkflowExecutionInformationPart)((Object)object)).getModel()).getInstanceName(), (int)40)});
            } else if (object instanceof WorkflowLabelPart) {
                String[] labelParts = ((WorkflowLabel)((WorkflowLabelPart)object).getModel()).getText().split("\n");
                String labelAbrev = org.apache.commons.lang3.StringUtils.abbreviate((String)labelParts[0].replaceAll("\\r", ""), (int)40);
                if (!labelAbrev.endsWith("...") && labelParts.length > 1) {
                    labelAbrev = String.valueOf(labelAbrev) + "...";
                }
                value = StringUtils.format((String)"Label Properties: \"%s\"", (Object[])new Object[]{labelAbrev});
            } else if (object instanceof WorkflowPart || object instanceof ConnectionPart) {
                try {
                    String partName = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePartReference().getPartName();
                    value = StringUtils.format((String)"Workflow Properties: %s", (Object[])new Object[]{org.apache.commons.lang3.StringUtils.abbreviate((String)org.apache.commons.lang3.StringUtils.removeEndIgnoreCase((String)partName, (String)".wf"), (int)40)});
                }
                catch (NullPointerException nullPointerException) {
                    value = "Workflow Properties";
                }
            }
        }
        return value;
    }
}

