/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands.endpoint;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.util.Map;

public class AddDynamicEndpointCommand
extends WorkflowNodeCommand {
    protected EndpointDescriptionsManager endpointDescManager;
    protected String id;
    protected String name;
    protected DataType type;
    protected Map<String, String> metaData;
    protected Refreshable[] refreshable;
    private boolean executable = true;
    private boolean undoable = false;
    private EndpointType direction;

    public AddDynamicEndpointCommand(EndpointType direction, String id, String name, DataType type, Map<String, String> metaData, Refreshable ... refreshable) {
        this.name = name;
        this.id = id;
        this.type = type;
        this.metaData = metaData;
        this.direction = direction;
        this.refreshable = refreshable;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean canExecute() {
        return this.executable;
    }

    @Override
    public void execute() {
        this.endpointDescManager = this.direction == EndpointType.INPUT ? this.getProperties().getInputDescriptionsManager() : this.getProperties().getOutputDescriptionsManager();
        if (this.executable) {
            this.endpointDescManager.addDynamicEndpointDescription(this.id, this.name, this.type, this.metaData);
            this.executable = false;
            this.undoable = true;
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    @Override
    public boolean canUndo() {
        return this.undoable;
    }

    @Override
    public void undo() {
        this.endpointDescManager = this.direction == EndpointType.INPUT ? this.getProperties().getInputDescriptionsManager() : this.getProperties().getOutputDescriptionsManager();
        if (this.undoable) {
            this.endpointDescManager.removeDynamicEndpointDescription(this.name);
            this.executable = true;
            this.undoable = false;
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }
}

