/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.uplinktoolaccess;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.communication.uplink.client.execution.api.DataTransferUtils;
import de.rcenvironment.core.communication.uplink.client.execution.api.DirectoryDownloadReceiver;
import de.rcenvironment.core.communication.uplink.client.execution.api.DirectoryUploadContext;
import de.rcenvironment.core.communication.uplink.client.execution.api.DirectoryUploadProvider;
import de.rcenvironment.core.communication.uplink.client.execution.api.FileDataSource;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionClientSideSetup;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionEventHandler;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionResult;
import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSession;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionService;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionSetup;
import de.rcenvironment.core.communication.uplink.client.session.api.ToolExecutionHandle;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.ThreadHandler;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UplinkToolAccessClientComponent
extends DefaultComponent {
    private static final Log LOG = LogFactory.getLog(UplinkToolAccessClientComponent.class);
    private ObjectMapper mapper;
    private SshUplinkConnectionService uplinkService;
    private TempFileService tempFileService;
    private ComponentDataManagementService datamanagementService;
    private ComponentContext componentContext;
    private String toolId;
    private String toolVersion;
    private String destinationId;
    private String connectionId;
    private String authGroupId;
    private ComponentLog componentLog;
    private TypedDatumSerializer serializer;
    private ToolExecutionHandle toolExecutionHandle;
    private boolean componentFailed;
    private boolean componentCancelled;

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.componentLog = componentContext.getLog();
    }

    public void start() throws ComponentException {
        this.mapper = JsonUtils.getDefaultObjectMapper();
        this.tempFileService = TempFileServiceAccess.getInstance();
        this.datamanagementService = (ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class);
        this.uplinkService = (SshUplinkConnectionService)this.componentContext.getService(SshUplinkConnectionService.class);
        this.serializer = ((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getSerializer();
        this.toolId = this.componentContext.getConfigurationValue("toolId");
        this.destinationId = this.componentContext.getConfigurationValue("destinationId");
        this.toolVersion = this.componentContext.getConfigurationValue("version");
        this.connectionId = this.componentContext.getConfigurationValue("connection");
        this.authGroupId = this.componentContext.getConfigurationValue("authGroupId");
        if (this.toolId == null || this.toolVersion == null || this.connectionId == null) {
            throw new ComponentException("Configuration for remote tool is not valid.");
        }
        SshUplinkConnectionSetup connection = this.uplinkService.getConnectionSetup(this.connectionId);
        if (connection == null) {
            throw new ComponentException("The uplink connection for this tool does not exist.");
        }
        this.componentLog.componentInfo("Started on logical node " + this.componentContext.getServiceCallContext().getReceivingNode());
        if (this.treatStartAsComponentRun()) {
            this.processInputs();
        }
    }

    public boolean treatStartAsComponentRun() {
        return this.componentContext.getInputs().isEmpty();
    }

    public void processInputs() throws ComponentException {
        block10: {
            Condition remoteExecutionFinished;
            ReentrantLock remoteExecutionLock;
            File downloadDir;
            ToolExecutionEventHandler eventHandler;
            File uploadDir;
            File tempRootDir;
            HashMap<String, String> inputsMap = new HashMap<String, String>();
            try {
                tempRootDir = this.tempFileService.createManagedTempDir();
                uploadDir = this.prepareUploadDirectory(tempRootDir, inputsMap);
            }
            catch (IOException e1) {
                throw new ComponentException("Upload directory could not be created.", (Throwable)e1);
            }
            Optional optionalUplinkSession = this.uplinkService.getActiveSshUplinkSession(this.connectionId);
            if (!optionalUplinkSession.isPresent()) {
                throw new ComponentException("Ready to process inputs, but the Uplink connection towards this remote tool is not active anymore");
            }
            ClientSideUplinkSession uplinkSession = (ClientSideUplinkSession)optionalUplinkSession.get();
            Map<String, String> properties = this.getProperties();
            ToolExecutionClientSideSetup setup = ToolExecutionClientSideSetup.newBuilder().toolId(this.toolId).toolVersion(this.toolVersion).authGroupId(this.authGroupId).destinationId(this.destinationId).nonRequiredInputs(this.createNotRequiredInputsSet()).dynamicInputs(this.createDynamicInputsSet(inputsMap)).dynamicOutputs(this.createDynamicOutputsSet()).properties(properties).build();
            Optional initiationResult = uplinkSession.initiateToolExecution(setup, eventHandler = this.createToolExecutionEventHandler(uploadDir, downloadDir = new File(tempRootDir, "output"), remoteExecutionLock = new ReentrantLock(), remoteExecutionFinished = remoteExecutionLock.newCondition()));
            if (!initiationResult.isPresent()) {
                throw new ComponentException("Error while initiating remote tool execution; check the log output for details");
            }
            this.toolExecutionHandle = (ToolExecutionHandle)initiationResult.get();
            remoteExecutionLock.lock();
            try {
                try {
                    remoteExecutionFinished.await();
                    this.extractAndSendOutputs(downloadDir);
                }
                catch (InterruptedException e) {
                    this.componentLog.componentError("Waiting for remote execution failed. " + e.getMessage());
                    remoteExecutionLock.unlock();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                remoteExecutionLock.unlock();
                throw throwable;
            }
            remoteExecutionLock.unlock();
        }
        if (this.componentFailed) {
            throw new ComponentException("Remote tool execution failed.");
        }
    }

    private ToolExecutionEventHandler createToolExecutionEventHandler(final File uploadDir, final File downloadDir, final Lock remoteExecutionLock, final Condition remoteExecutionFinished) {
        return new ToolExecutionEventHandler(){

            public DirectoryUploadProvider getInputDirectoryProvider() {
                return new DirectoryUploadProvider(){

                    public List<String> provideDirectoryListing() throws IOException {
                        ArrayList<String> listOfDirs = new ArrayList<String>();
                        DataTransferUtils.getDirectoryListing((File)uploadDir, listOfDirs, (String)"");
                        return listOfDirs;
                    }

                    public void provideFiles(DirectoryUploadContext uploadContext) throws IOException {
                        DataTransferUtils.uploadDirectory((File)uploadDir, (DirectoryUploadContext)uploadContext, (String)"", (String)"");
                    }
                };
            }

            public DirectoryDownloadReceiver getOutputDirectoryReceiver() {
                return new DirectoryDownloadReceiver(){

                    public void receiveDirectoryListing(List<String> relativePaths) throws IOException {
                        DataTransferUtils.receiveDirectoryListing(relativePaths, (File)downloadDir);
                    }

                    public void receiveFile(FileDataSource dataSource) throws IOException {
                        try {
                            DataTransferUtils.receiveFile((FileDataSource)dataSource, (File)downloadDir);
                        }
                        catch (IOException e) {
                            LOG.error((Object)("Failed to receive output file: " + e.getMessage()));
                        }
                    }
                };
            }

            public void onOutputDownloadsStarting() {
                UplinkToolAccessClientComponent.this.componentLog.componentInfo("Outputs download started.");
            }

            public void onOutputDownloadsFinished() {
                UplinkToolAccessClientComponent.this.componentLog.componentInfo("Outputs download finished.");
            }

            public void onInputUploadsStarting() {
                UplinkToolAccessClientComponent.this.componentLog.componentInfo("Inputs upload started.");
            }

            public void onInputUploadsFinished() {
                UplinkToolAccessClientComponent.this.componentLog.componentInfo("Inputs upload finished.");
            }

            public void onExecutionStarting() {
                UplinkToolAccessClientComponent.this.componentLog.componentInfo("Remote tool execution started.");
            }

            public void processToolExecutionEvent(String type, String data) {
                ConsoleRow.Type consoleRowType = ConsoleRow.Type.valueOf((String)type);
                switch (consoleRowType) {
                    case TOOL_OUT: {
                        UplinkToolAccessClientComponent.this.componentLog.toolStdout(data);
                        break;
                    }
                    case TOOL_ERROR: {
                        UplinkToolAccessClientComponent.this.componentLog.toolStderr(data);
                        break;
                    }
                    case COMPONENT_ERROR: {
                        UplinkToolAccessClientComponent.this.componentLog.componentError(data);
                        break;
                    }
                    case COMPONENT_WARN: {
                        UplinkToolAccessClientComponent.this.componentLog.componentWarn(data);
                        break;
                    }
                    case COMPONENT_INFO: {
                        UplinkToolAccessClientComponent.this.componentLog.componentInfo(data);
                        break;
                    }
                    case LIFE_CYCLE_EVENT: {
                        break;
                    }
                    default: {
                        UplinkToolAccessClientComponent.this.componentLog.componentInfo("Tool event " + type + ": \"" + data + "\"");
                    }
                }
            }

            public void onExecutionFinished(ToolExecutionResult executionResult) {
                UplinkToolAccessClientComponent.this.componentLog.componentInfo("Remote tool execution finished.");
                if (!(executionResult.successful || UplinkToolAccessClientComponent.this.componentCancelled && executionResult.cancelled)) {
                    UplinkToolAccessClientComponent.this.componentFailed = true;
                }
            }

            public void onError(String message) {
                UplinkToolAccessClientComponent.this.componentLog.componentError("Tool execution failed: " + message);
                UplinkToolAccessClientComponent.this.componentFailed = true;
            }

            public void onContextClosing() {
                remoteExecutionLock.lock();
                try {
                    remoteExecutionFinished.signal();
                }
                finally {
                    remoteExecutionLock.unlock();
                }
            }
        };
    }

    private Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String configKey : this.componentContext.getConfigurationKeys()) {
            this.componentContext.getConfigurationValue(configKey);
            properties.put(configKey, this.componentContext.getConfigurationValue(configKey));
        }
        return properties;
    }

    public synchronized void onProcessInputsInterrupted(ThreadHandler executingThreadHandler) {
        this.cancelTool();
    }

    public synchronized void onStartInterrupted(ThreadHandler executingThreadHandler) {
        this.cancelTool();
    }

    private void cancelTool() {
        this.componentLog.componentInfo("Cancelling tool...");
        this.componentCancelled = true;
        this.toolExecutionHandle.requestCancel();
    }

    private Set<Map<String, Object>> createDynamicOutputsSet() throws ComponentException {
        HashSet<Map<String, Object>> dynoutputsSet = new HashSet<Map<String, Object>>();
        for (String outputName : this.componentContext.getOutputs()) {
            if (!this.componentContext.isDynamicOutput(outputName)) continue;
            HashMap<String, Object> outputData = new HashMap<String, Object>();
            outputData.put("identifier", this.componentContext.getDynamicOutputIdentifier(outputName));
            outputData.put("name", outputName);
            outputData.put("dataType", this.componentContext.getOutputDataType(outputName));
            HashMap<String, String> metaData = new HashMap<String, String>();
            for (String metaDataKey : this.componentContext.getOutputMetaDataKeys(outputName)) {
                metaData.put(metaDataKey, this.componentContext.getOutputMetaDataValue(outputName, metaDataKey));
            }
            outputData.put("metaData", metaData);
            dynoutputsSet.add(outputData);
        }
        return dynoutputsSet;
    }

    private Set<Map<String, Object>> createDynamicInputsSet(Map<String, String> inputsMap) throws ComponentException {
        HashSet<Map<String, Object>> dynInputsSet = new HashSet<Map<String, Object>>();
        for (String inputName : inputsMap.keySet()) {
            if (!this.componentContext.isDynamicInput(inputName)) continue;
            HashMap<String, Object> inputData = new HashMap<String, Object>();
            inputData.put("identifier", this.componentContext.getDynamicInputIdentifier(inputName));
            inputData.put("name", inputName);
            inputData.put("dataType", this.componentContext.getInputDataType(inputName));
            HashMap<String, String> metaData = new HashMap<String, String>();
            for (String metaDataKey : this.componentContext.getInputMetaDataKeys(inputName)) {
                metaData.put(metaDataKey, this.componentContext.getInputMetaDataValue(inputName, metaDataKey));
            }
            inputData.put("metaData", metaData);
            dynInputsSet.add(inputData);
        }
        return dynInputsSet;
    }

    private Set<String> createNotRequiredInputsSet() throws ComponentException {
        HashSet<String> nonReqInputsSet = new HashSet<String>();
        nonReqInputsSet.addAll(this.componentContext.getInputsNotConnected());
        for (String input : this.componentContext.getInputs()) {
            EndpointDefinition.InputExecutionContraint exeConstraint;
            if (this.componentContext.getInputMetaDataValue(input, "inputExecutionConstraint_4aae3eea") == null || !(exeConstraint = EndpointDefinition.InputExecutionContraint.valueOf((String)this.componentContext.getInputMetaDataValue(input, "inputExecutionConstraint_4aae3eea"))).equals((Object)EndpointDefinition.InputExecutionContraint.NotRequired)) continue;
            nonReqInputsSet.add(input);
        }
        return nonReqInputsSet;
    }

    private File prepareUploadDirectory(File tempRootDir, Map<String, String> inputsMap) throws IOException {
        File uploadDir = new File(tempRootDir, "input");
        uploadDir.mkdir();
        File inputsFile = new File(uploadDir, "inputs.json");
        if (this.componentContext != null && this.componentContext.getInputsWithDatum() != null) {
            for (String inputName : this.componentContext.getInputsWithDatum()) {
                TypedDatum input = this.componentContext.readInput(inputName);
                switch (input.getDataType()) {
                    case DirectoryReference: {
                        File inputFile = new File(uploadDir, ((DirectoryReferenceTD)input).getDirectoryReference());
                        this.datamanagementService.copyReferenceTDToLocalCompressedFile(this.componentContext, input, inputFile);
                        break;
                    }
                    case FileReference: {
                        File inputDir = new File(uploadDir, ((FileReferenceTD)input).getFileReference());
                        this.datamanagementService.copyReferenceTDToLocalCompressedFile(this.componentContext, input, inputDir);
                    }
                }
                inputsMap.put(inputName, this.serializer.serialize(input));
            }
        }
        this.mapper.writerWithDefaultPrettyPrinter().writeValue(inputsFile, inputsMap);
        return uploadDir;
    }

    private void extractAndSendOutputs(File downloadDir) throws ComponentException {
        File outputsFile = new File(downloadDir, "outputs.json");
        if (!outputsFile.exists()) {
            throw new ComponentException("Downloaded directory does not contain file outputs.json");
        }
        try {
            Map outputsMap = (Map)this.mapper.readValue(outputsFile, HashMap.class);
            for (Map.Entry entry : outputsMap.entrySet()) {
                String outputName = (String)entry.getKey();
                if (!this.componentContext.getOutputs().contains(outputName)) {
                    throw new ComponentException("No output with name " + outputName + " defined.");
                }
                for (String output : (List)entry.getValue()) {
                    this.extractAndSendSingleOutput(downloadDir, outputName, output);
                }
            }
        }
        catch (IOException e1) {
            throw new ComponentException("Could not parse file outputs.json: " + e1);
        }
    }

    private void extractAndSendSingleOutput(File downloadDir, String outputName, String output) throws ComponentException, IOException {
        TypedDatum outputTD = this.serializer.deserialize(output);
        if (!outputTD.getDataType().equals((Object)this.componentContext.getOutputDataType(outputName))) {
            throw new ComponentException("Data type of output " + outputName + " does not match the defined type.");
        }
        switch (outputTD.getDataType()) {
            case DirectoryReference: {
                DirectoryReferenceTD newDirTD = this.datamanagementService.createDirectoryReferenceTDFromLocalCompressedFile(this.componentContext, new File(downloadDir, ((DirectoryReferenceTD)outputTD).getDirectoryReference()), ((DirectoryReferenceTD)outputTD).getDirectoryName());
                this.componentContext.writeOutput(outputName, (TypedDatum)newDirTD);
                break;
            }
            case FileReference: {
                FileReferenceTD newFileTD = this.datamanagementService.createFileReferenceTDFromLocalCompressedFile(this.componentContext, new File(downloadDir, ((FileReferenceTD)outputTD).getFileReference()), ((FileReferenceTD)outputTD).getFileName());
                this.componentContext.writeOutput(outputName, (TypedDatum)newFileTD);
                break;
            }
            default: {
                this.componentContext.writeOutput(outputName, outputTD);
            }
        }
    }
}

