/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.configuration.api;

import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDefinition;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationExtensionDefinition;
import de.rcenvironment.core.component.model.configuration.impl.ConfigurationDefinitionImpl;
import de.rcenvironment.core.component.model.spi.PropertiesChangeSupport;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;

public class ConfigurationDescription
extends PropertiesChangeSupport
implements Serializable {
    private static final String CONFIGURATION_PROP = "de.rcenvironment.core.component.configuration.ComponentsConfiguration";
    private static final long serialVersionUID = -1574122807840952727L;
    private final ConfigurationDefinition configDefinition;
    private final ConfigurationDefinition combinedConfigDef;
    private final Set<ConfigurationExtensionDefinition> extConfigDefinitions;
    private Map<String, String> configuration;
    private Map<String, String> placeholders;

    public ConfigurationDescription(ConfigurationDefinition configDef, Set<ConfigurationExtensionDefinition> extConfigDefs) {
        HashSet<ConfigurationDefinition> configDefs = new HashSet<ConfigurationDefinition>();
        configDefs.add(configDef);
        configDefs.addAll(extConfigDefs);
        this.configDefinition = configDef;
        this.extConfigDefinitions = extConfigDefs;
        this.combinedConfigDef = new ConfigurationDefinitionImpl();
        ((ConfigurationDefinitionImpl)this.combinedConfigDef).setConfigurationDefinitions(configDefs);
        this.configuration = new HashMap<String, String>();
        for (String key : this.combinedConfigDef.getConfigurationKeys()) {
            if (this.combinedConfigDef.getDefaultValue(key) == null) continue;
            this.configuration.put(key, this.combinedConfigDef.getDefaultValue(key));
        }
        this.placeholders = new HashMap<String, String>();
    }

    public ConfigurationDefinition getComponentConfigurationDefinition() {
        return this.combinedConfigDef;
    }

    public ConfigurationDefinition getActiveConfigurationDefinition() {
        HashSet<ConfigurationDefinition> configDefs = new HashSet<ConfigurationDefinition>();
        if (((ConfigurationDefinitionImpl)this.configDefinition).isActive(this.configuration)) {
            configDefs.add(this.getActiveConfigurationDefinitionFromConfigurationDefinition(this.configDefinition));
        }
        for (ConfigurationDefinition configurationDefinition : this.extConfigDefinitions) {
            if (!((ConfigurationDefinitionImpl)configurationDefinition).isActive(this.configuration)) continue;
            configDefs.add(this.getActiveConfigurationDefinitionFromConfigurationDefinition(configurationDefinition));
        }
        ConfigurationDefinitionImpl configurationDefinitionImpl = new ConfigurationDefinitionImpl();
        configurationDefinitionImpl.setConfigurationDefinitions(configDefs);
        return configurationDefinitionImpl;
    }

    private ConfigurationDefinition getActiveConfigurationDefinitionFromConfigurationDefinition(ConfigurationDefinition incConfigDefinition) {
        LinkedList<Object> activeConfigurations = new LinkedList<Object>();
        for (String key : incConfigDefinition.getConfigurationKeys()) {
            Map<String, List<String>> keyActivationFilter = ((ConfigurationDefinitionImpl)incConfigDefinition).getActivationFilter(key);
            if (keyActivationFilter != null) {
                for (String neededKey : keyActivationFilter.keySet()) {
                    if (!this.configuration.containsKey(neededKey) || !keyActivationFilter.get(neededKey).contains(this.configuration.get(neededKey))) continue;
                    activeConfigurations.add(((ConfigurationDefinitionImpl)incConfigDefinition).getConfigurationEntry(key));
                }
                continue;
            }
            activeConfigurations.add(((ConfigurationDefinitionImpl)incConfigDefinition).getConfigurationEntry(key));
        }
        ConfigurationDefinitionImpl configurationDefinitionImpl = new ConfigurationDefinitionImpl();
        configurationDefinitionImpl.setRawConfigurationDefinition(activeConfigurations);
        configurationDefinitionImpl.setRawPlaceholderMetaDataDefinition(((ConfigurationDefinitionImpl)incConfigDefinition).getRawPlaceholderMetaDataDefinition());
        configurationDefinitionImpl.setRawActivationFilter(((ConfigurationDefinitionImpl)incConfigDefinition).getRawActivationFilter());
        return configurationDefinitionImpl;
    }

    public String getConfigurationValue(String key) {
        String placeholderValue;
        String configValue = this.configuration.get(key);
        if (ConfigurationDescription.isPlaceholder(configValue) && (placeholderValue = this.placeholders.get(this.getNameOfPlaceholder(configValue))) != null) {
            if (this.combinedConfigDef.getPlaceholderMetaDataDefinition().decode(this.getNameOfPlaceholder(configValue))) {
                try {
                    configValue = new String(new Base64().decode(placeholderValue.getBytes("UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("decoding placeholder value failed", e);
                }
            } else {
                configValue = placeholderValue;
            }
        }
        return configValue;
    }

    public Map<String, String> getConfiguration() {
        return Collections.unmodifiableMap(this.configuration);
    }

    public void setConfigurationValue(String key, String value) {
        String oldValue = this.configuration.get(key);
        if (value != null) {
            this.configuration.put(key, value);
        } else {
            this.configuration.remove(key);
        }
        this.firePropertyChange(CONFIGURATION_PROP, oldValue, value);
        this.firePropertyChange("properties." + key, oldValue, value);
    }

    public void setConfiguration(Map<String, String> newConfiguration) {
        this.configuration = newConfiguration;
    }

    public boolean isPlaceholderSet(String key) {
        return ConfigurationDescription.isPlaceholder(this.configuration.get(key));
    }

    public String getActualConfigurationValue(String key) {
        return this.configuration.get(key);
    }

    public void setPlaceholderValue(String key, String value) {
        this.placeholders.put(key, value);
    }

    public void setPlaceholders(Map<String, String> newPlaceholders) {
        this.placeholders = newPlaceholders;
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    private String getNameOfPlaceholder(String fullPlaceholder) {
        return ComponentUtils.getMatcherForPlaceholder(fullPlaceholder).group(7);
    }

    public static boolean isPlaceholder(String configurationValue) {
        if (configurationValue != null) {
            return configurationValue.matches("\\$\\{((\\w*)(\\.))?((\\*)(\\.))?(.*)\\}");
        }
        return false;
    }
}

