/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.component.execution.api.ExecutionController;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.execution.api.LocalExecutionControllerUtilsService;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class LocalExecutionControllerUtilsServiceImpl
implements LocalExecutionControllerUtilsService {
    @Override
    public <T extends ExecutionController> T getExecutionController(Class<T> controllerInterface, String executionId, BundleContext bundleContext) throws ExecutionControllerException {
        String filter = LocalExecutionControllerUtilsServiceImpl.createPropertyFilter(executionId);
        try {
            ServiceReference[] serviceReferences = bundleContext.getServiceReferences(controllerInterface.getName(), filter);
            if (serviceReferences != null) {
                ServiceReference[] serviceReferenceArray = serviceReferences;
                int n = serviceReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference ref = serviceReferenceArray[n2];
                    ExecutionController exeCtrl = (ExecutionController)bundleContext.getService(ref);
                    if (exeCtrl != null) {
                        return (T)exeCtrl;
                    }
                    ++n2;
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            LogFactory.getLog(LocalExecutionControllerUtilsServiceImpl.class).error((Object)StringUtils.format((String)"Filter '%s' is not valid", (Object[])new Object[]{filter}));
        }
        catch (IllegalStateException e) {
            LogFactory.getLog(LocalExecutionControllerUtilsServiceImpl.class).warn((Object)"The software bundle providing this workflow component is unavailable; if this happens at any other time than shutdown, it is an error", (Throwable)e);
        }
        throw new ExecutionControllerException(StringUtils.format((String)"Component or workflow (%s) (more precisely its execution controller) does not exist (anymore)", (Object[])new Object[]{executionId}));
    }

    private static String createPropertyFilter(String executionId) {
        return StringUtils.format((String)"(%s=%s)", (Object[])new Object[]{"rce.component.execution.id", executionId});
    }

    @Override
    public <T extends ExecutionController> Map<String, T> getExecutionControllers(Class<T> controllerInterface, BundleContext bundleContext) {
        HashMap<String, ExecutionController> exeControllers = new HashMap<String, ExecutionController>();
        String filter = null;
        try {
            ServiceReference[] serviceReferences = bundleContext.getServiceReferences(controllerInterface.getName(), filter);
            if (serviceReferences != null) {
                ServiceReference[] serviceReferenceArray = serviceReferences;
                int n = serviceReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference serviceRef = serviceReferenceArray[n2];
                    exeControllers.put((String)serviceRef.getProperty("rce.component.execution.id"), (ExecutionController)bundleContext.getService(serviceRef));
                    ++n2;
                }
            }
        }
        catch (InvalidSyntaxException e) {
            LogFactory.getLog(LocalExecutionControllerUtilsServiceImpl.class).error((Object)StringUtils.format((String)"Unexpected error", (Object[])new Object[0]), (Throwable)e);
        }
        return exeControllers;
    }
}

