/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common;

import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TempFileManager {
    public static final String FILENAME_PATTERN_PLACEHOLDER = "*";
    private static final String LOCK_FILE_NAME = "tmpdir.lock";
    private static final int MAX_ROOT_DIR_ANTI_COLLISION_ATTEMPTS = 20;
    private static final int MAX_TEMP_FILE_ANTI_COLLISION_ATTEMPTS = 10;
    private File globalRootDir;
    private File instanceRootDir;
    private File currentDirectoryForTempFiles;
    private FileLock instanceRootDirLock;
    private AtomicLong lastInstanceRootDirNumber = new AtomicLong(0L);
    private AtomicLong tempFileFromPatternSequenceNumber = new AtomicLong(0L);
    private Log log = LogFactory.getLog(TempFileManager.class);
    private final TempFileServiceImpl serviceImplementation;
    private final String instanceDirPrefix;

    protected TempFileManager(File globalRootDir, String instanceDirPrefix) throws IOException {
        this.setGlobalRootDir(globalRootDir);
        this.instanceDirPrefix = instanceDirPrefix;
        this.serviceImplementation = new TempFileServiceImpl();
    }

    protected TempFileManager(File globalRootDir, String instanceDirPrefix, boolean unitTest) throws IOException {
        this.setGlobalRootDir(globalRootDir);
        this.instanceDirPrefix = instanceDirPrefix;
        this.serviceImplementation = new TempFileServiceImpl();
        if (unitTest) {
            Runtime.getRuntime().addShutdownHook(new CleanUpShutdownHook());
        }
    }

    public synchronized void runGCOnGlobalRootDir() throws IOException {
        Collection<File> deleteSet = this.determineGCDeleteSetForGlobalRootDir();
        for (File childFolderToDelete : deleteSet) {
            this.log.info((Object)("GC: (simulation) deleting unused temp file folder " + childFolderToDelete.getCanonicalPath()));
        }
    }

    protected synchronized Collection<File> determineGCDeleteSetForGlobalRootDir() throws IOException {
        File dotDotOfGlobalRootDir = new File(this.globalRootDir, "..");
        if (!TempFileManager.isActualSubfolderOf(dotDotOfGlobalRootDir, this.globalRootDir)) {
            throw new IOException("Unsafe behaviour of File.getCanonicalPath(); not running garbage collection");
        }
        if (TempFileManager.isActualSubfolderOf(this.globalRootDir, dotDotOfGlobalRootDir)) {
            throw new IOException("Internal consistency violation of File.getCanonicalPath(); not running garbage collection");
        }
        this.log.debug((Object)"Tested proper detection of folder parent relations");
        List<File> globalRootContent = TempFileManager.getActualDirectoryContent(this.globalRootDir);
        for (File childElement : globalRootContent) {
            if (childElement.isDirectory()) continue;
            throw new IOException("Unexpected state: child element of root folder was not a directory (not running garbage collection): " + childElement.getAbsolutePath());
        }
        ArrayList<File> deleteSet = new ArrayList<File>();
        for (File childFolder : globalRootContent) {
            File lockFile = new File(childFolder, LOCK_FILE_NAME);
            FileLock testLock = this.attemptLock(lockFile);
            if (testLock != null) {
                deleteSet.add(childFolder);
                this.releaseLock(testLock);
                continue;
            }
            this.log.info((Object)("GC: identified active temp file folder " + childFolder.getCanonicalPath()));
        }
        return deleteSet;
    }

    private FileLock attemptLock(File lockFile) throws IOException, FileNotFoundException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(lockFile, "rw");
        try {
            FileLock testLock = randomAccessFile.getChannel().tryLock();
            return testLock;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            randomAccessFile.getChannel().close();
            randomAccessFile.close();
            return null;
        }
    }

    private void releaseLock(FileLock testLock) throws IOException {
        testLock.release();
        testLock.channel().close();
    }

    protected synchronized File getGlobalRootDir() {
        return this.globalRootDir;
    }

    protected TempFileServiceImpl getServiceImplementation() {
        return this.serviceImplementation;
    }

    protected static List<File> getActualDirectoryContent(File parentDir) {
        File[] filesInGlobalRoot = parentDir.listFiles();
        ArrayList<File> trueEntries = new ArrayList<File>();
        File[] fileArray = filesInGlobalRoot;
        int n = filesInGlobalRoot.length;
        int n2 = 0;
        while (n2 < n) {
            File entry = fileArray[n2];
            String name = entry.getName();
            if (!name.equals(".") && !name.equals("..")) {
                trueEntries.add(entry);
            }
            ++n2;
        }
        return trueEntries;
    }

    private synchronized void setGlobalRootDir(File newRootDir) throws IOException {
        if (this.instanceRootDirLock != null) {
            if (this.globalRootDir.getAbsolutePath().equals(newRootDir.getAbsolutePath())) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("New temp root directory is the same as the existing one; ignoring change request (" + newRootDir.getAbsolutePath() + ")"));
                }
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Releasing lock file in directory " + this.instanceRootDir.getAbsolutePath()));
            }
            this.releaseLock(this.instanceRootDirLock);
        }
        this.instanceRootDir = null;
        this.globalRootDir = newRootDir;
    }

    private File initializeInstanceRootDir() throws IOException {
        if (this.globalRootDir == null) {
            throw new IllegalStateException("Internal consistency error: initialized without a global root directory");
        }
        String finalPrefix = "";
        if (this.instanceDirPrefix != null && !this.instanceDirPrefix.isEmpty()) {
            finalPrefix = String.valueOf(this.instanceDirPrefix) + "-";
        }
        String timestamp = Long.toString(System.currentTimeMillis());
        int antiCollisionAttempt = 0;
        String antiCollisionSuffix = "";
        File newInstanceRootDir = null;
        while (antiCollisionAttempt < 20) {
            String instanceDirectoryName = StringUtils.format("%s%s%s", finalPrefix, timestamp, antiCollisionSuffix);
            newInstanceRootDir = new File(this.globalRootDir, instanceDirectoryName);
            if (!newInstanceRootDir.isDirectory() && newInstanceRootDir.mkdirs()) {
                return newInstanceRootDir;
            }
            antiCollisionSuffix = "(" + ++antiCollisionAttempt + ")";
        }
        if (newInstanceRootDir != null) {
            throw new IOException(StringUtils.format("Failed to create unique instance temp directory after %s attempts; last attempted path was %s", 20, newInstanceRootDir.getAbsolutePath()));
        }
        throw new IOException(StringUtils.format("Failed to create unique instance temp directory after %s attempts; last attempted path was null", 20));
    }

    private static boolean isActualSubfolderOf(File expectedInner, File expectedOuter) throws IOException {
        String canonicalExpectedOuter = expectedOuter.getCanonicalPath();
        String canonicalExpectedInner = expectedInner.getCanonicalPath();
        return canonicalExpectedInner.length() < canonicalExpectedOuter.length() && canonicalExpectedOuter.startsWith(canonicalExpectedInner);
    }

    private void deleteInstanceDirectoryForUnitTest() throws IOException {
        if (this.instanceRootDirLock != null) {
            this.instanceRootDirLock.release();
            this.instanceRootDirLock.channel().close();
        }
        if (this.instanceRootDir != null) {
            List files = (List)FileUtils.listFiles((File)this.instanceRootDir, null, (boolean)true);
            if (files.size() == 1 && ((File)files.get(0)).getName().equals(LOCK_FILE_NAME)) {
                FileUtils.deleteDirectory((File)this.instanceRootDir);
                this.log.info((Object)("Deleted instance directory: " + this.instanceRootDir.getAbsolutePath()));
            } else {
                this.log.warn((Object)("Did not delete temp directory: " + this.instanceRootDir.getAbsolutePath() + " since it is not empty."));
            }
        }
    }

    private final class CleanUpShutdownHook
    extends Thread {
        private CleanUpShutdownHook() {
        }

        @Override
        @TaskDescription(value="Shutdown hook to delete a root temp directory used by unit tests")
        public void run() {
            try {
                TempFileManager.this.deleteInstanceDirectoryForUnitTest();
            }
            catch (IOException e) {
                TempFileManager.this.log.info((Object)"Failed to delete Instance Directory", (Throwable)e);
            }
        }
    }

    protected final class TempFileServiceImpl
    implements TempFileService {
        protected TempFileServiceImpl() {
        }

        @Override
        public File createManagedTempDir() throws IOException {
            return this.createManagedTempDir(null);
        }

        @Override
        public File createManagedTempDir(String infoText) throws IOException {
            File tempDir;
            String tempDirName = Long.toString(TempFileManager.this.lastInstanceRootDirNumber.incrementAndGet());
            if (infoText != null && infoText.length() != 0) {
                tempDirName = String.valueOf(tempDirName) + "-" + infoText;
            }
            if (!(tempDir = new File(this.getInstanceRootDir(), tempDirName)).mkdirs()) {
                if (tempDir.isDirectory()) {
                    throw new IOException("Unexpected collision: New temporary directory does already exist: " + tempDir);
                }
                if (tempDir.isFile()) {
                    throw new IOException("Unexpected collision: New temporary directory is blocked by a equally-named file: " + tempDir);
                }
                throw new IOException("Failed to create new managed temporary directory (maybe lack of permissions, or the target drive is full?): " + tempDir);
            }
            return tempDir;
        }

        @Override
        public File createTempFileFromPattern(String filenamePattern) throws IOException {
            if (filenamePattern == null || filenamePattern.length() == 0) {
                throw new IllegalArgumentException("Filename pattern must not be empty");
            }
            if (!filenamePattern.contains(TempFileManager.FILENAME_PATTERN_PLACEHOLDER)) {
                throw new IllegalArgumentException("Filename pattern must contain the placeholder pattern *");
            }
            String tempPart = Long.toString(TempFileManager.this.tempFileFromPatternSequenceNumber.incrementAndGet());
            String filename = filenamePattern.replace(TempFileManager.FILENAME_PATTERN_PLACEHOLDER, tempPart);
            return this.createTempFileWithFixedFilename(filename);
        }

        @Override
        public synchronized File createTempFileWithFixedFilename(String filename) throws IOException {
            if (filename.contains("\\") || filename.contains("/")) {
                throw new IOException("Relative filenames are not allowed in this call");
            }
            if (TempFileManager.this.currentDirectoryForTempFiles == null || !TempFileManager.this.currentDirectoryForTempFiles.exists()) {
                TempFileManager.this.currentDirectoryForTempFiles = this.createManagedTempDir();
            }
            IOException lastException = null;
            int i = 0;
            while (i < 10) {
                File newFile = new File(TempFileManager.this.currentDirectoryForTempFiles, filename);
                try {
                    if (newFile.createNewFile()) {
                        return newFile;
                    }
                }
                catch (IOException e) {
                    lastException = e;
                    TempFileManager.this.log.debug((Object)("Collision while trying to create temporary file '" + newFile + "'; retrying, " + (i + 1) + " failed attempt(s) so far"));
                }
                TempFileManager.this.currentDirectoryForTempFiles = this.createManagedTempDir();
                ++i;
            }
            if (lastException != null) {
                throw new IOException("Giving up after 10 attempts to create a temporary file named '" + filename + "'; at least one I/O exception occurred while trying", lastException);
            }
            throw new IOException("Giving up after 10 attempts to create a temporary file named '" + filename + "'; no exception occurred");
        }

        @Override
        public File writeInputStreamToTempFile(InputStream is) throws IOException {
            File file = this.createTempFileFromPattern("stream-to-file-*");
            FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
            IOUtils.closeQuietly((InputStream)is);
            return file;
        }

        @Override
        public void disposeManagedTempDirOrFile(File tempFileOrDir) throws IOException {
            String rootPath;
            if (TempFileManager.this.instanceRootDir == null) {
                throw new IOException("disposeManagedTempDirOrFile() was called with no instanceRootDir set");
            }
            if (!tempFileOrDir.exists()) {
                TempFileManager.this.log.debug((Object)StringUtils.format("Skipping deletion of managed temporary file or directory '%s' since it does not exist (anymore).", tempFileOrDir.getCanonicalPath()));
                return;
            }
            String givenPath = tempFileOrDir.getCanonicalPath();
            if (!givenPath.startsWith(rootPath = TempFileManager.this.instanceRootDir.getCanonicalPath())) {
                throw new IOException(StringUtils.format("Temporary file or directory '%s' does not match the root temp directory '%s' -- ignoring delete request", givenPath, rootPath));
            }
            try {
                FileUtils.forceDelete((File)tempFileOrDir);
            }
            catch (IOException e) {
                throw new IOException("Error deleting temporary file or directory " + givenPath, e);
            }
        }

        protected synchronized File getInstanceRootDir() throws IOException {
            if (TempFileManager.this.instanceRootDir == null) {
                TempFileManager.this.instanceRootDir = TempFileManager.this.initializeInstanceRootDir();
                File lockFile = new File(TempFileManager.this.instanceRootDir, TempFileManager.LOCK_FILE_NAME);
                TempFileManager.this.instanceRootDirLock = TempFileManager.this.attemptLock(lockFile);
                if (TempFileManager.this.instanceRootDirLock == null) {
                    throw new IOException("Failed to acquire lock in new temporary directory: " + lockFile.getAbsolutePath());
                }
                if (TempFileManager.this.log.isDebugEnabled()) {
                    TempFileManager.this.log.debug((Object)StringUtils.format("Initialized top-level managed temp directory %s", TempFileManager.this.instanceRootDir.getAbsolutePath()));
                }
            }
            return TempFileManager.this.instanceRootDir;
        }

        protected synchronized File getGlobalRootDir() {
            return TempFileManager.this.globalRootDir;
        }
    }
}

