/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StringUtils {
    public static final String COMMON_VALID_INPUT_CHARSET_ERROR = "Invalid character: only letters, digits, space, and the characters _.,-+() are allowed";
    public static final String COMMON_VALID_INPUT_FIRST_CHARACTER_ERROR = "Invalid first character: it must be a letter, a digit, or the underscore (\"_\")";
    public static final String COMMON_VALID_INPUT_LAST_CHARACTER_ERROR = "Invalid last character";
    protected static final Pattern COMMON_VALID_INPUT_CHARSET_REGEXP = Pattern.compile("^[a-zA-Z0-9 _\\.,\\-\\+\\(\\)]*$");
    protected static final Pattern COMMON_VALID_INPUT_FIRST_CHARACTER_REGEXP = Pattern.compile("^[a-zA-Z0-9_].*");
    protected static final Pattern COMMON_VALID_INPUT_LAST_CHARACTER_REGEXP = Pattern.compile(".*[^ ]$");
    protected static final String SEPARATOR = ":";
    protected static final String ESCAPE_CHARACTER = "\\";
    protected static final String FORMAT_SEPARATOR = ", ";
    protected static final String EMPTY_ARRAY_PLACEHOLDER = "\\";
    protected static final String NULL_STRING_PLACEHOLDER = "\\0";
    private static final Log sharedLog = LogFactory.getLog(StringUtils.class);

    private StringUtils() {
    }

    private static String escapeCharacter(String rawString, char characterToEscape) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(rawString);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == characterToEscape) {
                result.append("\\");
                result.append(characterToEscape);
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    private static String unescapeCharacter(String escapedString, char characterToUnescape) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(escapedString);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == "\\".toCharArray()[0]) {
                character = iterator.next();
                if (character == characterToUnescape) {
                    result.append(characterToUnescape);
                } else {
                    result.append("\\");
                    result.append(character);
                }
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String escapeSeparator(String rawString) {
        return StringUtils.escapeCharacter(rawString, SEPARATOR.toCharArray()[0]);
    }

    public static String unescapeSeparator(String escapedString) {
        return StringUtils.unescapeCharacter(escapedString, SEPARATOR.toCharArray()[0]);
    }

    public static String[] splitAndUnescape(String completeString) {
        StringBuilder part = new StringBuilder();
        ArrayList<String> parts = new ArrayList<String>();
        int escapeCount = 0;
        if (completeString.equals("\\")) {
            return new String[0];
        }
        int i = 0;
        while (i < completeString.length()) {
            if (completeString.charAt(i) == "\\".charAt(0)) {
                ++escapeCount;
                part.append(completeString.charAt(i));
            } else if (completeString.charAt(i) == SEPARATOR.charAt(0)) {
                if (escapeCount % 2 == 0) {
                    parts.add(part.toString());
                    part = new StringBuilder();
                } else {
                    part.append(completeString.charAt(i));
                }
                escapeCount = 0;
            } else {
                part.append(completeString.charAt(i));
                escapeCount = 0;
            }
            ++i;
        }
        parts.add(part.toString());
        String[] partsArray = new String[parts.size()];
        partsArray = parts.toArray(partsArray);
        int i2 = 0;
        while (i2 < partsArray.length) {
            partsArray[i2] = StringUtils.unwrap(partsArray[i2]);
            ++i2;
        }
        return partsArray;
    }

    public static String escapeAndConcat(String ... parts) {
        if (parts.length == 0) {
            return "\\";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            String escapedPart = StringUtils.wrap(part);
            stringBuilder.append(escapedPart);
            stringBuilder.append(SEPARATOR);
            ++n2;
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public static String escapeAndConcat(List<String> parts) {
        return StringUtils.escapeAndConcat(parts.toArray(new String[parts.size()]));
    }

    public static String escapeAsJsonStringContent(String input, boolean addDoubleQuotes) {
        String escaped = input.replace("\\", "\\\\").replace("\"", "\\\"");
        if (addDoubleQuotes) {
            return StringUtils.format("\"%s\"", escaped);
        }
        return escaped;
    }

    public static String checkAgainstCommonInputRules(String input) {
        if (input.isEmpty()) {
            return null;
        }
        if (!COMMON_VALID_INPUT_CHARSET_REGEXP.matcher(input).matches()) {
            return COMMON_VALID_INPUT_CHARSET_ERROR;
        }
        if (!COMMON_VALID_INPUT_FIRST_CHARACTER_REGEXP.matcher(input).matches()) {
            return COMMON_VALID_INPUT_FIRST_CHARACTER_ERROR;
        }
        if (!COMMON_VALID_INPUT_LAST_CHARACTER_REGEXP.matcher(input).matches()) {
            return COMMON_VALID_INPUT_LAST_CHARACTER_ERROR;
        }
        return null;
    }

    public static String nullSafe(String text) {
        return StringUtils.nullSafe(text, "");
    }

    public static String nullSafe(String text, String defaultValue) {
        if (text != null) {
            return text;
        }
        return defaultValue;
    }

    public static int nullSafeParseInt(String input, int defaultValue) {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static String nullSafeToString(Object reference, String defaultValue) {
        if (reference != null) {
            return reference.toString();
        }
        return defaultValue;
    }

    private static String wrap(String input) {
        if (input == null) {
            return NULL_STRING_PLACEHOLDER;
        }
        String escapedPart = StringUtils.escapeCharacter(input, "\\".toCharArray()[0]);
        escapedPart = StringUtils.escapeSeparator(escapedPart);
        return escapedPart;
    }

    private static String unwrap(String wrapped) {
        if (NULL_STRING_PLACEHOLDER.equals(wrapped)) {
            return null;
        }
        String temp = StringUtils.unescapeSeparator(wrapped);
        temp = StringUtils.unescapeCharacter(temp, "\\".toCharArray()[0]);
        return temp;
    }

    /*
     * Unable to fully structure code
     */
    public static String format(String format, Object ... args) {
        block4: {
            result = null;
            try {
                result = String.format(format, args);
                break block4;
            }
            catch (IllegalFormatException v0) {
                values = "";
                i = 0;
                ** while (i < args.length)
            }
lbl-1000:
            // 1 sources

            {
                values = i == 0 ? values.concat(String.valueOf(args[i])) : values.concat(", " + String.valueOf(args[i]));
                ++i;
                continue;
            }
lbl12:
            // 1 sources

            result = format;
            if (!values.isEmpty()) {
                result = result.concat(", " + values);
            }
            StringUtils.sharedLog.warn((Object)StringUtils.format("Format error. Review the format string and the number of values.\n Format String: %s, Values: %s", new Object[]{format, values}));
        }
        return result;
    }

    public static boolean isNullorEmpty(String input) {
        return input == null || input.isEmpty();
    }
}

