/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.channel.internal;

import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSession;
import de.rcenvironment.core.communication.uplink.common.internal.DataStreamDownloadWrapper;
import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.entities.ToolDocumentationResponse;
import de.rcenvironment.core.communication.uplink.network.channel.internal.AbstractChannelEndpoint;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.utils.common.SizeValidatedDataSource;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.util.Optional;
import java.util.function.Consumer;

public class DocumentationChannelInitiatorEndpoint
extends AbstractChannelEndpoint {
    private Consumer<Optional<SizeValidatedDataSource>> documentationReceiver;
    private DataStreamDownloadWrapper<SizeValidatedDataSource> downloadWrapper;

    public DocumentationChannelInitiatorEndpoint(ClientSideUplinkSession session, long channelId, Consumer<Optional<SizeValidatedDataSource>> documentationReceiver) {
        super(session, session.getLocalSessionId(), channelId);
        this.documentationReceiver = documentationReceiver;
    }

    @Override
    protected synchronized boolean processMessageInternal(MessageBlock messageBlock) throws IOException {
        MessageType messageType = messageBlock.getType();
        switch (messageType) {
            case TOOL_DOCUMENTATION_RESPONSE: {
                if (this.downloadWrapper != null) {
                    throw new ProtocolException("Received more than one documentation response header");
                }
                ToolDocumentationResponse response = this.messageConverter.decodeDocumentationResponse(messageBlock);
                if (response.isAvailable()) {
                    this.downloadWrapper = new DataStreamDownloadWrapper<SizeValidatedDataSource>(){

                        @Override
                        public SizeValidatedDataSource createReturnObject(long size, PipedInputStream inputStream) {
                            return new SizeValidatedDataSource(size, (InputStream)inputStream);
                        }
                    };
                    SizeValidatedDataSource downloadStream = this.downloadWrapper.initialize(response.getSize(), MessageType.TOOL_DOCUMENTATION_CONTENT);
                    this.documentationReceiver.accept(Optional.of(downloadStream));
                } else {
                    this.documentationReceiver.accept(Optional.empty());
                }
                return true;
            }
            case TOOL_DOCUMENTATION_CONTENT: {
                if (this.downloadWrapper == null) {
                    throw new ProtocolException("Received documentation data without preceding header");
                }
                if (!this.downloadWrapper.processMessageBlock(messageBlock)) {
                    this.log.debug((Object)"Completed documentation download, closing channel");
                    return false;
                }
                return true;
            }
        }
        throw new ProtocolException("Received unexpected message type " + (Object)((Object)messageType));
    }

    @Override
    public void dispose() {
    }
}

