/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.client.session.impl;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import de.rcenvironment.core.communication.uplink.client.session.api.UplinkConnection;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshUplinkConnectionImpl
implements UplinkConnection {
    private final Session sshSession;
    private ChannelExec executionChannel;
    private OutputStream outputStream;
    private InputStream inputStream;
    private boolean closed;
    private final Log log = LogFactory.getLog(this.getClass());

    public SshUplinkConnectionImpl(Session sshSession) {
        this.sshSession = sshSession;
    }

    @Override
    public synchronized void open(Consumer<String> errorConsumer) throws IOException {
        if (this.executionChannel != null) {
            throw new IllegalStateException("Cannot be started while already running");
        }
        try {
            this.executionChannel = (ChannelExec)this.sshSession.openChannel("exec");
            this.outputStream = this.executionChannel.getOutputStream();
            this.executionChannel.setCommand("ra uplink");
            this.inputStream = this.executionChannel.getInputStream();
            InputStream errorStream = this.executionChannel.getErrStream();
            ConcurrencyUtils.getAsyncTaskService().execute("SSH Uplink: monitor incoming error stream", () -> {
                block3: {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream));
                    try {
                        String message;
                        while ((message = reader.readLine()) != null) {
                            errorConsumer.accept(message);
                        }
                    }
                    catch (IOException e) {
                        if (e instanceof EOFException) break block3;
                        errorConsumer.accept("Error stream watcher terminated unexpectedly: " + e.toString());
                    }
                }
            });
            this.executionChannel.connect();
        }
        catch (JSchException e) {
            this.executionChannel = null;
            throw new IOException(e);
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        OutputStream outputStream = this.outputStream;
        synchronized (outputStream) {
            try {
                if (this.outputStream != null) {
                    this.outputStream.close();
                } else {
                    this.log.debug((Object)"Unexpected null stream");
                }
            }
            catch (IOException e) {
                this.log.debug((Object)("Non-critical exception closing the connection output stream before shutdown: " + e));
            }
        }
        if (this.executionChannel != null && this.executionChannel.isConnected()) {
            this.executionChannel.disconnect();
        }
        if (this.sshSession != null && this.sshSession.isConnected()) {
            this.sshSession.disconnect();
        }
        this.closed = true;
    }
}

