/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal;

import com.googlecode.lanterna.LanternaException;
import com.googlecode.lanterna.input.InputDecoder;
import com.googlecode.lanterna.input.InputProvider;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.input.KeyMappingProfile;
import com.googlecode.lanterna.terminal.AbstractTerminal;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;

public abstract class InputEnabledAbstractTerminal
extends AbstractTerminal
implements InputProvider {
    private final InputDecoder inputDecoder;
    private final Queue<Key> keyQueue;
    private final Object readMutex;

    public InputEnabledAbstractTerminal(InputDecoder inputDecoder) {
        this.inputDecoder = inputDecoder;
        this.keyQueue = new LinkedList<Key>();
        this.readMutex = new Object();
    }

    @Override
    public void addInputProfile(KeyMappingProfile profile) {
        this.inputDecoder.addProfile(profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TerminalSize waitForTerminalSizeReport(int timeoutMs) {
        long startTime = System.currentTimeMillis();
        Object object = this.readMutex;
        synchronized (object) {
            while (System.currentTimeMillis() - startTime < (long)timeoutMs) {
                Key key = this.inputDecoder.getNextCharacter();
                if (key == null) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                if (key.getKind() != Key.Kind.CursorLocation) {
                    this.keyQueue.add(key);
                    continue;
                }
                TerminalPosition reportedTerminalPosition = this.inputDecoder.getLastReportedTerminalPosition();
                if (reportedTerminalPosition == null) {
                    throw new LanternaException(new IOException("Unexpected: inputDecoder.getLastReportedTerminalPosition() returned null after position was reported"));
                }
                this.onResized(reportedTerminalPosition.getColumn(), reportedTerminalPosition.getRow());
                return new TerminalSize(reportedTerminalPosition.getColumn(), reportedTerminalPosition.getRow());
            }
        }
        throw new LanternaException(new IOException("Timeout while waiting for terminal size report! Maybe your terminal doesn't support cursor position report, please consider using a custom size querier"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key readInput() {
        Object object = this.readMutex;
        synchronized (object) {
            if (!this.keyQueue.isEmpty()) {
                return this.keyQueue.poll();
            }
            Key key = this.inputDecoder.getNextCharacter();
            if (key != null && key.getKind() == Key.Kind.CursorLocation) {
                TerminalPosition reportedTerminalPosition = this.inputDecoder.getLastReportedTerminalPosition();
                if (reportedTerminalPosition != null) {
                    this.onResized(reportedTerminalPosition.getColumn(), reportedTerminalPosition.getRow());
                }
                return this.readInput();
            }
            return key;
        }
    }
}

