/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import com.googlecode.lanterna.gui.TextGraphics;
import com.googlecode.lanterna.gui.component.ActivityIndicator;
import com.googlecode.lanterna.screen.ScreenCharacterStyle;
import com.googlecode.lanterna.terminal.TerminalSize;
import java.util.HashSet;

public class SpinningActivityIndicator
extends ActivityIndicator {
    public static char[] BARS = new char[]{'-', '\\', '|', '/'};
    public static char[] CHEVRONS = new char[]{'^', '>', 'V', '<'};
    public static char[] DICE = new char[]{'\u2680', '\u2681', '\u2682', '\u2683', '\u2684', '\u2685'};
    public static char[] TRIGRAMS = new char[]{'\u2630', '\u2631', '\u2632', '\u2633', '\u2634', '\u2635', '\u2636', '\u2637'};
    private static char[] states = BARS;
    private static int index = 0;

    public SpinningActivityIndicator() {
        this(BARS);
    }

    public SpinningActivityIndicator(char[] chars) {
        HashSet<Character> set = new HashSet<Character>();
        char[] arr$ = chars;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character ch = Character.valueOf(arr$[i$]);
            set.add(ch);
        }
        if (set.size() < 2) {
            throw new IllegalArgumentException("you must use at least two different characters");
        }
        states = chars;
        index = 0;
    }

    @Override
    public void tick() {
        if (++index >= states.length) {
            index = 0;
        }
        this.invalidate();
    }

    @Override
    public void clear() {
        index = -1;
    }

    @Override
    public void repaint(TextGraphics graphics) {
        if (index >= 0) {
            graphics.drawString(0, 0, states[index] + "", new ScreenCharacterStyle[0]);
        } else {
            graphics.drawString(0, 0, " ", new ScreenCharacterStyle[0]);
        }
    }

    @Override
    protected TerminalSize calculatePreferredSize() {
        return new TerminalSize(1, 1);
    }
}

