/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import com.googlecode.lanterna.gui.TextGraphics;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.gui.component.AbstractComponent;
import com.googlecode.lanterna.screen.ScreenCharacterStyle;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;

public class ProgressBar
extends AbstractComponent {
    private final int preferredWidth;
    private double progress;
    private char fill_complete_char = (char)9608;
    private char fill_remaining_char = (char)32;
    private boolean show_percentage = true;

    public ProgressBar(int preferredWidth) {
        this.preferredWidth = preferredWidth;
        this.progress = 0.0;
    }

    @Override
    protected TerminalSize calculatePreferredSize() {
        return new TerminalSize(this.preferredWidth, 1);
    }

    @Override
    public void repaint(TextGraphics graphics) {
        int bar_start = this.isCompletedPercentageShown() ? 5 : 0;
        int total_width = graphics.getWidth() - bar_start;
        int highlighted_blocks = (int)((double)total_width * this.progress);
        if (this.isCompletedPercentageShown()) {
            graphics.applyTheme(Theme.Category.BUTTON_LABEL_INACTIVE);
            Integer percentage = (int)Math.round(this.progress * 100.0);
            String perc_str = percentage == 100 ? percentage + "%" : (percentage >= 10 ? " " + percentage + "%" : "  " + percentage + "%");
            graphics.drawString(0, 0, perc_str, new ScreenCharacterStyle[0]);
        }
        graphics.applyTheme(Theme.Category.PROGRESS_BAR_COMPLETED);
        graphics.fillRectangle(this.fill_complete_char, new TerminalPosition(bar_start, 0), new TerminalSize(bar_start + highlighted_blocks, 1));
        graphics.applyTheme(Theme.Category.PROGRESS_BAR_REMAINING);
        graphics.fillRectangle(this.fill_remaining_char, new TerminalPosition(bar_start + highlighted_blocks, 0), new TerminalSize(total_width - highlighted_blocks, 1));
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
        this.invalidate();
    }

    public void setCompleteFillChar(char fill) {
        this.fill_complete_char = fill;
        this.invalidate();
    }

    public char getCompleteFillChar() {
        return this.fill_complete_char;
    }

    public void setRemainingFillChar(char fill) {
        this.fill_remaining_char = fill;
        this.invalidate();
    }

    public char getRemainingFillChar() {
        return this.fill_remaining_char;
    }

    public void setCompletedPercentageShown(boolean flag) {
        this.show_percentage = flag;
        this.invalidate();
    }

    public boolean isCompletedPercentageShown() {
        return this.show_percentage;
    }
}

