/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui;

import com.googlecode.lanterna.gui.Action;
import com.googlecode.lanterna.gui.DefaultBackgroundRenderer;
import com.googlecode.lanterna.gui.GUIScreenBackgroundRenderer;
import com.googlecode.lanterna.gui.TextGraphics;
import com.googlecode.lanterna.gui.TextGraphicsImpl;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.gui.Window;
import com.googlecode.lanterna.gui.listener.WindowAdapter;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.screen.Screen;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class GUIScreen {
    private final Screen screen;
    private final LinkedList<WindowPlacement> windowStack;
    protected final Queue<Action> actionToRunInEventThread;
    private GUIScreenBackgroundRenderer backgroundRenderer;
    private Theme guiTheme;
    private boolean needsRefresh;
    private Thread eventThread;

    public GUIScreen(Screen screen) {
        this(screen, "");
    }

    public GUIScreen(Screen screen, String title) {
        this(screen, new DefaultBackgroundRenderer(title));
    }

    public GUIScreen(Screen screen, GUIScreenBackgroundRenderer backgroundRenderer) {
        if (backgroundRenderer == null) {
            throw new IllegalArgumentException("backgroundRenderer cannot be null");
        }
        this.backgroundRenderer = backgroundRenderer;
        this.screen = screen;
        this.guiTheme = Theme.getDefaultTheme();
        this.windowStack = new LinkedList();
        this.actionToRunInEventThread = new LinkedList<Action>();
        this.needsRefresh = false;
        this.eventThread = Thread.currentThread();
    }

    @Deprecated
    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        if (this.backgroundRenderer instanceof DefaultBackgroundRenderer) {
            ((DefaultBackgroundRenderer)this.backgroundRenderer).setTitle(title);
        }
    }

    public void setTheme(Theme newTheme) {
        if (newTheme == null) {
            return;
        }
        this.guiTheme = newTheme;
        this.needsRefresh = true;
    }

    public void setBackgroundRenderer(GUIScreenBackgroundRenderer backgroundRenderer) {
        if (backgroundRenderer == null) {
            throw new IllegalArgumentException("backgroundRenderer cannot be null");
        }
        this.backgroundRenderer = backgroundRenderer;
        this.needsRefresh = true;
    }

    public GUIScreenBackgroundRenderer getBackgroundRenderer() {
        return this.backgroundRenderer;
    }

    public Screen getScreen() {
        return this.screen;
    }

    private synchronized void repaint() {
        if (this.screen.resizePending()) {
            this.screen.refresh();
        }
        TextGraphicsImpl textGraphics = new TextGraphicsImpl(new TerminalPosition(0, 0), new TerminalSize(this.screen.getTerminalSize()), this.screen, this.guiTheme);
        this.backgroundRenderer.drawBackground(textGraphics);
        int screenSizeColumns = this.screen.getTerminalSize().getColumns();
        int screenSizeRows = this.screen.getTerminalSize().getRows();
        for (WindowPlacement windowPlacement : this.windowStack) {
            if (this.hasSoloWindowAbove(windowPlacement) || this.hasFullScreenWindowAbove(windowPlacement)) continue;
            TerminalPosition topLeft = windowPlacement.getTopLeft();
            TerminalSize preferredSize = windowPlacement.getPositionPolicy() == Position.FULL_SCREEN ? new TerminalSize(screenSizeColumns, screenSizeRows) : windowPlacement.getWindow().getPreferredSize();
            if (windowPlacement.positionPolicy == Position.CENTER) {
                if (windowPlacement.getWindow().maximisesHorisontally()) {
                    topLeft.setColumn(2);
                } else {
                    topLeft.setColumn(screenSizeColumns / 2 - preferredSize.getColumns() / 2);
                }
                if (windowPlacement.getWindow().maximisesVertically()) {
                    topLeft.setRow(1);
                } else {
                    topLeft.setRow(screenSizeRows / 2 - preferredSize.getRows() / 2);
                }
            }
            int maxSizeWidth = screenSizeColumns - windowPlacement.getTopLeft().getColumn() - 1;
            int maxSizeHeight = screenSizeRows - windowPlacement.getTopLeft().getRow() - 1;
            if (preferredSize.getColumns() > maxSizeWidth || windowPlacement.getWindow().maximisesHorisontally()) {
                preferredSize.setColumns(maxSizeWidth);
            }
            if (preferredSize.getRows() > maxSizeHeight || windowPlacement.getWindow().maximisesVertically()) {
                preferredSize.setRows(maxSizeHeight);
            }
            if (windowPlacement.getPositionPolicy() == Position.FULL_SCREEN) {
                preferredSize.setColumns(preferredSize.getColumns() + 1);
                preferredSize.setRows(preferredSize.getRows() + 1);
            }
            if (topLeft.getColumn() < 0) {
                topLeft.setColumn(0);
            }
            if (topLeft.getRow() < 0) {
                topLeft.setRow(0);
            }
            TextGraphics subGraphics = textGraphics.subAreaGraphics(topLeft, new TerminalSize(preferredSize.getColumns(), preferredSize.getRows()));
            if (windowPlacement.getWindow().isDrawShadow()) {
                textGraphics.applyTheme(this.guiTheme.getDefinition(Theme.Category.SHADOW));
                textGraphics.fillRectangle(' ', new TerminalPosition(topLeft.getColumn() + 2, topLeft.getRow() + 1), new TerminalSize(subGraphics.getWidth(), subGraphics.getHeight()));
            }
            windowPlacement.getWindow().repaint(subGraphics);
        }
        if (this.windowStack.size() > 0 && this.windowStack.getLast().getWindow().getWindowHotspotPosition() != null) {
            this.screen.setCursorPosition(this.windowStack.getLast().getWindow().getWindowHotspotPosition());
        } else {
            this.screen.setCursorPosition(null);
        }
        this.screen.refresh();
    }

    protected boolean update() {
        if (this.needsRefresh || this.screen.resizePending()) {
            this.repaint();
            this.needsRefresh = false;
            return true;
        }
        return false;
    }

    protected Queue<Action> getActionsToRunInEventThreadQueue() {
        return this.actionToRunInEventThread;
    }

    public void invalidate() {
        this.needsRefresh = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doEventLoop() {
        int currentStackLength = this.windowStack.size();
        if (currentStackLength == 0) {
            return;
        }
        while (currentStackLength <= this.windowStack.size()) {
            ArrayList<Action> actions = null;
            Queue<Action> queue = this.actionToRunInEventThread;
            synchronized (queue) {
                if (!this.actionToRunInEventThread.isEmpty()) {
                    actions = new ArrayList<Action>(this.actionToRunInEventThread);
                    this.actionToRunInEventThread.clear();
                }
            }
            if (actions != null) {
                for (Action nextAction : actions) {
                    try {
                        nextAction.doAction();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            this.windowStack.getLast().window.checkFocus();
            boolean repainted = this.update();
            Key nextKey = this.screen.readInput();
            if (nextKey != null) {
                if (nextKey.getKind() == Key.Kind.EOF) break;
                this.windowStack.getLast().window.onKeyPressed(nextKey);
                this.invalidate();
                continue;
            }
            if (repainted) continue;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {}
        }
    }

    public void showWindow(Window window) {
        this.showWindow(window, Position.OVERLAPPING);
    }

    public void showWindow(Window window, Position position) {
        WindowPlacement lastWindow;
        if (window == null) {
            return;
        }
        if (position == null) {
            position = Position.OVERLAPPING;
        }
        int newWindowX = 2;
        int newWindowY = 1;
        if (position == Position.OVERLAPPING && this.windowStack.size() > 0 && (lastWindow = this.windowStack.getLast()).getPositionPolicy() != Position.CENTER) {
            newWindowX = lastWindow.getTopLeft().getColumn() + 2;
            newWindowY = lastWindow.getTopLeft().getRow() + 1;
        }
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void onWindowInvalidated(Window window) {
                GUIScreen.this.needsRefresh = true;
            }
        });
        this.windowStack.add(new WindowPlacement(window, position, new TerminalPosition(newWindowX, newWindowY)));
        window.setOwner(this);
        window.onVisible();
        this.needsRefresh = true;
        this.doEventLoop();
    }

    @Deprecated
    public void closeWindow() {
        Window activeWindow = this.getActiveWindow();
        if (activeWindow != null) {
            activeWindow.close();
        }
    }

    protected void closeWindow(Window window) {
        if (this.windowStack.size() == 0) {
            return;
        }
        Iterator iterator = this.windowStack.iterator();
        while (iterator.hasNext()) {
            WindowPlacement placement = (WindowPlacement)iterator.next();
            if (placement.window != window) continue;
            iterator.remove();
            placement.window.onClosed();
            return;
        }
    }

    public Window getActiveWindow() {
        if (this.windowStack.isEmpty()) {
            return null;
        }
        return this.windowStack.getLast().getWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInEventThread(Action codeToRun) {
        Queue<Action> queue = this.actionToRunInEventThread;
        synchronized (queue) {
            this.actionToRunInEventThread.add(codeToRun);
        }
    }

    public boolean isInEventThread() {
        return this.eventThread == Thread.currentThread();
    }

    private boolean hasSoloWindowAbove(WindowPlacement windowPlacement) {
        int index = this.windowStack.indexOf(windowPlacement);
        for (int i = index + 1; i < this.windowStack.size(); ++i) {
            if (!this.windowStack.get(i).window.isSoloWindow()) continue;
            return true;
        }
        return false;
    }

    private boolean hasFullScreenWindowAbove(WindowPlacement windowPlacement) {
        int index = this.windowStack.indexOf(windowPlacement);
        for (int i = index + 1; i < this.windowStack.size(); ++i) {
            if (this.windowStack.get(i).positionPolicy != Position.FULL_SCREEN) continue;
            return true;
        }
        return false;
    }

    private class WindowPlacement {
        private Window window;
        private Position positionPolicy;
        private TerminalPosition topLeft;

        public WindowPlacement(Window window, Position positionPolicy, TerminalPosition topLeft) {
            this.window = window;
            this.positionPolicy = positionPolicy;
            this.topLeft = topLeft;
        }

        public TerminalPosition getTopLeft() {
            if (this.positionPolicy == Position.FULL_SCREEN) {
                return new TerminalPosition(0, 0);
            }
            return this.topLeft;
        }

        public void setTopLeft(TerminalPosition topLeft) {
            this.topLeft = topLeft;
        }

        public Window getWindow() {
            return this.window;
        }

        public void setWindow(Window window) {
            this.window = window;
        }

        public Position getPositionPolicy() {
            return this.positionPolicy;
        }
    }

    public static enum Position {
        OVERLAPPING,
        NEW_CORNER_WINDOW,
        CENTER,
        FULL_SCREEN;

    }
}

