/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.wizards.exampleproject;

import de.rcenvironment.core.component.integration.ToolIntegrationService;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.wizards.exampleproject.NewExampleProjectWizard;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class NewExampleProjectWizardPage
extends WizardPage {
    public static final int COPY_EXAMPLE_TOOL = 1;
    public static final int DONT_COPY_EXAMPLE_TOOL = 0;
    public static final int RED_X_CANCELD = -1;
    private static final int MINIMUM_HEIGHT = 250;
    private static final int MINIMUM_WIDTH = 500;
    private static final String ASTERISK = "*";
    private static final int MINUS_ONE = -1;
    private static final String EXAMPLE_TOOL_NAME = "Example";
    private Text textFieldProjectName;
    private NewExampleProjectWizard newExampleProjectWizard;
    private Button createExampleIntegratedToolButton;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ServiceRegistryAccess serviceRegistryAccess;
    private Group toolIntegrationGroup;

    public NewExampleProjectWizardPage(ISelection selection, NewExampleProjectWizard newExampleProjectWizard) {
        super("wizardPage");
        this.setTitle("Create Workflow Examples Project");
        this.setDescription("This wizard generates an example project containing example workflows.");
        this.newExampleProjectWizard = newExampleProjectWizard;
        this.serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("Project &Name:");
        this.textFieldProjectName = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.textFieldProjectName.setLayoutData((Object)gd);
        this.textFieldProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewExampleProjectWizardPage.this.dialogChanged();
            }
        });
        this.toolIntegrationGroup = new Group(container, 0);
        GridData gridDataHorizontalSpan2 = new GridData(768);
        gridDataHorizontalSpan2.horizontalSpan = 2;
        this.toolIntegrationGroup.setLayoutData((Object)gridDataHorizontalSpan2);
        this.toolIntegrationGroup.setLayout((Layout)new GridLayout(2, false));
        this.toolIntegrationGroup.setText("Tool Integration Example");
        this.createExampleIntegratedToolButton = new Button((Composite)this.toolIntegrationGroup, 32);
        this.createExampleIntegratedToolButton.setText("Integrate example tool");
        this.createExampleIntegratedToolButton.setLayoutData((Object)gridDataHorizontalSpan2);
        if (this.integratedComponentIdExists(".+(?<!common)\\.Example")) {
            GridData gridDataVerticalTop = new GridData(2);
            Label warningIcon = new Label((Composite)this.toolIntegrationGroup, 0);
            warningIcon.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.WARNING_16));
            warningIcon.setLayoutData((Object)gridDataVerticalTop);
            GridData gridDataText = new GridData(768);
            gridDataText.widthHint = 500;
            Text componentExistsInformationText = new Text((Composite)this.toolIntegrationGroup, 0x40000042);
            componentExistsInformationText.setText(StringUtils.format((String)"A workflow component with the name '%1$s' already exists in your profile.\nSince dublicate names are not allowed and this component is not integrated as a common tool, the example tool cannot be integrated.\nPlease rename the existing '%1$s' component and try again.", (Object[])new Object[]{EXAMPLE_TOOL_NAME}));
            componentExistsInformationText.setLayoutData((Object)gridDataText);
            componentExistsInformationText.setEditable(false);
            this.createExampleIntegratedToolButton.setEnabled(false);
        }
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
        this.getShell().setMinimumSize(500, 250);
    }

    private void initialize() {
        this.textFieldProjectName.setText(this.newExampleProjectWizard.getProjectDefaultName());
    }

    private void dialogChanged() {
        String newProjectName = this.textFieldProjectName.getText();
        if (newProjectName.length() == 0) {
            this.updateStatus("Please chose a name for the new project");
            return;
        }
        IProject existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(newProjectName);
        if (existingProject != null && existingProject.exists()) {
            this.updateStatus("This project name is already in use");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getNewProjectName() {
        return this.textFieldProjectName.getText();
    }

    private boolean integratedComponentIdExists(String regex) {
        ToolIntegrationService integrationService = (ToolIntegrationService)this.serviceRegistryAccess.getService(ToolIntegrationService.class);
        return integrationService.getIntegratedComponentIds().stream().anyMatch(toolID -> toolID.matches(regex));
    }

    public int getCreateTIExample() {
        boolean isSelected;
        block5: {
            int overwrite;
            block6: {
                isSelected = this.createExampleIntegratedToolButton.getSelection();
                try {
                    if (!isSelected || !this.integratedComponentIdExists(".+(common)\\.Example") && !this.checkOrDeleteExampleToolConfigOnDisk(false)) break block5;
                    MessageDialog dialog = new MessageDialog(this.getShell(), "Overwrite Example Tool Confirmation", null, "An integrated tool named 'Example' already exists.\nReplace or keep it?", 4, new String[]{"Replace", "Keep"}, 1);
                    overwrite = dialog.open();
                    if (overwrite != 0) break block6;
                    this.checkOrDeleteExampleToolConfigOnDisk(true);
                    return 1;
                }
                catch (IOException e) {
                    this.log.error((Object)"Could not verify existence of example tool (I/O Error)", (Throwable)e);
                    return 0;
                }
            }
            if (overwrite == 1) {
                return 0;
            }
            return -1;
        }
        if (isSelected) {
            return 1;
        }
        return 0;
    }

    private boolean checkOrDeleteExampleToolConfigOnDisk(boolean delete) throws IOException {
        Bundle bundle = Platform.getBundle((String)this.newExampleProjectWizard.getPluginID());
        ConfigurationService configurationService = (ConfigurationService)this.serviceRegistryAccess.getService(ConfigurationService.class);
        File integrationFolder = configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_INTEGRATION_DATA);
        File commonsFolder = new File(new File(integrationFolder, "tools"), "common");
        boolean exampleToolExists = false;
        if (!commonsFolder.exists()) {
            return false;
        }
        Enumeration toolFiles = bundle.findEntries("templates/integration_example", ASTERISK, true);
        while (toolFiles.hasMoreElements()) {
            URL elementURL = (URL)toolFiles.nextElement();
            String rawPath = elementURL.getPath();
            String targetPath = rawPath.replaceFirst("^/templates/\\w+/", "");
            File target = new File(commonsFolder, targetPath);
            if (!(delete || !target.exists() || target.isDirectory() && rawPath.endsWith("/"))) {
                int data;
                InputStream downloadStream = elementURL.openStream();
                FileInputStream oldFileStream = FileUtils.openInputStream((File)target);
                BufferedInputStream bDownloadStream = new BufferedInputStream(downloadStream);
                BufferedInputStream bOldFileStream = new BufferedInputStream(oldFileStream);
                while ((data = bDownloadStream.read()) != -1) {
                    if (data == bOldFileStream.read()) continue;
                    exampleToolExists = true;
                }
                if (bOldFileStream.read() == -1) continue;
                exampleToolExists = true;
                continue;
            }
            if (!delete || !target.exists() || !target.isDirectory()) continue;
            try {
                FileUtils.deleteDirectory((File)target);
            }
            catch (IOException iOException) {
                this.log.info((Object)StringUtils.format((String)"Could not delete directory %s, maybe already deleted.", (Object[])new Object[]{target}));
            }
        }
        return exampleToolExists;
    }
}

