/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.internal;

import de.rcenvironment.core.monitoring.system.api.model.AverageOfDoubles;

public final class RingBufferOfDouble {
    private final double[] elements;
    private final int capacity;
    private int nextInsertPos;
    private int currentElementCount;

    public RingBufferOfDouble(int capacity) {
        this.capacity = capacity;
        this.elements = new double[capacity];
    }

    public void add(double element) {
        this.elements[this.nextInsertPos] = element;
        this.nextInsertPos = (this.nextInsertPos + 1) % this.capacity;
        this.currentElementCount = Math.min(this.currentElementCount + 1, this.capacity);
    }

    public AverageOfDoubles getAverageOfLatest(int maxElements) {
        int numElementsToInclude = Math.min(maxElements, this.currentElementCount);
        if (numElementsToInclude == 0) {
            return new AverageOfDoubles();
        }
        double sum = 0.0;
        int i = 0;
        int pos = (this.nextInsertPos - numElementsToInclude + this.capacity) % this.capacity;
        while (i < numElementsToInclude) {
            sum += this.elements[pos];
            ++i;
            pos = (pos + 1) % this.capacity;
        }
        return new AverageOfDoubles(numElementsToInclude, sum / (double)numElementsToInclude);
    }
}

