/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.export.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rcenvironment.core.datamanagement.commons.ComponentInstance;
import de.rcenvironment.core.datamanagement.commons.ComponentRun;
import de.rcenvironment.core.datamanagement.commons.WorkflowRun;
import de.rcenvironment.core.datamanagement.export.matching.MatchResult;
import de.rcenvironment.core.datamanagement.export.matching.Matchable;
import de.rcenvironment.core.datamanagement.export.matching.Matcher;
import de.rcenvironment.core.datamanagement.export.objects.PlainComponentInstance;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.FinalWorkflowState;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlainWorkflowRun
implements Matchable<PlainWorkflowRun> {
    @JsonProperty
    private String title;
    @JsonProperty
    private FinalWorkflowState finalState;
    @JsonProperty(value="components")
    private List<PlainComponentInstance> plainComponentInstances;

    public PlainWorkflowRun() {
    }

    public PlainWorkflowRun(WorkflowRun workflowRun, TypedDatumSerializer serializer) {
        this.title = workflowRun.getWorkflowTitle();
        this.finalState = workflowRun.getFinalState();
        this.plainComponentInstances = new LinkedList<PlainComponentInstance>();
        Map<ComponentInstance, Set<ComponentRun>> componentRunsMap = workflowRun.getComponentRuns();
        for (Map.Entry<ComponentInstance, Set<ComponentRun>> entry : componentRunsMap.entrySet()) {
            this.plainComponentInstances.add(new PlainComponentInstance(entry.getKey(), entry.getValue(), serializer));
        }
        this.plainComponentInstances.sort(null);
    }

    @Override
    public MatchResult matches(Map<DataType, Matcher> matchers, PlainWorkflowRun expected) {
        MatchResult result = new MatchResult();
        if (!this.finalState.equals((Object)expected.finalState)) {
            result.addFailureCause(StringUtils.format((String)"The final state %s does not match %s", (Object[])new Object[]{this.finalState, expected.finalState}));
        }
        if (this.plainComponentInstances.size() == expected.plainComponentInstances.size()) {
            int i = 0;
            while (i < this.plainComponentInstances.size()) {
                MatchResult nestedMatchResult = this.plainComponentInstances.get(i).matches(matchers, expected.plainComponentInstances.get(i));
                if (!nestedMatchResult.hasMatched()) {
                    result.addFailureCause(StringUtils.format((String)"Instance \"%s\" does not match the expected instance \"%s\".", (Object[])new Object[]{this.plainComponentInstances.get(i).getName(), expected.plainComponentInstances.get(i).getName()}), nestedMatchResult);
                }
                ++i;
            }
        } else {
            result.addFailureCause(StringUtils.format((String)"The number of instances %d do not match %d", (Object[])new Object[]{this.plainComponentInstances.size(), expected.plainComponentInstances.size()}));
        }
        return result;
    }
}

