/*
 * Decompiled with CFR 0.152.
 */
package nu.psnet.quickimage.core;

import java.io.File;
import nu.psnet.quickimage.core.QManager;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ImageHolder {
    private Image thumb;
    private Image fullsize;
    private IStorage storage;
    private File file;
    private String displayName = null;
    private Display display;
    private final int space = 16;
    private int absx;
    private int absy = 0;
    private final Point dim = new Point(140, 160);
    private boolean selected = false;
    private Color COLOR_GRAY;
    private Color COLOR_DARKBLUE;
    private QManager manager;
    private double imageSize = 0.0;
    static Font font;

    public ImageHolder(QManager manager, Display display) {
        this.manager = manager;
        this.display = display;
        this.COLOR_GRAY = display.getSystemColor(16);
        this.COLOR_DARKBLUE = display.getSystemColor(31);
        if (font == null) {
            try {
                font = new Font((Device)display, "", 8, 0);
            }
            catch (Exception exception) {
                font = display.getSystemFont();
            }
            this.dim.y = this.dim.x + font.getFontData()[0].getHeight() + 10;
        }
    }

    public Point getThumbDimension() {
        return this.dim;
    }

    public void drawThumb(GC gc, int inX, int inY) {
        int x = inX;
        int y = inY;
        try {
            if (this.thumb == null) {
                this.initThumb();
            }
            Color c = gc.getForeground();
            if (this.isSelected()) {
                gc.setLineWidth(3);
                gc.setForeground(this.COLOR_DARKBLUE);
            } else {
                gc.setForeground(this.COLOR_GRAY);
            }
            Rectangle rect = new Rectangle(x + 8, y + 8, this.dim.x - 16, this.dim.x - 16);
            Rectangle rectClip = new Rectangle(rect.x - 2, rect.y - 2, rect.width + 4, this.dim.y);
            gc.setClipping(rectClip);
            gc.drawRectangle(rect);
            gc.setFont(font);
            gc.setForeground(this.display.getSystemColor(2));
            gc.drawString(this.getDisplayName(), rect.x, rect.y + rect.height + 2, true);
            this.absx = x;
            this.absy = y;
            gc.drawImage(this.thumb, x += this.dim.x / 2 - this.thumb.getBounds().width / 2, y += this.dim.x / 2 - this.thumb.getBounds().height / 2);
            gc.setLineWidth(1);
            gc.setForeground(c);
        }
        catch (RuntimeException runtimeException) {
            this.replaceWithCannotDisplayImage();
            this.drawThumb(gc, inX, inY);
        }
    }

    public boolean mouseClickedOver(int x, int y) {
        return x > this.absx && x < this.absx + this.dim.x && y > this.absy && y < this.absy + this.dim.y;
    }

    public void drawFullsize(GC gc, int inX, int inY) {
        int x = inX;
        int y = inY;
        try {
            if (this.fullsize == null || this.fullsize.isDisposed()) {
                this.initFullsize();
            }
            gc.drawImage(this.fullsize, x, y);
        }
        catch (RuntimeException runtimeException) {
            this.replaceWithCannotDisplayImage();
            this.drawFullsize(gc, inX, inY);
        }
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
        this.setDisplayName(storage.getName());
    }

    public double getImageSize() {
        return this.imageSize;
    }

    public void setFile(File file) {
        this.file = file;
        this.setDisplayName(file.getName());
        this.imageSize = (double)file.length() / 1024.0;
    }

    private void initFullsize() throws RuntimeException {
        if (this.fullsize != null && !this.fullsize.isDisposed()) {
            this.fullsize.dispose();
        }
        ImageData data = null;
        if (this.file != null) {
            data = new ImageData(this.file.getAbsolutePath());
        } else {
            try {
                data = new ImageData(this.storage.getContents());
            }
            catch (CoreException e) {
                throw new RuntimeException("Could not load image from IStorage: " + e.getMessage());
            }
        }
        this.fullsize = new Image((Device)this.display, data);
    }

    public Image getFullsize() {
        try {
            if (this.fullsize == null || this.fullsize.isDisposed()) {
                this.initFullsize();
            }
        }
        catch (RuntimeException runtimeException) {
            this.replaceWithCannotDisplayImage();
            this.initFullsize();
        }
        return this.fullsize;
    }

    public boolean hasFullsize() {
        return this.fullsize != null && !this.fullsize.isDisposed();
    }

    private void initThumb() {
        if (this.thumb != null) {
            this.thumb.dispose();
        }
        ImageData data = new ImageData(this.file.getAbsolutePath());
        float w = 0.0f;
        float h = 0.0f;
        boolean doscale = false;
        if (data.height > this.dim.x - 32) {
            doscale = true;
            h = (float)(data.height - (this.dim.x - 32)) / (float)data.height;
        }
        if (data.width > this.dim.x - 32) {
            doscale = true;
            w = (float)(data.width - (this.dim.x - 32)) / (float)data.width;
        }
        if (doscale) {
            float scale = Math.max(w, h);
            w = (float)data.width - (float)data.width * scale;
            h = (float)data.height - (float)data.height * scale;
            if (w < 1.0f) {
                w = 1.0f;
            }
            if (h < 1.0f) {
                h = 1.0f;
            }
            data = data.scaledTo((int)w, (int)h);
        }
        this.thumb = new Image((Device)this.display, data);
    }

    public void dispose() {
        if (this.fullsize != null && !this.fullsize.isDisposed()) {
            this.fullsize.dispose();
        }
        if (this.thumb != null && !this.thumb.isDisposed()) {
            this.thumb.dispose();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    private void replaceWithCannotDisplayImage() {
        try {
            this.dispose();
            this.fullsize = null;
            this.thumb = null;
            String tmpName = this.getDisplayName();
            this.setFile(new File(String.valueOf(this.manager.getImageEditor().getIconsdir()) + "broken_image.gif"));
            this.setDisplayName(String.valueOf(tmpName) + " (image could not be displayed)");
        }
        catch (Exception exception) {
            this.manager.getImageOrganizer().removeHolder(this);
        }
    }
}

