/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.authorization.internal;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationPermissionSet;
import de.rcenvironment.core.authorization.internal.AuthorizationConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AuthorizationPermissionSetImpl
implements AuthorizationPermissionSet {
    private static final char SIGNATURE_SEPARATOR_CHAR = ',';
    private static final String LOCAL_ONLY_SIGNATURE = "local";
    private static final String PUBLIC_SIGNATURE = "public";
    private final List<AuthorizationAccessGroup> groups;
    private final String signature;
    private boolean isPublic;

    public AuthorizationPermissionSetImpl(boolean isPublic) {
        this.isPublic = isPublic;
        if (isPublic) {
            this.signature = PUBLIC_SIGNATURE;
            this.groups = AuthorizationConstants.GROUP_LIST_PUBLIC_IN_LOCAL_NETWORK;
        } else {
            this.signature = LOCAL_ONLY_SIGNATURE;
            this.groups = AuthorizationConstants.GROUP_LIST_LOCAL_ONLY;
        }
    }

    public AuthorizationPermissionSetImpl(AuthorizationAccessGroup[] groupList) {
        this(Arrays.asList(groupList));
    }

    public AuthorizationPermissionSetImpl(Collection<AuthorizationAccessGroup> groupList) {
        this.groups = new ArrayList<AuthorizationAccessGroup>(groupList);
        Collections.sort(this.groups);
        if (groupList.isEmpty()) {
            this.signature = LOCAL_ONLY_SIGNATURE;
        } else {
            StringBuilder buffer = new StringBuilder();
            for (AuthorizationAccessGroup g : this.groups) {
                String groupId = g.getFullId();
                if (groupId.indexOf(44) >= 0) {
                    throw new IllegalArgumentException("Group id must not contain the character ,");
                }
                if (groupId.equals(LOCAL_ONLY_SIGNATURE)) {
                    throw new IllegalArgumentException("Group id must not be local");
                }
                if (buffer.length() != 0) {
                    buffer.append(',');
                }
                buffer.append(groupId);
            }
            this.signature = buffer.toString();
        }
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public Collection<AuthorizationAccessGroup> getAccessGroups() {
        return new ArrayList<AuthorizationAccessGroup>(this.groups);
    }

    @Override
    public boolean includesAccessGroup(AuthorizationAccessGroup group) {
        return this.groups.contains(group);
    }

    @Override
    public AuthorizationPermissionSet intersectWith(AuthorizationPermissionSet otherPermissionSet) {
        ArrayList<AuthorizationAccessGroup> newGroups = new ArrayList<AuthorizationAccessGroup>(this.groups);
        newGroups.retainAll(otherPermissionSet.getAccessGroups());
        return new AuthorizationPermissionSetImpl(newGroups);
    }

    @Override
    public AuthorizationAccessGroup getArbitraryGroup() {
        if (this.groups.isEmpty()) {
            throw new IllegalStateException("Requested a group from an empty permission set");
        }
        return this.groups.get(0);
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public boolean isLocalOnly() {
        return this.groups.isEmpty();
    }

    public String toString() {
        return this.signature;
    }

    public int hashCode() {
        return this.signature.hashCode();
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizationPermissionSetImpl other = (AuthorizationPermissionSetImpl)obj;
        return this.signature.equals(other.signature);
    }
}

