/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.datamanagement.browser;

import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNode;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeType;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeUtils;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class DMTreeSorter
extends ViewerSorter {
    public static final int SORT_BY_TIMESTAMP = 0;
    public static final int SORT_BY_NAME_ASC = 1;
    public static final int SORT_BY_NAME_DESC = 2;
    public static final int SORT_BY_TIMESTAMP_DESC = 3;
    private static boolean enableSorting;
    private int sortingType;

    public DMTreeSorter(int sortType) {
        this.sortingType = sortType;
        enableSorting = true;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        DMBrowserNode o1 = (DMBrowserNode)e1;
        DMBrowserNode o2 = (DMBrowserNode)e2;
        if (!(enableSorting && this.isSortable(o1, this.sortingType) && this.isSortable(o2, this.sortingType))) {
            return 0;
        }
        switch (this.sortingType) {
            case 1: {
                return DMBrowserNodeUtils.COMPARATOR_BY_NODE_TITLE.compare(o1, o2);
            }
            case 2: {
                return DMBrowserNodeUtils.COMPARATOR_BY_NODE_TITLE_DESC.compare(o1, o2);
            }
            case 0: {
                return DMBrowserNodeUtils.COMPARATOR_BY_HISTORY_TIMESTAMP.compare(o1, o2);
            }
            case 3: {
                return DMBrowserNodeUtils.COMPARATOR_BY_HISTORY_TIMESTAMP_DESC.compare(o1, o2);
            }
        }
        return 0;
    }

    public boolean isSortable(DMBrowserNode node, int type) {
        DMBrowserNodeType nodeType = node.getType();
        if (node.isLeafNode().booleanValue()) {
            return false;
        }
        switch (type) {
            case 0: 
            case 3: {
                switch (nodeType) {
                    case HistoryObject: {
                        return node.getParent().getType().equals((Object)DMBrowserNodeType.Components);
                    }
                    case Workflow: 
                    case Timeline: 
                    case Component: {
                        return true;
                    }
                }
                return false;
            }
            case 1: 
            case 2: {
                switch (nodeType) {
                    case Workflow: 
                    case Timeline: 
                    case Components: 
                    case Component: 
                    case Input: 
                    case Output: 
                    case ComponentHostInformation: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public void enableSorting(boolean enable) {
        enableSorting = enable;
    }

    public void setSortingType(int sortingType) {
        this.sortingType = sortingType;
    }

    public int getSortingType() {
        return this.sortingType;
    }
}

