/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.xml.loader.gui.properties;

import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.component.xml.XmlComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.gui.datamanagement.browser.spi.CommonHistoryDataItemSubtreeBuilderUtils;
import de.rcenvironment.core.gui.datamanagement.browser.spi.ComponentHistoryDataItemSubtreeBuilder;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNode;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeType;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class XmlLoaderHistoryDataItemSubtreeBuilder
implements ComponentHistoryDataItemSubtreeBuilder {
    private static final Image COMPONENT_ICON;

    static {
        String bundleName = "de.rcenvironment.components.xml.loader.common";
        String iconName = "xmlLoader16.png";
        URL url = ComponentUtils.readIconURL((String)bundleName, (String)iconName);
        COMPONENT_ICON = url != null ? ImageDescriptor.createFromURL((URL)url).createImage() : null;
    }

    public String[] getSupportedHistoryDataItemIdentifier() {
        return new String[]{"de.rcenvironment.xmlloader"};
    }

    public Serializable deserializeHistoryDataItem(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        return (Serializable)ois.readObject();
    }

    public void buildInitialHistoryDataItemSubtree(Serializable historyDataItem, DMBrowserNode parent) {
        ServiceRegistryAccess registryAccess = ServiceRegistry.createAccessFor((Object)this);
        TypedDatumSerializer serializer = ((TypedDatumService)registryAccess.getService(TypedDatumService.class)).getSerializer();
        if (historyDataItem instanceof String) {
            XmlComponentHistoryDataItem historyData;
            try {
                historyData = XmlComponentHistoryDataItem.fromString((String)((String)((Object)historyDataItem)), (TypedDatumSerializer)serializer, (String)"de.rcenvironment.xmlloader");
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            CommonHistoryDataItemSubtreeBuilderUtils.buildCommonHistoryDataItemSubtrees((CommonComponentHistoryDataItem)historyData, (DMBrowserNode)parent);
            if (historyData.getPlainXmlFileReference() != null) {
                DMBrowserNode plainXmlNode = DMBrowserNode.addNewChildNode((String)"Plain XML", (DMBrowserNodeType)DMBrowserNodeType.InformationText, (DMBrowserNode)parent);
                DMBrowserNode plainXmlFileNode = DMBrowserNode.addNewLeafNode((String)"plain.xml", (DMBrowserNodeType)DMBrowserNodeType.DMFileResource, (DMBrowserNode)plainXmlNode);
                plainXmlFileNode.setAssociatedFilename("plain.xml");
                plainXmlFileNode.setDataReferenceId(historyData.getPlainXmlFileReference());
            }
        } else {
            throw new IllegalArgumentException(StringUtils.format((String)"Parsing history data point failed: Expected type %s, but was type %s", (Object[])new Object[]{String.class.getCanonicalName(), historyDataItem.getClass().getCanonicalName()}));
        }
    }

    public Image getComponentIcon(String identifier) {
        return COMPONENT_ICON;
    }
}

