/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.common;

import java.io.File;
import java.io.IOException;
import java.util.Map;

public final class CommonUtils {
    private CommonUtils() {
    }

    public static File getValidatedSystemTempDir() throws IOException {
        File dir = new File(System.getProperty("java.io.tmpdir")).getAbsoluteFile();
        if (!dir.isDirectory()) {
            throw new IOException("System temp dir does not exist: " + dir);
        }
        return dir;
    }

    public static void validateStringMatches(String input, String pattern) throws IOException {
        if (!input.matches(pattern)) {
            throw new IOException("String " + input + " does not match pattern " + pattern);
        }
    }

    public static String substitute(String input, Map<String, String> substitutionMap) {
        for (Map.Entry<String, String> entry : substitutionMap.entrySet()) {
            input = input.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        return input;
    }
}

