/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.execution;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;

public class OutputWriterPersistentComponentDescriptionUpdater
implements PersistentComponentDescriptionUpdater {
    private static final String V1_1 = "1.1";
    private static final String V2_0 = "2.0";
    private static final String V2_1 = "2.1";
    private static final String CURRENT_VERSION = "2.1";
    private static ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
    private static ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();

    public String[] getComponentIdentifiersAffectedByUpdate() {
        return new String[]{"de.rcenvironment.outputwriter"};
    }

    public int getFormatVersionsAffectedByUpdate(String persistentComponentDescriptionVersion, boolean silent) {
        int update = 0;
        if (!silent && persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo("2.1") < 0) {
            update |= 4;
        }
        return update;
    }

    public PersistentComponentDescription performComponentDescriptionUpdate(int formatVersion, PersistentComponentDescription description, boolean silent) throws IOException {
        if (!silent && formatVersion == 4) {
            if (description.getComponentVersion().compareTo(V1_1) < 0) {
                description = this.updateFromV10ToV11(description);
            }
            if (description.getComponentVersion().compareTo(V2_0) < 0) {
                description = this.updateFromV11ToV20(description);
            }
            if (description.getComponentVersion().compareTo("2.1") < 0) {
                description = this.updateFromV11ToV21(description);
            }
        }
        return description;
    }

    private PersistentComponentDescription updateFromV10ToV11(PersistentComponentDescription description) throws IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectNode configurationsNode = (ObjectNode)node.get("configuration");
        if (configurationsNode != null && configurationsNode.has("OWWritePath")) {
            configurationsNode.remove("OWWritePath");
            configurationsNode.put("OWWritePath", "${targetRootFolder}");
        }
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion(V1_1);
        return description;
    }

    private PersistentComponentDescription updateFromV11ToV20(PersistentComponentDescription description) {
        description.setComponentVersion(V2_0);
        return description;
    }

    private PersistentComponentDescription updateFromV11ToV21(PersistentComponentDescription description) throws IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectNode configurationsNode = (ObjectNode)node.get("configuration");
        if (configurationsNode != null) {
            configurationsNode.put("OverwriteFilesAndDirs", "false");
        }
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion("2.1");
        return description;
    }
}

