/*
 * Copyright 2006-2025 DLR, Germany
 * 
 * SPDX-License-Identifier: EPL-1.0
 * 
 * https://rcenvironment.de/
 */

package de.rcenvironment.core.component.update.api;

/**
 * Constants used in JSON files to describe components.
 * 
 * @author Kathrin Schaffert
 */
public final class PersistentComponentDescriptionConstants {

    /** json key. */
    public static final String WORKFLOW_VERSION = "workflowVersion";

    /** json key. */
    public static final String NODES = "nodes";

    /** json key. */
    public static final String EP_IDENTIFIER = "epIdentifier";

    /** json key. */
    public static final String INITIAL = "initial";

    /** json key. */
    public static final String REQUIRED = "required";

    /** json key. */
    public static final String CONFIGURATION = "configuration";

    /** json key. */
    public static final String USAGE = "usage";

    /** json key. */
    public static final String NAME = "name";

    /** json key. */
    public static final String STATIC_OUTPUTS = "staticOutputs";

    /** json key. */
    public static final String STATIC_INPUTS = "staticInputs";

    /** json key. */
    public static final String DYNAMIC_INPUTS = "dynamicInputs";

    /** json key. */
    public static final String DYNAMIC_OUTPUTS = "dynamicOutputs";

    /** json key. */
    public static final String METADATA = "metadata";

    /** json key. */
    public static final String DIRECTORY = "Directory";

    /** json key. */
    public static final String DATATYPE = "datatype";

    /** json key. */
    public static final String IDENTIFIER = "identifier";

    /** json key. */
    public static final String CONNECTIONS = "connections";

    /** json key. */
    public static final String INPUT = "input";

    /** json key. */
    public static final String OUTPUT = "output";

    /** json key. */
    public static final String TARGET = "target";

    /** json key. */
    public static final String SOURCE = "source";

    /** json key. */
    public static final String BENDPOINTS = "bendpoints";

    private PersistentComponentDescriptionConstants() {};
}
