RCE is a distributed, workflow-driven integration environment.
It is used by engineers and scientists to analyze, optimize, and design complex systems (e.g., aircraft, ships, or satellites).
Using RCE, they can combine their specialized design and simulation tools into distributed workflows.

The main project website is [https://rcenvironment.de/](https://rcenvironment.de/).

##### Issue Tracker

The primary issue tracking and roadmap planning for RCE's development is currently done internally at the 
[DLR Institute for Software Technology](https://www.dlr.de/sc), where the majority of development work takes place.
Please use this [GitHub issue tracker](https://github.com/rcenvironment/rce-main/issues) to report new issues and suggestions.
We will review them and integrate them into our internal roadmap.

Please note that there is also a [previous issue tracker](https://github.com/rcenvironment/rce/issues), which is maintained 
for historical completeness, but should not be used for new issues anymore.

##### Contributing

There is currently no standard process for external code contributions.
If you are interested in contributing to RCE, please contact us at rce@dlr.de.

##### Changelog

The changes and new features in recent releases (10.4.0+) are listed on [this page](https://github.com/rcenvironment/rce-main/releases).
Changelogs for older releases (up to 10.4.0) are listed in [this repository](https://github.com/rcenvironment/rce/releases).
Similar information for very old releases (up to 8.3.0) is available [here](https://github.com/rcenvironment/rce/wiki/Changelog-Overview).

##### Get RCE as ready-to-run software

For Windows, a simple .zip file is provided to set up both client and server installations.

On Linux, .deb/.rpm packages as well as a simple .zip file are provided to set up both client and server installations.

[Installation packages for the latest release](https://download.rcenvironment.de/rce/10.x/products/standard/releases/latest/) | 
[Update site for the latest release](https://download.rcenvironment.de/rce/10.x/repositories/standard/releases/latest/)

##### Building RCE from source

This repository, together with a provided "third-party" resources zip file, contains everything to compile RCE from source.
Please refer to `build/README.ad` for instructions.

##### License

RCE is Open Source Software provided under the terms of the [Eclipse Public License (EPL)](http://opensource.org/licenses/EPL-1.0).
This source repository as well as related releases also contain software covered by other open source licenses.
More information is available in embedded licensing files.

##### Update/Security Information for RCE Releases

Please refer to our [Updates/Security](https://rcenvironment.de/pages/updatessecurity.html) website page for the latest update recommendations.


##### Citation

If you use RCE in your research project, please cite either the software itself or our reference publication:

- Latest software release: Jan Flink, Robert Mischke, David Wichter. RCE (Remote Component Environment) (Version 10.7.0). Zenodo (2025). https://doi.org/10.5281/zenodo.17878323
- The RCE software in general (always points at the latest release): https://doi.org/10.5281/zenodo.3691674
- Reference publication: Brigitte Boden, Jan Flink, Niklas Först, Robert Mischke, Kathrin Schaffert, Alexander Weinert, Annika Wohlan, and Andreas Schreiber. "RCE: an integration environment for engineering and science." SoftwareX 15 (2021): 100759. https://doi.org/10.1016/j.softx.2021.100759.
