/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.toolintegration;

import de.rcenvironment.core.component.integration.ToolIntegrationConstants;
import de.rcenvironment.core.gui.integration.toolintegration.Messages;
import de.rcenvironment.core.gui.integration.toolintegration.WizardEditGroupTabNameDialog;
import de.rcenvironment.core.gui.integration.toolintegration.WizardPropertyEditDialog;
import de.rcenvironment.core.gui.integration.toolintegration.api.ToolIntegrationWizardPage;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PropertyConfigurationPage
extends ToolIntegrationWizardPage {
    public static final String KEY_PROPERTY_KEY = "propertyKey";
    public static final String KEY_PROPERTY_DISPLAY_NAME = "propertyDisplayName";
    public static final String KEY_PROPERTY_DEFAULT_VALUE = "propertyDefaultValue";
    public static final String KEY_PROPERTY_COMMENT = "propertyComment";
    private static final String STANDARD_SUFFIX = ".conf";
    private static final String CREATE_CONFIG_FILE = "propertyCreateConfigFile";
    private static final String CONFIG_FILE_NAME = "propertyConfigFilename";
    private static final int PROPERTY_CONFIGURATION_WIDTH = 400;
    private static final int NO_PROPERTY_TAB_SELECTION = -1;
    private static final String DEFAULT_CONFIGURATION_GROUP = "Default";
    private static final String HELP_CONTEXT_ID = "de.rcenvironment.core.gui.wizard.toolintegration.integration_properties";
    protected Map<String, Object> configurationMap;
    private int groupSelection = -1;
    private Button createConfigButton;
    private Text configurationFileNameText;
    private Button tableButtonAdd;
    private Button tableButtonEdit;
    private Button tableButtonRemove;
    private Table propertyTable;
    private Map<String, Object> propertyTabMap;
    private Text groupNameText;
    private org.eclipse.swt.widgets.List propGroupList;
    private Button removeGroupButton;
    private Label configGroupLabel;
    private ButtonSelectionListener btnSelectionListener;
    private Button editGroupButton;
    private Button addGroupButton;
    private Map<String, TableEditor> editors;

    protected PropertyConfigurationPage(String pageName, Map<String, Object> configurationMap) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(Messages.propertyPageDescription);
        this.configurationMap = configurationMap;
        if (configurationMap.get("toolProperties") == null) {
            this.propertyTabMap = new HashMap<String, Object>();
            configurationMap.put("toolProperties", this.propertyTabMap);
            this.propertyTabMap.put(DEFAULT_CONFIGURATION_GROUP, new HashMap());
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        GridData containerGridData = new GridData(768);
        container.setLayoutData((Object)containerGridData);
        this.createTabConfiguration(container);
        this.createPropertyConfiguration(container);
        this.updateTabListContent();
        if (this.propGroupList.getItemCount() > 0) {
            this.propGroupList.setSelection(0);
            this.groupSelection = 0;
        }
        this.updateSelection();
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), HELP_CONTEXT_ID);
        this.setPageComplete(true);
    }

    private void createTabConfiguration(Composite container) {
        Composite tabConfigurationComposite = new Composite(container, 0);
        tabConfigurationComposite.setLayout((Layout)new GridLayout(2, false));
        GridData tabConfigurationGridData = new GridData(1808);
        tabConfigurationComposite.setLayoutData((Object)tabConfigurationGridData);
        Label propertyGroupLabel = new Label(tabConfigurationComposite, 0);
        propertyGroupLabel.setText(Messages.configGroupsHeader);
        GridData propertyGroupLabelData = new GridData();
        propertyGroupLabelData.horizontalSpan = 2;
        propertyGroupLabel.setLayoutData((Object)propertyGroupLabelData);
        this.propGroupList = new org.eclipse.swt.widgets.List(tabConfigurationComposite, 2564);
        GridData tabsListGridData = new GridData(1808);
        tabsListGridData.horizontalSpan = 2;
        this.propGroupList.setLayoutData((Object)tabsListGridData);
        this.propGroupList.addSelectionListener((SelectionListener)new PropertyGroupTableListener(this.propGroupList));
        this.propGroupList.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 && PropertyConfigurationPage.this.propGroupList.getSelection().length == 1 && PropertyConfigurationPage.this.propertyTabMap.containsKey(PropertyConfigurationPage.this.propGroupList.getSelection()[0])) {
                    PropertyConfigurationPage.this.propertyTabMap.remove(PropertyConfigurationPage.this.propGroupList.getSelection()[0]);
                    PropertyConfigurationPage.this.updateTabListContent();
                }
            }
        });
        this.groupNameText = new Text(tabConfigurationComposite, 2048);
        GridData tabNameTextGridData = new GridData(768);
        this.groupNameText.setLayoutData((Object)tabNameTextGridData);
        this.groupNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                PropertyConfigurationPage.this.groupNameText.forceFocus();
                PropertyConfigurationPage.this.addGroupButton.setEnabled(PropertyConfigurationPage.this.groupNameText.getText() != null && !PropertyConfigurationPage.this.groupNameText.getText().isEmpty());
            }
        });
        this.groupNameText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    e.doit = false;
                }
            }
        });
        this.addGroupButton = new Button(tabConfigurationComposite, 8);
        this.addGroupButton.setText(Messages.add);
        GridData addGroupButtonGridData = new GridData(768);
        this.addGroupButton.setLayoutData((Object)addGroupButtonGridData);
        this.addGroupButton.addSelectionListener((SelectionListener)new AddGroupButtonListener());
        this.addGroupButton.setEnabled(false);
        this.editGroupButton = new Button(tabConfigurationComposite, 8);
        this.editGroupButton.setText(Messages.rename);
        GridData editGroupButtonGridData = new GridData(768);
        this.editGroupButton.setLayoutData((Object)editGroupButtonGridData);
        editGroupButtonGridData.horizontalSpan = 2;
        this.editGroupButton.addSelectionListener((SelectionListener)new EditGroupButtonListener());
        this.removeGroupButton = new Button(tabConfigurationComposite, 8);
        this.removeGroupButton.setText(Messages.remove);
        GridData removeGroupButtonGridData = new GridData(768);
        this.removeGroupButton.setLayoutData((Object)removeGroupButtonGridData);
        removeGroupButtonGridData.horizontalSpan = 2;
        this.removeGroupButton.addSelectionListener((SelectionListener)new RemoveGroupButtonListener());
    }

    private void createPropertyConfiguration(Composite container) {
        Composite propertyConfigurationComposite = new Composite(container, 0);
        propertyConfigurationComposite.setLayout((Layout)new GridLayout(2, false));
        GridData propertyConfigurationGridData = new GridData(1808);
        propertyConfigurationGridData.widthHint = 400;
        propertyConfigurationComposite.setLayoutData((Object)propertyConfigurationGridData);
        this.configGroupLabel = new Label(propertyConfigurationComposite, 0);
        GridData configGroupLabelData = new GridData();
        configGroupLabelData.horizontalSpan = 2;
        this.configGroupLabel.setLayoutData((Object)configGroupLabelData);
        this.createTable(propertyConfigurationComposite);
        Composite createConfigComposite = new Composite(propertyConfigurationComposite, 0);
        createConfigComposite.setLayout((Layout)new GridLayout(2, false));
        GridData createConfigGridData = new GridData(768);
        createConfigGridData.horizontalSpan = 2;
        createConfigComposite.setLayoutData((Object)createConfigGridData);
        this.createConfigButton = new Button(createConfigComposite, 32);
        this.createConfigButton.setText(Messages.createConfigFileButton);
        GridData createConfigButtonGridData = new GridData(768);
        createConfigButtonGridData.horizontalSpan = 2;
        this.createConfigButton.setLayoutData((Object)createConfigButtonGridData);
        this.createConfigButton.addSelectionListener((SelectionListener)new CreateConfigSelectionListener());
        new Label(createConfigComposite, 0).setText(String.valueOf(ToolIntegrationConstants.DIRECTORIES_PLACEHOLDER[1]) + "/" + ToolIntegrationConstants.DIRECTORIES_PLACEHOLDER[0].replace('c', 'C') + "/");
        this.configurationFileNameText = new Text(createConfigComposite, 2048);
        GridData configFilenameTextData = new GridData(1808);
        this.configurationFileNameText.setLayoutData((Object)configFilenameTextData);
        this.configurationFileNameText.addModifyListener((ModifyListener)new ConfigurationFilenameTextModifyListener());
    }

    private void createTable(Composite client) {
        Composite tableComposite = new Composite(client, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        GridData tableLayoutData = new GridData(4, 4, true, true, 1, 4);
        tableComposite.setLayoutData((Object)tableLayoutData);
        this.propertyTable = new Table(tableComposite, 68356);
        this.propertyTable.setHeaderVisible(true);
        this.editors = new HashMap<String, TableEditor>();
        GridData tableData = new GridData(1808);
        this.propertyTable.setLayoutData((Object)tableData);
        this.fillContextMenu(this.propertyTable);
        TableColumn col1 = new TableColumn(this.propertyTable, 0);
        col1.setText(Messages.key);
        TableColumn col2 = new TableColumn(this.propertyTable, 0);
        col2.setText(Messages.displayName);
        TableColumn col3 = new TableColumn(this.propertyTable, 0);
        col3.setText("Define at workflow start");
        TableColumn col4 = new TableColumn(this.propertyTable, 0);
        col4.setText(Messages.defaultValue);
        TableColumn col5 = new TableColumn(this.propertyTable, 0);
        col5.setText("Comment");
        tableLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(25, true));
        tableLayout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(30, true));
        tableLayout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(30, true));
        tableLayout.setColumnData((Widget)col4, (ColumnLayoutData)new ColumnWeightData(25, true));
        tableLayout.setColumnData((Widget)col5, (ColumnLayoutData)new ColumnWeightData(30, true));
        this.tableButtonAdd = new Button(client, 0x800000);
        this.tableButtonAdd.setText(Messages.add);
        this.tableButtonAdd.setLayoutData((Object)new GridData(4, 128, false, false));
        this.tableButtonAdd.addSelectionListener((SelectionListener)new ButtonSelectionListener(this.tableButtonAdd, this.propertyTable));
        this.tableButtonEdit = new Button(client, 0x800000);
        this.tableButtonEdit.setText(Messages.edit);
        this.tableButtonEdit.setLayoutData((Object)new GridData(4, 128, false, false));
        this.btnSelectionListener = new ButtonSelectionListener(this.tableButtonEdit, this.propertyTable);
        this.tableButtonEdit.addSelectionListener((SelectionListener)this.btnSelectionListener);
        this.tableButtonRemove = new Button(client, 0x800000);
        this.tableButtonRemove.setText(Messages.remove);
        this.tableButtonRemove.setLayoutData((Object)new GridData(4, 128, false, false));
        this.tableButtonRemove.addSelectionListener((SelectionListener)new ButtonSelectionListener(this.tableButtonRemove, this.propertyTable));
        this.propertyTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.updateButtonActivation();
            }

            private void updateButtonActivation() {
                if (PropertyConfigurationPage.this.propertyTable.getSelectionCount() > 0) {
                    PropertyConfigurationPage.this.tableButtonRemove.setEnabled(true);
                    PropertyConfigurationPage.this.tableButtonEdit.setEnabled(true);
                } else {
                    PropertyConfigurationPage.this.tableButtonRemove.setEnabled(false);
                    PropertyConfigurationPage.this.tableButtonEdit.setEnabled(false);
                }
            }
        });
        this.propertyTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] selection = PropertyConfigurationPage.this.propertyTable.getSelection();
                if (selection != null && selection.length > 0) {
                    PropertyConfigurationPage.this.editProperty(selection);
                    PropertyConfigurationPage.this.updatePropertyTable();
                }
            }
        });
        this.propertyTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    TableItem[] selection = PropertyConfigurationPage.this.propertyTable.getSelection();
                    PropertyConfigurationPage.this.removeProperty(selection);
                    PropertyConfigurationPage.this.updatePropertyTable();
                }
            }
        });
    }

    private void updateTabListContent() {
        String oldSelection = "";
        if (this.groupSelection != -1 && this.propGroupList.getItemCount() > this.groupSelection) {
            oldSelection = this.propGroupList.getItem(this.groupSelection);
        }
        this.propGroupList.removeAll();
        if (this.propertyTabMap != null) {
            for (String key : this.propertyTabMap.keySet()) {
                this.propGroupList.add(key);
            }
            Object[] items = this.propGroupList.getItems();
            Arrays.sort(items);
            this.propGroupList.setItems((String[])items);
            if (this.propGroupList.indexOf(oldSelection) != -1) {
                this.propGroupList.select(this.propGroupList.indexOf(oldSelection));
                this.updatePropertyTable();
            } else if (this.groupSelection == 0) {
                this.groupSelection = 1;
                this.propGroupList.setSelection(0);
                this.updateSelection();
            } else {
                this.groupSelection = -1;
                this.updateSelection();
            }
        }
    }

    private void updateSelection() {
        if (this.propGroupList.getItemCount() > 0) {
            if (this.groupSelection != -1) {
                this.changePropertyTableActivation(true);
                if (this.groupSelection >= this.propGroupList.getItemCount()) {
                    this.groupSelection = 0;
                }
                if (this.propGroupList.getItemCount() != 0 && this.propGroupList.getSelection().length > 0) {
                    this.configGroupLabel.setText(StringUtils.format((String)Messages.groupConfigHeader, (Object[])new Object[]{this.propGroupList.getItem(this.groupSelection)}));
                    Map propertyTabConfig = (Map)this.propertyTabMap.get(this.propGroupList.getSelection()[0]);
                    if (propertyTabConfig.get(CREATE_CONFIG_FILE) != null && ((Boolean)propertyTabConfig.get(CREATE_CONFIG_FILE)).booleanValue()) {
                        this.createConfigButton.setSelection(true);
                        this.configurationFileNameText.setEnabled(true);
                        Map tabProperties = (Map)this.propertyTabMap.get(this.propGroupList.getSelection()[0]);
                        this.configurationFileNameText.setText((String)tabProperties.get(CONFIG_FILE_NAME));
                    } else {
                        this.createConfigButton.setSelection(false);
                        this.configurationFileNameText.setEnabled(false);
                    }
                }
                this.updatePropertyTable();
                this.editGroupButton.setEnabled(true);
                this.removeGroupButton.setEnabled(true);
            } else {
                this.editGroupButton.setEnabled(false);
                this.removeGroupButton.setEnabled(false);
                this.changePropertyTableActivation(false);
                this.configGroupLabel.setText(Messages.noConfigGroupSelected);
                this.updatePropertyTable();
            }
        } else {
            this.editGroupButton.setEnabled(false);
            this.removeGroupButton.setEnabled(false);
            this.changePropertyTableActivation(false);
            this.configGroupLabel.setText(Messages.noConfigGroupSelected);
            this.updatePropertyTable();
        }
        this.configGroupLabel.pack();
    }

    private void updateTabList() {
        this.propGroupList.removeAll();
        Map propGroups = (Map)this.configurationMap.get("toolProperties");
        if (propGroups != null) {
            Set keys = propGroups.keySet();
            for (String groupName : keys) {
                this.propGroupList.add(groupName);
            }
            this.groupSelection = -1;
            this.updateSelection();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.propGroupList.getItems().length > 0 && this.propGroupList.getSelection().length == 0) {
            this.propGroupList.select(0);
            this.groupSelection = 0;
        }
        this.updateSelection();
    }

    private void updatePropertyTable() {
        for (TableEditor editor : this.editors.values()) {
            editor.getEditor().dispose();
        }
        this.editors.clear();
        this.propertyTable.removeAll();
        if (this.propGroupList.getSelectionCount() > 0) {
            Map tabProperties = (Map)this.propertyTabMap.get(this.propGroupList.getSelection()[0]);
            for (Map.Entry entry : tabProperties.entrySet()) {
                String key = (String)entry.getKey();
                if (key.equals(CONFIG_FILE_NAME) || key.equals(CREATE_CONFIG_FILE)) continue;
                TableItem item = new TableItem(this.propertyTable, 0);
                item.setText(0, key);
                Map propertyMetaData = (Map)entry.getValue();
                item.setText(1, (String)propertyMetaData.get(KEY_PROPERTY_DISPLAY_NAME));
                final Button setOnStartButton = new Button((Composite)this.propertyTable, 0x1000020);
                setOnStartButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        setOnStartButton.setSelection(!setOnStartButton.getSelection());
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }
                });
                TableEditor boxEditor = new TableEditor(this.propertyTable);
                this.editors.put(key, boxEditor);
                setOnStartButton.pack();
                boxEditor.minimumWidth = setOnStartButton.getSize().x;
                boxEditor.horizontalAlignment = 0x1000000;
                boxEditor.setEditor((Control)setOnStartButton, item, 2);
                boolean matches = ((String)propertyMetaData.get(KEY_PROPERTY_DEFAULT_VALUE)).matches("\\$\\{((\\w*)(\\.))?((\\*)(\\.))?(.*)\\}");
                setOnStartButton.setSelection(matches);
                item.setText(3, (String)propertyMetaData.get(KEY_PROPERTY_DEFAULT_VALUE));
                if (propertyMetaData.get(KEY_PROPERTY_COMMENT) != null) {
                    item.setText(4, (String)propertyMetaData.get(KEY_PROPERTY_COMMENT));
                    continue;
                }
                item.setText(4, "");
            }
        }
        this.tableButtonEdit.setEnabled(this.propertyTable.getItemCount() != 0);
        this.tableButtonRemove.setEnabled(this.propertyTable.getItemCount() != 0);
    }

    private void changePropertyTableActivation(boolean enabled) {
        this.createConfigButton.setEnabled(enabled);
        this.configurationFileNameText.setEnabled(enabled);
        this.tableButtonAdd.setEnabled(enabled);
        this.tableButtonEdit.setEnabled(enabled);
        this.tableButtonRemove.setEnabled(enabled);
        this.propertyTable.setEnabled(enabled);
        this.removeGroupButton.setEnabled(enabled);
        this.createConfigButton.setSelection(false);
        this.propertyTable.clearAll();
    }

    private List<String> getAllPropertyNames() {
        LinkedList<String> result = new LinkedList<String>();
        for (String tabKey : this.propertyTabMap.keySet()) {
            Map tab = (Map)this.propertyTabMap.get(tabKey);
            result.addAll(tab.keySet());
        }
        return result;
    }

    private List<String> getAllPropertyDisplayNames() {
        LinkedList<String> result = new LinkedList<String>();
        for (String tabKey : this.propertyTabMap.keySet()) {
            Map tab = (Map)this.propertyTabMap.get(tabKey);
            for (String propKey : tab.keySet()) {
                if (tab.get(propKey) instanceof String || tab.get(propKey) instanceof Boolean) continue;
                result.add((String)((Map)tab.get(propKey)).get(KEY_PROPERTY_DISPLAY_NAME));
            }
        }
        return result;
    }

    @Override
    public void setConfigMap(Map<String, Object> newConfigurationMap) {
        this.configurationMap = newConfigurationMap;
        this.propertyTabMap = (Map)newConfigurationMap.get("toolProperties");
        if (this.propertyTabMap == null) {
            this.propertyTabMap = new HashMap<String, Object>();
            this.configurationMap.put("toolProperties", this.propertyTabMap);
            this.propertyTabMap.put(DEFAULT_CONFIGURATION_GROUP, new HashMap());
        }
        this.updatePageValues();
    }

    private void updatePageValues() {
        this.updateTabList();
    }

    public void performHelp() {
        super.performHelp();
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.displayHelp(HELP_CONTEXT_ID);
    }

    @Override
    public void updatePage() {
    }

    @Override
    protected void onAddClicked() {
        this.addProperty();
        this.updatePropertyTable();
    }

    @Override
    protected void onEditClicked() {
        TableItem[] selection = this.propertyTable.getSelection();
        this.editProperty(selection);
    }

    @Override
    protected void onRemoveClicked() {
        TableItem[] selection = this.propertyTable.getSelection();
        this.removeProperty(selection);
        this.updatePropertyTable();
    }

    private void editProperty(TableItem[] selection) {
        HashMap<String, String> propertyConfigCopy = new HashMap<String, String>();
        if (this.propGroupList.getSelection().length > 0 && selection != null && selection.length > 0) {
            propertyConfigCopy.putAll((Map)((Map)this.propertyTabMap.get(this.propGroupList.getSelection()[0])).get(selection[0].getText()));
            String oldpropertyConfig = selection[0].getText();
            WizardPropertyEditDialog wped = new WizardPropertyEditDialog(null, Messages.editProperty, propertyConfigCopy, this.getAllPropertyNames(), this.getAllPropertyDisplayNames());
            int exit = wped.open();
            if (exit == 0) {
                ((Map)this.propertyTabMap.get(this.propGroupList.getSelection()[0])).remove(oldpropertyConfig);
                ((Map)this.propertyTabMap.get(this.propGroupList.getSelection()[0])).put(wped.getConfig().get(KEY_PROPERTY_KEY), wped.getConfig());
            }
        }
    }

    private void removeProperty(TableItem[] selection) {
        if (selection != null && selection.length > 0) {
            Map propertyConfig = (Map)((Map)this.propertyTabMap.get(this.propGroupList.getSelection()[0])).get(selection[0].getText());
            ((Map)this.propertyTabMap.get(this.propGroupList.getSelection()[0])).remove(propertyConfig.get(KEY_PROPERTY_KEY));
        }
    }

    private void addProperty() {
        WizardPropertyEditDialog wped = new WizardPropertyEditDialog(null, Messages.addProperty, new HashMap<String, String>(), this.getAllPropertyNames(), this.getAllPropertyDisplayNames());
        int exit = wped.open();
        if (exit == 0) {
            ((Map)this.propertyTabMap.get(this.propGroupList.getSelection()[0])).put(wped.getConfig().get(KEY_PROPERTY_KEY), wped.getConfig());
        }
    }

    private final class AddGroupButtonListener
    implements SelectionListener {
        private AddGroupButtonListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            String newTabName = PropertyConfigurationPage.this.groupNameText.getText();
            if (PropertyConfigurationPage.this.propertyTabMap == null) {
                PropertyConfigurationPage.this.propertyTabMap = new HashMap<String, Object>();
            }
            if (!newTabName.isEmpty() && !PropertyConfigurationPage.this.propertyTabMap.containsKey(newTabName)) {
                PropertyConfigurationPage.this.propertyTabMap.put(newTabName, new HashMap());
                PropertyConfigurationPage.this.groupNameText.setText("");
                Display display = Display.getCurrent();
                PropertyConfigurationPage.this.groupNameText.setBackground(display.getSystemColor(1));
                PropertyConfigurationPage.this.setMessage(null, 0);
                PropertyConfigurationPage.this.updateTabListContent();
            } else {
                Display display = Display.getCurrent();
                PropertyConfigurationPage.this.groupNameText.setBackground(display.getSystemColor(7));
                if (!newTabName.isEmpty()) {
                    PropertyConfigurationPage.this.setMessage(Messages.propTabNameInvalid, 2);
                } else {
                    PropertyConfigurationPage.this.setMessage(Messages.propTabNameEmpty, 2);
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }
    }

    private class ButtonSelectionListener
    implements SelectionListener {
        private final Button button;
        private final Table selectionTable;

        ButtonSelectionListener(Button button, Table table) {
            this.button = button;
            this.selectionTable = table;
        }

        public void widgetSelected(SelectionEvent arg0) {
            TableItem[] selection = this.selectionTable.getSelection();
            if (this.button.equals(PropertyConfigurationPage.this.tableButtonAdd)) {
                PropertyConfigurationPage.this.addProperty();
            } else if (this.button.equals(PropertyConfigurationPage.this.tableButtonEdit)) {
                if (selection != null && selection.length > 0) {
                    PropertyConfigurationPage.this.editProperty(selection);
                }
            } else if (this.button.equals(PropertyConfigurationPage.this.tableButtonRemove)) {
                PropertyConfigurationPage.this.removeProperty(selection);
            }
            PropertyConfigurationPage.this.updatePropertyTable();
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }
    }

    private final class ConfigurationFilenameTextModifyListener
    implements ModifyListener {
        private ConfigurationFilenameTextModifyListener() {
        }

        public void modifyText(ModifyEvent arg0) {
            if (PropertyConfigurationPage.this.createConfigButton.getSelection() && PropertyConfigurationPage.this.propGroupList.getSelection().length > 0) {
                Map propertyTabConfig = (Map)PropertyConfigurationPage.this.propertyTabMap.get(PropertyConfigurationPage.this.propGroupList.getSelection()[0]);
                propertyTabConfig.put(PropertyConfigurationPage.CONFIG_FILE_NAME, PropertyConfigurationPage.this.configurationFileNameText.getText());
                if (PropertyConfigurationPage.this.configurationFileNameText.getText().equals("")) {
                    Display display = Display.getCurrent();
                    PropertyConfigurationPage.this.configurationFileNameText.setBackground(display.getSystemColor(3));
                    PropertyConfigurationPage.this.setMessage(Messages.configFilenameInvalid, 3);
                } else {
                    Display display = Display.getCurrent();
                    PropertyConfigurationPage.this.configurationFileNameText.setBackground(display.getSystemColor(1));
                    PropertyConfigurationPage.this.setMessage(null, 0);
                }
            }
        }
    }

    private final class CreateConfigSelectionListener
    implements SelectionListener {
        private CreateConfigSelectionListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            Map propertyTabConfig = (Map)PropertyConfigurationPage.this.propertyTabMap.get(PropertyConfigurationPage.this.propGroupList.getSelection()[0]);
            propertyTabConfig.put(PropertyConfigurationPage.CREATE_CONFIG_FILE, PropertyConfigurationPage.this.createConfigButton.getSelection());
            if (propertyTabConfig.get(PropertyConfigurationPage.CONFIG_FILE_NAME) == null) {
                propertyTabConfig.put(PropertyConfigurationPage.CONFIG_FILE_NAME, String.valueOf(PropertyConfigurationPage.this.propGroupList.getSelection()[0]) + PropertyConfigurationPage.STANDARD_SUFFIX);
            }
            PropertyConfigurationPage.this.updateSelection();
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }
    }

    private final class EditGroupButtonListener
    implements SelectionListener {
        private EditGroupButtonListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            WizardEditGroupTabNameDialog wegntd;
            int returnCode;
            if (PropertyConfigurationPage.this.propGroupList.getSelection().length == 1 && (returnCode = (wegntd = new WizardEditGroupTabNameDialog(null, PropertyConfigurationPage.this.propGroupList.getSelection()[0])).open()) == 0) {
                String newName = wegntd.getNewName();
                Map oldConfig = (Map)PropertyConfigurationPage.this.propertyTabMap.get(PropertyConfigurationPage.this.propGroupList.getSelection()[0]);
                if (PropertyConfigurationPage.this.configurationFileNameText.getText().equals(String.valueOf(PropertyConfigurationPage.this.propGroupList.getSelection()[0]) + PropertyConfigurationPage.STANDARD_SUFFIX)) {
                    PropertyConfigurationPage.this.configurationFileNameText.setText(String.valueOf(newName) + PropertyConfigurationPage.STANDARD_SUFFIX);
                }
                if (!newName.equals(PropertyConfigurationPage.this.propGroupList.getSelection()[0])) {
                    PropertyConfigurationPage.this.propertyTabMap.remove(PropertyConfigurationPage.this.propGroupList.getSelection()[0]);
                    PropertyConfigurationPage.this.propertyTabMap.put(newName, oldConfig);
                }
                PropertyConfigurationPage.this.updateTabListContent();
                PropertyConfigurationPage.this.propGroupList.setSelection(PropertyConfigurationPage.this.propGroupList.indexOf(newName));
                PropertyConfigurationPage.this.groupSelection = PropertyConfigurationPage.this.propGroupList.indexOf(newName);
                PropertyConfigurationPage.this.updateSelection();
                PropertyConfigurationPage.this.updatePropertyTable();
            }
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }
    }

    private final class PropertyGroupTableListener
    implements SelectionListener {
        private final org.eclipse.swt.widgets.List tabsList;

        private PropertyGroupTableListener(org.eclipse.swt.widgets.List tabsList) {
            this.tabsList = tabsList;
        }

        public void widgetSelected(SelectionEvent event) {
            int[] selectedItems = this.tabsList.getSelectionIndices();
            if (selectedItems.length == 1) {
                PropertyConfigurationPage.this.groupSelection = selectedItems[0];
            }
            PropertyConfigurationPage.this.updateSelection();
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }

    private final class RemoveGroupButtonListener
    implements SelectionListener {
        private RemoveGroupButtonListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            if (PropertyConfigurationPage.this.propGroupList.getSelection().length == 1 && PropertyConfigurationPage.this.propertyTabMap.containsKey(PropertyConfigurationPage.this.propGroupList.getSelection()[0])) {
                PropertyConfigurationPage.this.propertyTabMap.remove(PropertyConfigurationPage.this.propGroupList.getSelection()[0]);
                PropertyConfigurationPage.this.updateTabListContent();
            }
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }
    }
}

