/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common.textstream.receivers;

import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingTextOutReceiver
implements TextOutputReceiver {
    private final Log log;
    private final String logPrefix;

    public LoggingTextOutReceiver(String logPrefix) {
        this.log = LogFactory.getLog(this.getClass());
        this.logPrefix = logPrefix;
    }

    public LoggingTextOutReceiver(Log log, String logPrefix) {
        this.log = log;
        this.logPrefix = logPrefix;
    }

    @Override
    public void onStart() {
        this.log.debug((Object)(String.valueOf(this.logPrefix) + " -> Started reading"));
    }

    @Override
    public void onFinished() {
        this.log.debug((Object)(String.valueOf(this.logPrefix) + " -> End of Stream"));
    }

    @Override
    public void onFatalError(Exception e) {
        this.log.debug((Object)(String.valueOf(this.logPrefix) + " -> Exception"), (Throwable)e);
    }

    @Override
    public void addOutput(String line) {
        this.log.debug((Object)(String.valueOf(this.logPrefix) + ": " + line));
    }
}

