/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.common.editor;

import de.rcenvironment.core.gui.integration.common.editor.IIntegrationEditorPage;
import de.rcenvironment.core.gui.integration.common.editor.IntegrationEditor;
import de.rcenvironment.core.gui.integration.common.editor.IntegrationEditorButtonBar;
import de.rcenvironment.core.gui.resources.api.ColorManager;
import de.rcenvironment.core.gui.resources.api.ColorSource;
import de.rcenvironment.core.gui.resources.api.StandardColors;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class IntegrationEditorPage
extends CTabItem
implements IIntegrationEditorPage {
    private final String title;
    private CLabel message;
    private IntegrationEditor integrationEditor;
    private boolean isPageValid = true;
    private IntegrationEditorButtonBar buttonBar;
    private CTabFolder container;

    protected IntegrationEditorPage(IntegrationEditor integrationEditor, CTabFolder container, String title) {
        super(container, 0);
        this.container = container;
        this.integrationEditor = integrationEditor;
        this.title = title;
    }

    public abstract void createContent(Composite var1);

    public Composite generatePage() {
        Composite page = new Composite((Composite)this.container, 4);
        page.setLayout((Layout)new GridLayout(1, false));
        CLabel pageTitle = new CLabel(page, 0);
        pageTitle.setLayoutData((Object)new GridData(768));
        pageTitle.setText(this.title);
        pageTitle.setMargins(4, 3, 4, 3);
        pageTitle.setBackground(ColorManager.getInstance().getSharedColor((ColorSource)StandardColors.RCE_LIGHT_GREY));
        this.message = new CLabel(page, 0);
        GridData subtitleGridData = new GridData(768);
        this.message.setLayoutData((Object)subtitleGridData);
        this.message.setBackground(ColorManager.getInstance().getSharedColor((ColorSource)StandardColors.RCE_WHITE));
        ScrolledComposite scrolledComposite = new ScrolledComposite(page, 768);
        scrolledComposite.setLayout((Layout)new GridLayout(1, false));
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        Composite workflowIntegrationEditorPage = new Composite((Composite)scrolledComposite, 4);
        workflowIntegrationEditorPage.setLayout((Layout)new GridLayout(1, false));
        workflowIntegrationEditorPage.setBackground(this.container.getDisplay().getSystemColor(1));
        workflowIntegrationEditorPage.setLayoutData((Object)new GridData(1808));
        this.buttonBar = new IntegrationEditorButtonBar(page, this.integrationEditor);
        this.createContent(workflowIntegrationEditorPage);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinSize(workflowIntegrationEditorPage.computeSize(-1, -1));
        scrolledComposite.setContent((Control)workflowIntegrationEditorPage);
        return page;
    }

    public void setMessage(String text, Image image) {
        this.message.setText(text);
        this.message.setImage(image);
        this.setImage(image);
        this.message.getParent().layout();
    }

    public void setMessage(String text) {
        this.setMessage(text, null);
    }

    public abstract void update();

    @Override
    public boolean isPageValid() {
        return this.isPageValid;
    }

    public void setPageValid(boolean isValid) {
        this.isPageValid = isValid;
    }

    public void updateSaveButtonActivation() {
        this.integrationEditor.updateValid();
    }

    @Override
    public void setBackButtonEnabled(boolean enable) {
        this.buttonBar.setBackButtonEnabled(enable);
    }

    @Override
    public void setNextButtonEnabled(boolean enable) {
        this.buttonBar.setNextButtonEnabled(enable);
    }

    @Override
    public void setSaveButtonEnabled(boolean enable) {
        this.buttonBar.setSaveButtonEnabled(enable);
    }

    public Object getData() {
        return this;
    }
}

