/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.cluster.internal;

import de.rcenvironment.core.utils.cluster.ClusterQueuingSystem;
import de.rcenvironment.core.utils.cluster.ClusterService;
import de.rcenvironment.core.utils.cluster.ClusterServiceManager;
import de.rcenvironment.core.utils.cluster.sge.internal.SgeClusterService;
import de.rcenvironment.core.utils.cluster.torque.internal.TorqueClusterService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.ssh.jsch.SshSessionConfiguration;
import de.rcenvironment.core.utils.ssh.jsch.SshSessionConfigurationFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class ClusterServiceManagerImpl
implements ClusterServiceManager {
    private Map<String, ClusterService> informationServices = new HashMap<String, ClusterService>();

    @Override
    public synchronized ClusterService retrieveSshBasedClusterService(ClusterQueuingSystem system, Map<String, String> pathsToQueuingSystemCommands, String host, int port, String sshAuthUser, String sshAuthPhrase) {
        ClusterService clusterService;
        String clusterServiceId = this.createIdentifier(system, host, port, sshAuthUser, sshAuthPhrase, pathsToQueuingSystemCommands.toString());
        if (this.informationServices.containsKey(clusterServiceId)) {
            clusterService = this.informationServices.get(clusterServiceId);
        } else {
            SshSessionConfiguration sshConfiguration = SshSessionConfigurationFactory.createSshSessionConfigurationWithAuthPhrase((String)host, (int)port, (String)sshAuthUser, (String)sshAuthPhrase);
            switch (system) {
                case TORQUE: {
                    clusterService = new TorqueClusterService(sshConfiguration, pathsToQueuingSystemCommands);
                    break;
                }
                case SGE: {
                    clusterService = new SgeClusterService(sshConfiguration, pathsToQueuingSystemCommands);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Cluster queuing system not supported: " + (Object)((Object)system));
                }
            }
            this.informationServices.put(clusterServiceId, clusterService);
        }
        return clusterService;
    }

    private String createIdentifier(ClusterQueuingSystem system, String host, int port, String sshAuthUser, String sshAuthPhrase, String pathsToCommands) {
        return StringUtils.escapeAndConcat((String[])new String[]{system.name(), host, String.valueOf(port), sshAuthUser, String.valueOf(Base64.encodeBase64((byte[])sshAuthPhrase.getBytes())), pathsToCommands});
    }
}

