/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.introduction;

import de.rcenvironment.core.gui.introduction.NavigateToLinkParameters;
import de.rcenvironment.core.utils.common.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;

public class NavigateToLink
implements IIntroAction {
    private final Map<String, String> keyValueToURL = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("news", "https://rcenvironment.de/#news");
            this.put("newsletter", "https://rcenvironment.de/pages/newsletter.html");
            this.put("github", "https://github.com/rcenvironment");
        }
    };
    private final Log log = LogFactory.getLog(this.getClass());

    public void run(IIntroSite site, Properties properties) {
        NavigateToLinkParameters parameters = NavigateToLinkParameters.createFromProperties(properties);
        try {
            this.openLink(parameters);
        }
        catch (PartInitException e) {
            this.logExceptionAsWarning((CoreException)((Object)e));
        }
        catch (MalformedURLException e) {
            this.logExceptionAsWarningForMalformedURL(e);
        }
    }

    private void openLink(NavigateToLinkParameters parameters) throws PartInitException, MalformedURLException {
        if (this.keyValueToURL.containsKey(parameters.getKeyOfParameterValue())) {
            String mappedURL = this.keyValueToURL.get(parameters.getKeyOfParameterValue());
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(mappedURL));
        }
    }

    private void logExceptionAsWarning(CoreException e) {
        this.log.warn((Object)StringUtils.format((String)"Status: %s\nCause: %s", (Object[])new Object[]{e.getStatus(), e.getCause()}));
    }

    private void logExceptionAsWarningForMalformedURL(MalformedURLException e) {
        this.log.warn((Object)StringUtils.format((String)"Status: %s\nCause: %s", (Object[])new Object[]{e.getStackTrace(), e.getCause()}));
    }
}

