/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.parametricstudy.gui.view;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final String IMAGES_PROPERTIES_FILE = "images.properties";
    private static BundleContext bundleContext;
    private static Properties imageMapping;
    private static ImageRegistry imageRegistry;

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
    }

    public void stop(BundleContext context) throws Exception {
        if (imageRegistry != null) {
            imageRegistry.dispose();
            imageRegistry = null;
        }
    }

    public static BundleContext getContext() {
        return bundleContext;
    }

    private static ImageRegistry getImageRegistry() {
        if (Display.getDefault() == null) {
            return null;
        }
        imageRegistry = new ImageRegistry();
        return imageRegistry;
    }

    public static void putImage(String key, Image image) {
        if (Activator.getImageRegistry() == null) {
            return;
        }
        imageRegistry.put(key, image);
    }

    public static Image getImage(String key) {
        if (Activator.getImageRegistry() == null) {
            return null;
        }
        Image result = imageRegistry.get(key);
        if (result == null) {
            InputStream imageInputStream;
            if (imageMapping == null) {
                imageMapping = new Properties();
                try {
                    imageMapping.load(Activator.class.getResourceAsStream(IMAGES_PROPERTIES_FILE));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (imageMapping.getProperty(key) != null && (imageInputStream = Activator.class.getResourceAsStream(imageMapping.getProperty(key))) != null) {
                result = new Image((Device)Display.getDefault(), imageInputStream);
                imageRegistry.put(key, result);
            }
        }
        return result;
    }
}

