/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.component.api.ComponentConstants;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.execution.api.Component;
import de.rcenvironment.core.component.execution.api.ComponentExecutionException;
import de.rcenvironment.core.component.execution.api.ComponentExecutionService;
import de.rcenvironment.core.component.execution.api.ComponentState;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.execution.api.WorkflowGraphHop;
import de.rcenvironment.core.component.execution.api.WorkflowGraphPath;
import de.rcenvironment.core.component.execution.impl.ComponentContextImpl;
import de.rcenvironment.core.component.execution.impl.ComponentExecutionContextImpl;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionRelatedInstances;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionRelatedInstancesFactory;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionRelatedStates;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionStatsService;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionUtils;
import de.rcenvironment.core.component.execution.internal.ComponentExecutor;
import de.rcenvironment.core.component.execution.internal.ComponentStateMachineEvent;
import de.rcenvironment.core.component.execution.internal.ComponentStateMachineEventType;
import de.rcenvironment.core.component.execution.internal.InternalTDImpl;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDatum;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointCharacter;
import de.rcenvironment.core.datamodel.api.FinalComponentRunState;
import de.rcenvironment.core.datamodel.api.FinalComponentState;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.AbstractFixedTransitionsStateMachine;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.core.utils.incubator.StateChangeException;
import de.rcenvironment.provenance.api.ProvenanceEventListener;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import de.rcenvironment.toolkit.utils.common.IdGenerator;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class ComponentStateMachine
extends AbstractFixedTransitionsStateMachine<ComponentState, ComponentStateMachineEvent> {
    private static final Log LOG = LogFactory.getLog(ComponentStateMachine.class);
    private static final boolean VERBOSE_LOGGING = DebugSettings.getVerboseLoggingEnabled((String)"WorkflowExecution");
    private static final int MAX_INITIAL_HEARTBEAT_SEND_DELAY_MSEC = 10000;
    private static final int HEARTBEAT_SEND_INTERVAL_MSEC = 30000;
    private static final ComponentState[][] VALID_COMPONENT_STATE_TRANSITIONS = new ComponentState[][]{{ComponentState.INIT, ComponentState.PREPARING}, {ComponentState.PREPARING, ComponentState.PREPARED}, {ComponentState.PREPARED, ComponentState.WAITING_FOR_RESOURCES}, {ComponentState.WAITING_FOR_RESOURCES, ComponentState.STARTING}, {ComponentState.STARTING, ComponentState.IDLING}, {ComponentState.STARTING, ComponentState.WAITING_FOR_APPROVAL}, {ComponentState.IDLING, ComponentState.WAITING_FOR_RESOURCES}, {ComponentState.IDLING_AFTER_RESET, ComponentState.WAITING_FOR_RESOURCES}, {ComponentState.WAITING_FOR_RESOURCES, ComponentState.PROCESSING_INPUTS}, {ComponentState.PROCESSING_INPUTS, ComponentState.IDLING}, {ComponentState.PROCESSING_INPUTS, ComponentState.WAITING_FOR_APPROVAL}, {ComponentState.WAITING_FOR_APPROVAL, ComponentState.IDLING}, {ComponentState.WAITING_FOR_RESOURCES, ComponentState.RESETTING}, {ComponentState.IDLING, ComponentState.IDLING}, {ComponentState.RESETTING, ComponentState.IDLING_AFTER_RESET}, {ComponentState.IDLING, ComponentState.TEARING_DOWN}, {ComponentState.IDLING_AFTER_RESET, ComponentState.IDLING_AFTER_RESET}, {ComponentState.IDLING_AFTER_RESET, ComponentState.TEARING_DOWN}, {ComponentState.TEARING_DOWN, ComponentState.FINISHED}, {ComponentState.TEARING_DOWN, ComponentState.FINISHED_WITHOUT_EXECUTION}, {ComponentState.FINISHED_WITHOUT_EXECUTION, ComponentState.DISPOSING}, {ComponentState.FINISHED, ComponentState.DISPOSING}, {ComponentState.DISPOSING, ComponentState.DISPOSED}, {ComponentState.INIT, ComponentState.CANCELLING}, {ComponentState.PREPARING, ComponentState.CANCELLING}, {ComponentState.PREPARED, ComponentState.CANCELLING}, {ComponentState.STARTING, ComponentState.CANCELLING}, {ComponentState.WAITING_FOR_RESOURCES, ComponentState.CANCELLING}, {ComponentState.PROCESSING_INPUTS, ComponentState.CANCELLING}, {ComponentState.WAITING_FOR_APPROVAL, ComponentState.CANCELLING}, {ComponentState.IDLING, ComponentState.CANCELLING}, {ComponentState.IDLING_AFTER_RESET, ComponentState.CANCELLING}, {ComponentState.RESETTING, ComponentState.CANCELLING}, {ComponentState.STARTING, ComponentState.CANCELLING_AFTER_FAILURE}, {ComponentState.WAITING_FOR_RESOURCES, ComponentState.CANCELLING_AFTER_FAILURE}, {ComponentState.PROCESSING_INPUTS, ComponentState.CANCELLING_AFTER_FAILURE}, {ComponentState.IDLING, ComponentState.CANCELLING_AFTER_FAILURE}, {ComponentState.IDLING_AFTER_RESET, ComponentState.CANCELLING_AFTER_FAILURE}, {ComponentState.RESETTING, ComponentState.CANCELLING_AFTER_FAILURE}, {ComponentState.CANCELLING, ComponentState.TEARING_DOWN}, {ComponentState.CANCELLING_AFTER_FAILURE, ComponentState.TEARING_DOWN}, {ComponentState.TEARING_DOWN, ComponentState.CANCELED}, {ComponentState.CANCELED, ComponentState.DISPOSING}, {ComponentState.PREPARING, ComponentState.PAUSING}, {ComponentState.PREPARED, ComponentState.PAUSING}, {ComponentState.STARTING, ComponentState.PAUSING}, {ComponentState.WAITING_FOR_RESOURCES, ComponentState.PAUSING}, {ComponentState.PROCESSING_INPUTS, ComponentState.PAUSING}, {ComponentState.WAITING_FOR_APPROVAL, ComponentState.PAUSING}, {ComponentState.IDLING, ComponentState.PAUSING}, {ComponentState.IDLING_AFTER_RESET, ComponentState.PAUSING}, {ComponentState.RESETTING, ComponentState.PAUSING}, {ComponentState.PAUSING, ComponentState.PAUSED}, {ComponentState.PAUSING, ComponentState.PROCESSING_INPUTS}, {ComponentState.PAUSED, ComponentState.CANCELLING}, {ComponentState.PAUSED, ComponentState.RESUMING}, {ComponentState.RESUMING, ComponentState.PREPARING}, {ComponentState.RESUMING, ComponentState.PREPARED}, {ComponentState.RESUMING, ComponentState.WAITING_FOR_RESOURCES}, {ComponentState.RESUMING, ComponentState.IDLING}, {ComponentState.RESUMING, ComponentState.IDLING_AFTER_RESET}, {ComponentState.INIT, ComponentState.TEARING_DOWN}, {ComponentState.PREPARING, ComponentState.TEARING_DOWN}, {ComponentState.PREPARED, ComponentState.TEARING_DOWN}, {ComponentState.STARTING, ComponentState.TEARING_DOWN}, {ComponentState.WAITING_FOR_RESOURCES, ComponentState.TEARING_DOWN}, {ComponentState.PROCESSING_INPUTS, ComponentState.TEARING_DOWN}, {ComponentState.WAITING_FOR_APPROVAL, ComponentState.TEARING_DOWN}, {ComponentState.PAUSING, ComponentState.TEARING_DOWN}, {ComponentState.PAUSED, ComponentState.TEARING_DOWN}, {ComponentState.RESUMING, ComponentState.TEARING_DOWN}, {ComponentState.IDLING, ComponentState.TEARING_DOWN}, {ComponentState.IDLING_AFTER_RESET, ComponentState.TEARING_DOWN}, {ComponentState.CANCELLING, ComponentState.TEARING_DOWN}, {ComponentState.RESETTING, ComponentState.TEARING_DOWN}, {ComponentState.TEARING_DOWN, ComponentState.FAILED}, {ComponentState.TEARING_DOWN, ComponentState.RESULTS_REJECTED}, {ComponentState.FAILED, ComponentState.DISPOSING}, {ComponentState.RESULTS_REJECTED, ComponentState.DISPOSING}};
    private static ComponentExecutionService comExeService;
    private static ComponentExecutionStatsService compExeStatsService;
    private static ComponentExecutionRelatedInstancesFactory compExeInstancesFactory;
    protected final Map<ComponentStateMachineEventType, EventProcessor> eventProcessors = new HashMap<ComponentStateMachineEventType, EventProcessor>();
    private ComponentExecutionRelatedInstances compExeRelatedInstances;
    private AtomicReference<ComponentExecutor> compExecutorRef = new AtomicReference<Object>(null);
    private Future<?> currentTask = null;
    private String errorId = null;
    private String errorMessage = null;
    private boolean pauseWasRequested = false;
    private ComponentStateMachineEvent lastEventBeforePaused;
    private ComponentContextImpl componentContext;
    private final AsyncTaskService threadPool = ConcurrencyUtils.getAsyncTaskService();
    private SortedSet<Integer> executionCountOnResets = new TreeSet<Integer>();
    private ScheduledFuture<?> heartbeatFuture;
    private volatile String latestVerificationToken;
    private Map<String, TypedDatum> outputsWritten = new HashMap<String, TypedDatum>();
    private Runnable heartbeatRunnable = new Runnable(){

        @Override
        public void run() {
            if (VERBOSE_LOGGING) {
                LOG.debug((Object)("Sending component heartbeat: " + ComponentStateMachine.this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier()));
            }
            ComponentStateMachine.this.compExeRelatedInstances.wfExeCtrlBridgeDelegator.onComponentHeartbeatReceived(ComponentStateMachine.this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier());
        }
    };

    @Deprecated
    public ComponentStateMachine() {
        super((Enum)ComponentState.INIT, (Enum[][])VALID_COMPONENT_STATE_TRANSITIONS);
    }

    public ComponentStateMachine(ComponentExecutionRelatedInstances compExeRelatedInstances) {
        super((Enum)ComponentState.INIT, (Enum[][])VALID_COMPONENT_STATE_TRANSITIONS);
        boolean isNestedLoopDriver;
        this.compExeRelatedInstances = compExeRelatedInstances;
        compExeRelatedInstances.isNestedLoopDriver = isNestedLoopDriver = Boolean.valueOf(compExeRelatedInstances.compExeCtx.getComponentDescription().getConfigurationDescription().getConfigurationValue("isNestedLoop_5e0ed1cd")).booleanValue();
        compExeRelatedInstances.compExeRelatedStates = new ComponentExecutionRelatedStates();
        compExeRelatedInstances.typedDatumToOutputWriter = compExeInstancesFactory.createTypedDatumToOutputWriter(compExeRelatedInstances);
        compExeRelatedInstances.wfExeCtrlBridgeDelegator = compExeInstancesFactory.createWorkflowExecutionControllerBridgeDelegator(compExeRelatedInstances);
        compExeRelatedInstances.batchingConsoleRowsForwarder = compExeInstancesFactory.createBatchingConsoleRowsForwarder(compExeRelatedInstances);
        compExeRelatedInstances.consoleRowsSender = compExeInstancesFactory.createConsoleRowsSender(compExeRelatedInstances);
        compExeRelatedInstances.compCtxBridge = compExeInstancesFactory.createComponentContextBridge(compExeRelatedInstances);
        this.heartbeatFuture = this.threadPool.scheduleAtFixedIntervalAfterInitialDelay("Send component heartbeat to workflow controller", this.heartbeatRunnable, Math.round(Math.random() * 10000.0), 30000L);
        this.initializeEventProcessors();
    }

    protected void initializeEventProcessors() {
        this.eventProcessors.put(ComponentStateMachineEventType.PREPARE_REQUESTED, new PrepareRequestedEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.START_REQUESTED, new StartRequestedEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.PROCESSING_INPUT_DATUMS_REQUESTED, new ProcessingInputsDatumRequestedEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.RUNNING, new RunningEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.RESET_REQUESTED, new ResetRequestedEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.PAUSE_REQUESTED, new PauseRequestedEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.RESUME_REQUESTED, new ResumeRequestedEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.CANCEL_REQUESTED, new CancelRequestedEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.DISPOSE_REQUESTED, new DisposeRequestedEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.PREPARATION_SUCCESSFUL, new PreparationSuccessfulEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.START_SUCCESSFUL, new StartSuccessfulEventProcessor());
        StartAsRunOrProcessingInputsSuccessfulEventProcessor startOrProcessingInputsSuccessfulEventProcessor = new StartAsRunOrProcessingInputsSuccessfulEventProcessor();
        this.eventProcessors.put(ComponentStateMachineEventType.START_AS_RUN_SUCCESSFUL, startOrProcessingInputsSuccessfulEventProcessor);
        this.eventProcessors.put(ComponentStateMachineEventType.PROCESSING_INPUTS_SUCCESSFUL, startOrProcessingInputsSuccessfulEventProcessor);
        this.eventProcessors.put(ComponentStateMachineEventType.RESULT_APPROVAL_REQUESTED, new ResultsApprovalRequestedEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.RESULTS_APPROVED, new ResultsApprovedEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.RESULTS_REJECTED, new ResultsRejectedEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.RESULTS_APPROVED_COMPLETED, new ResultsApprovedCompletedSuccessfulEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.RESULTS_REJECTED_COMPLETED, new ResultsRejectedCompletedSuccessfulEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.IDLE_REQUESTED, new IdleRequestedEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.RESET_SUCCESSFUL, new ResetSuccessfulEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.CANCEL_ATTEMPT_SUCCESSFUL, new CancelAttemptSuccessfulEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.DISPOSE_ATTEMPT_SUCCESSFUL, new DisposeAttemptSuccessfulEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.NEW_SCHEDULING_STATE, new NewSchedulingStateEventProcessor());
        this.eventProcessors.put(ComponentStateMachineEventType.FINISHED, new FinishedEventProcessor());
        FailedEventProcessor failedEventProcessor = new FailedEventProcessor();
        this.eventProcessors.put(ComponentStateMachineEventType.PROCESSING_INPUTS_FAILED, failedEventProcessor);
        this.eventProcessors.put(ComponentStateMachineEventType.START_FAILED, failedEventProcessor);
        this.eventProcessors.put(ComponentStateMachineEventType.RESET_FAILED, failedEventProcessor);
        this.eventProcessors.put(ComponentStateMachineEventType.PREPARATION_FAILED, failedEventProcessor);
        this.eventProcessors.put(ComponentStateMachineEventType.SCHEDULING_FAILED, failedEventProcessor);
        this.eventProcessors.put(ComponentStateMachineEventType.PAUSE_ATTEMPT_FAILED, failedEventProcessor);
        this.eventProcessors.put(ComponentStateMachineEventType.CANCEL_ATTEMPT_FAILED, failedEventProcessor);
        this.eventProcessors.put(ComponentStateMachineEventType.WF_CRTL_CALLBACK_FAILED, failedEventProcessor);
        this.eventProcessors.put(ComponentStateMachineEventType.VERIFICATION_COMPLETION_FAILED, failedEventProcessor);
        this.eventProcessors.put(ComponentStateMachineEventType.HANDLE_VERIFICATION_TOKEN_FAILED, failedEventProcessor);
        this.eventProcessors.put(ComponentStateMachineEventType.TEARED_DOWN, new TearedDownEventProcessor());
    }

    public String getVerificationToken() {
        if (((ComponentState)this.getState()).equals((Object)ComponentState.WAITING_FOR_APPROVAL) || ((ComponentState)this.getState()).equals((Object)ComponentState.PAUSING)) {
            return this.latestVerificationToken;
        }
        return null;
    }

    public boolean isWorkflowControllerReachable() {
        return this.compExeRelatedInstances.wfExeCtrlBridgeDelegator.isWorkflowControllerReachable();
    }

    private boolean checkStateChange(ComponentState currentState, ComponentState newState, ComponentStateMachineEvent event) {
        if (this.isStateChangeValid(currentState, newState)) {
            return true;
        }
        this.logInvalidStateChangeRequest(currentState, newState, event);
        return false;
    }

    protected ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) throws StateChangeException {
        if (this.pauseWasRequested && event.getType() != ComponentStateMachineEventType.RUNNING) {
            this.pauseWasRequested = false;
            if (!ComponentConstants.FINAL_COMPONENT_STATES_WITH_DISPOSED.contains((Object)currentState)) {
                this.lastEventBeforePaused = event;
                return ComponentState.PAUSED;
            }
        }
        return this.eventProcessors.get((Object)event.getType()).processEvent(currentState, event);
    }

    private void handleFailureEvent(ComponentStateMachineEvent event) {
        Throwable throwable = event.getThrowable();
        if (throwable != null) {
            String message = StringUtils.format((String)"Executing component '%s' (%s) failed", (Object[])new Object[]{this.compExeRelatedInstances.compExeCtx.getInstanceName(), this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier()});
            this.errorId = throwable.getCause() != null ? LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)LOG, (String)message, (Throwable)throwable) : LogUtils.logExceptionAsSingleLineAndAssignUniqueMarker((Log)LOG, (String)message, (Throwable)throwable);
            this.errorMessage = ComponentUtils.createErrorLogMessage(throwable);
        } else if (event.getErrorId() != null) {
            this.errorId = event.getErrorId();
        }
    }

    private ComponentState handleFailure(ComponentState currentState, ComponentStateMachineEvent event) {
        this.handleFailureEvent(event);
        ComponentState finalCompState = ComponentState.FAILED;
        switch (event.getType()) {
            case SCHEDULING_FAILED: 
            case WF_CRTL_CALLBACK_FAILED: {
                this.cancelAsync();
                return ComponentState.CANCELLING_AFTER_FAILURE;
            }
        }
        this.currentTask = null;
        this.tearDownAsync(finalCompState);
        return ComponentState.TEARING_DOWN;
    }

    private ComponentState handleFinished() {
        if (this.compExeRelatedInstances.compExeRelatedStates.executionCount.get() == 0) {
            this.tearDownAsync(ComponentState.FINISHED_WITHOUT_EXECUTION);
        } else {
            this.tearDownAsync(ComponentState.FINISHED);
        }
        return ComponentState.TEARING_DOWN;
    }

    private void logInvalidStateChangeRequest(ComponentState currentState, ComponentState requestedState, ComponentStateMachineEvent event) {
        LOG.debug((Object)StringUtils.format((String)"Ignored component state change request for component '%s' (%s) of workflow '%s' (%s) as it would cause an invalid state transition: %s -> %s; event was: %s", (Object[])new Object[]{this.compExeRelatedInstances.compExeCtx.getInstanceName(), this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier(), this.compExeRelatedInstances.compExeCtx.getWorkflowInstanceName(), this.compExeRelatedInstances.compExeCtx.getWorkflowExecutionIdentifier(), currentState, requestedState, event.getType().name()}));
    }

    protected void onStateChanged(ComponentState oldState, ComponentState newState) {
        LOG.debug((Object)StringUtils.format((String)"%s is now %s (previous state: %s)", (Object[])new Object[]{ComponentExecutionUtils.getStringWithInfoAboutComponentAndWorkflowUpperCase(this.compExeRelatedInstances.compExeCtx), newState, oldState}));
        if (newState.equals((Object)ComponentState.FAILED)) {
            if (this.errorMessage != null) {
                this.compExeRelatedInstances.wfExeCtrlBridgeDelegator.onComponentStateChanged(this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier(), newState, this.compExeRelatedInstances.compExeRelatedStates.executionCount.get(), this.getExecutionCountsOnResetAsString(), this.errorId, this.errorMessage);
                this.errorMessage = null;
            } else {
                this.compExeRelatedInstances.wfExeCtrlBridgeDelegator.onComponentStateChanged(this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier(), newState, this.compExeRelatedInstances.compExeRelatedStates.executionCount.get(), this.getExecutionCountsOnResetAsString(), this.errorId);
            }
            this.errorId = null;
        } else {
            this.compExeRelatedInstances.wfExeCtrlBridgeDelegator.onComponentStateChanged(this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier(), newState, this.compExeRelatedInstances.compExeRelatedStates.executionCount.get(), this.getExecutionCountsOnResetAsString());
        }
        if (ComponentConstants.FINAL_COMPONENT_STATES.contains((Object)newState)) {
            this.compExeRelatedInstances.consoleRowsSender.sendStateAsConsoleRow(ConsoleRow.WorkflowLifecyleEventType.COMPONENT_TERMINATED);
            this.heartbeatFuture.cancel(false);
            compExeStatsService.addStatsAtComponentTermination(this.compExeRelatedInstances.compExeCtx, newState);
            if (!this.compExeRelatedInstances.compExeCtx.getComponentDescription().performLazyDisposal()) {
                try {
                    comExeService.dispose(this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier(), (NetworkDestination)this.compExeRelatedInstances.compExeCtx.getComponentDescription().getNode());
                }
                catch (ExecutionControllerException | RemoteOperationException e) {
                    LOG.error((Object)StringUtils.format((String)"Failed to dispose component execution controller for %s", (Object[])new Object[]{ComponentExecutionUtils.getStringWithInfoAboutComponentAndWorkflowLowerCase(this.compExeRelatedInstances.compExeCtx)}), e);
                    this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.DISPOSE_REQUESTED));
                }
            }
        } else if (newState == ComponentState.STARTING) {
            this.compExeRelatedInstances.consoleRowsSender.sendStateAsConsoleRow(ConsoleRow.WorkflowLifecyleEventType.COMPONENT_STARTING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExecutionCountsOnResetAsString() {
        ArrayList<String> counts = new ArrayList<String>();
        SortedSet<Integer> sortedSet = this.executionCountOnResets;
        synchronized (sortedSet) {
            for (Integer countOnReset : this.executionCountOnResets) {
                counts.add(String.valueOf(countOnReset));
            }
            if (!this.executionCountOnResets.contains(this.compExeRelatedInstances.compExeRelatedStates.executionCount.get())) {
                counts.add(String.valueOf(this.compExeRelatedInstances.compExeRelatedStates.executionCount.get()));
            }
        }
        return StringUtils.escapeAndConcat(counts);
    }

    protected void onStateChangeException(ComponentStateMachineEvent event, StateChangeException e) {
        LOG.error((Object)StringUtils.format((String)"Invalid state change for component '%s' (%s) of workflow '%s' (%s) attempt, caused by event '%s'", (Object[])new Object[]{this.compExeRelatedInstances.compExeCtx.getInstanceName(), this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier(), this.compExeRelatedInstances.compExeCtx.getWorkflowInstanceName(), this.compExeRelatedInstances.compExeCtx.getWorkflowExecutionIdentifier(), event}), (Throwable)e);
    }

    private void prepareAsync() {
        this.currentTask = this.threadPool.submit((Runnable)new AsyncPrepareTask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAsync() {
        ComponentExecutor.ComponentExecutionType compExeType = ComponentExecutor.ComponentExecutionType.StartAsInit;
        AtomicReference<Component> atomicReference = this.compExeRelatedInstances.component;
        synchronized (atomicReference) {
            if (this.compExeRelatedInstances.component.get().treatStartAsComponentRun()) {
                compExeType = ComponentExecutor.ComponentExecutionType.StartAsRun;
            }
        }
        this.compExecutorRef.set(new ComponentExecutor(this.compExeRelatedInstances, compExeType));
        this.currentTask = this.threadPool.submit((Runnable)new AsyncStartTask(compExeType));
    }

    private void processInputsAsync() {
        this.compExecutorRef.set(new ComponentExecutor(this.compExeRelatedInstances, ComponentExecutor.ComponentExecutionType.ProcessInputs));
        this.currentTask = this.threadPool.submit((Runnable)new AsyncProcessInputsTask());
    }

    private void handleVerificationTokenAsync(String verificationToken) {
        ComponentExecutor.ComponentExecutionType compExeType = ComponentExecutor.ComponentExecutionType.HandleVerificationToken;
        compExeType.setVerificationToken(verificationToken);
        this.latestVerificationToken = verificationToken;
        this.compExecutorRef.set(new ComponentExecutor(this.compExeRelatedInstances, compExeType));
        this.currentTask = this.threadPool.submit((Runnable)new AsyncHandleVerificationTokenTask());
    }

    private void completeVerificationAsync(boolean outputsApproved) {
        ComponentExecutor.ComponentExecutionType compExeType = ComponentExecutor.ComponentExecutionType.CompleteVerification;
        if (outputsApproved) {
            compExeType.setFinalComponentStateAfterRun(FinalComponentRunState.RESULTS_APPROVED);
        } else {
            compExeType.setFinalComponentStateAfterRun(FinalComponentRunState.RESULTS_REJECTED);
        }
        this.compExecutorRef.set(new ComponentExecutor(this.compExeRelatedInstances, ComponentExecutor.ComponentExecutionType.CompleteVerification));
        this.currentTask = this.threadPool.submit((Runnable)new AsyncCompleteVerificationTask(outputsApproved));
    }

    private void resetAsync() {
        this.compExecutorRef.set(new ComponentExecutor(this.compExeRelatedInstances, ComponentExecutor.ComponentExecutionType.Reset));
        this.currentTask = this.threadPool.submit((Runnable)new AsyncResetTask());
    }

    private void cancelAsync() {
        this.threadPool.submit((Runnable)new AsyncCancelTask(this.currentTask));
    }

    private void tearDownAsync(ComponentState compState) {
        Component.FinalComponentState finalCompState;
        FinalComponentState finalStateForDm = null;
        switch (compState) {
            case FINISHED_WITHOUT_EXECUTION: {
                finalCompState = Component.FinalComponentState.FINISHED;
                finalStateForDm = FinalComponentState.FINISHED_WITHOUT_EXECUTION;
                break;
            }
            case FINISHED: {
                finalCompState = Component.FinalComponentState.FINISHED;
                finalStateForDm = FinalComponentState.FINISHED;
                break;
            }
            case FAILED: {
                finalCompState = Component.FinalComponentState.FAILED;
                finalStateForDm = FinalComponentState.FAILED;
                break;
            }
            case RESULTS_REJECTED: {
                finalCompState = Component.FinalComponentState.RESULTS_REJECTED;
                finalStateForDm = FinalComponentState.RESULTS_REJECTED;
                break;
            }
            case CANCELED: {
                finalCompState = Component.FinalComponentState.CANCELLED;
                finalStateForDm = FinalComponentState.CANCELLED;
                break;
            }
            default: {
                finalCompState = null;
            }
        }
        ComponentExecutor.ComponentExecutionType compExeType = ComponentExecutor.ComponentExecutionType.TearDown;
        compExeType.setFinalComponentStateAfterTearedDown(finalCompState);
        ComponentExecutor compExecutor = new ComponentExecutor(this.compExeRelatedInstances, compExeType);
        this.compExecutorRef.set(compExecutor);
        this.currentTask = this.threadPool.submit((Runnable)new AsyncTearDownTask(compState, finalCompState, finalStateForDm));
    }

    private void disposeAsync() {
        this.currentTask = this.threadPool.submit((Runnable)new AsyncDisposeTask());
    }

    private void checkForIntermediateButNoFinalHistoryDataItemWritten() throws ComponentExecutionException {
        if (!this.compExeRelatedInstances.compExeRelatedStates.finalHistoryDataItemWritten.get() && Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue() && this.compExeRelatedInstances.compExeRelatedStates.intermediateHistoryDataWritten.get()) {
            LOG.warn((Object)StringUtils.format((String)"No final history data item was written for %s even if intermediate ones were", (Object[])new Object[]{ComponentExecutionUtils.getStringWithInfoAboutComponentAndWorkflowLowerCase(this.compExeRelatedInstances.compExeCtx)}));
        }
        this.compExeRelatedInstances.compExeRelatedStates.intermediateHistoryDataWritten.set(false);
        this.compExeRelatedInstances.compExeRelatedStates.finalHistoryDataItemWritten.set(false);
    }

    private void idle() {
        if (!this.compExeRelatedInstances.compExeCtx.isConnectedToEndpointDatumSenders()) {
            this.compExeRelatedInstances.compCtxBridge.closeAllOutputs();
            this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.FINISHED));
        } else {
            this.compExeRelatedInstances.compExeScheduler.enable();
        }
    }

    private File createWorkingDirectory() throws ComponentExecutionException {
        try {
            return TempFileServiceAccess.getInstance().createManagedTempDir("cmp-" + this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier());
        }
        catch (IOException e) {
            throw new ComponentExecutionException(StringUtils.format((String)"Failed to create working directory for component '%s' (%s) of workflow '%s' (%s)", (Object[])new Object[]{this.compExeRelatedInstances.compExeCtx.getInstanceName(), this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier(), this.compExeRelatedInstances.compExeCtx.getWorkflowInstanceName(), this.compExeRelatedInstances.compExeCtx.getWorkflowExecutionIdentifier()}), e);
        }
    }

    private void disposeWorkingDirectory() {
        if (this.compExeRelatedInstances.compExeCtx.getWorkingDirectory() != null) {
            try {
                TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.compExeRelatedInstances.compExeCtx.getWorkingDirectory());
            }
            catch (IOException e) {
                LOG.error((Object)StringUtils.format((String)"Failed to dispose working directory of %s ", (Object[])new Object[]{ComponentExecutionUtils.getStringWithInfoAboutComponentAndWorkflowLowerCase(this.compExeRelatedInstances.compExeCtx)}), (Throwable)e);
            }
        }
    }

    private boolean isCanceling(ComponentState state) {
        return state == ComponentState.CANCELLING || state == ComponentState.CANCELLING_AFTER_FAILURE;
    }

    protected void bindComponentExecutionService(ComponentExecutionService newService) {
        comExeService = newService;
    }

    protected void bindComponentExecutionStatsService(ComponentExecutionStatsService newService) {
        compExeStatsService = newService;
    }

    protected void bindComponentExecutionRelatedInstancesFactory(ComponentExecutionRelatedInstancesFactory newService) {
        compExeInstancesFactory = newService;
    }

    private final class AsyncCancelTask
    implements Runnable {
        private static final int WAIT_INTERVAL_CANCEL_SEC = 70;
        private final Future<?> task;

        AsyncCancelTask(Future<?> future) {
            this.task = future;
        }

        @Override
        @TaskDescription(value="Cancel component")
        public void run() {
            ComponentExecutor compExecutor = ComponentStateMachine.this.compExecutorRef.get();
            if (compExecutor != null) {
                compExecutor.onCancelled();
            }
            if (this.task != null) {
                try {
                    this.task.get(70L, TimeUnit.SECONDS);
                    this.cancelAttemptSuccessful();
                }
                catch (ExecutionException e) {
                    ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.CANCEL_ATTEMPT_FAILED, e));
                }
                catch (InterruptedException | TimeoutException exception) {
                    this.task.cancel(true);
                }
            } else {
                this.cancelAttemptSuccessful();
            }
        }

        private void cancelAttemptSuccessful() {
            if (ComponentStateMachine.this.compExeRelatedInstances.compExeScheduler.isLoopResetRequested()) {
                ComponentStateMachine.this.compExeRelatedInstances.consoleRowsSender.sendLogFileWriteTriggerAsConsoleRow();
            }
            ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.CANCEL_ATTEMPT_SUCCESSFUL));
        }
    }

    private final class AsyncCompleteVerificationTask
    implements Runnable {
        private final boolean outputsApprove;

        protected AsyncCompleteVerificationTask(boolean outputsApprove) {
            this.outputsApprove = outputsApprove;
        }

        @Override
        @TaskDescription(value="Let component complete verification")
        public void run() {
            try {
                ComponentStateMachine.this.compExecutorRef.get().executeByConsideringLimitations();
                if (this.outputsApprove) {
                    ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.RESULTS_APPROVED_COMPLETED));
                } else {
                    ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.RESULTS_REJECTED_COMPLETED));
                }
            }
            catch (ComponentExecutionException e) {
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.VERIFICATION_COMPLETION_FAILED, e));
            }
            catch (ComponentException e) {
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.VERIFICATION_COMPLETION_FAILED, e.getMessage()));
            }
        }
    }

    private final class AsyncDisposeTask
    implements Runnable {
        private AsyncDisposeTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @TaskDescription(value="Dispose component")
        public void run() {
            if (ComponentStateMachine.this.compExeRelatedInstances.component != null) {
                try {
                    AtomicReference<Component> atomicReference = ComponentStateMachine.this.compExeRelatedInstances.component;
                    synchronized (atomicReference) {
                        Component component = ComponentStateMachine.this.compExeRelatedInstances.component.get();
                        if (component != null) {
                            component.dispose();
                        }
                    }
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("Failed to dispose " + ComponentExecutionUtils.getStringWithInfoAboutComponentAndWorkflowLowerCase(ComponentStateMachine.this.compExeRelatedInstances.compExeCtx)), (Throwable)e);
                    return;
                }
                ComponentStateMachine.this.disposeWorkingDirectory();
            }
            ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.DISPOSE_ATTEMPT_SUCCESSFUL));
        }
    }

    private final class AsyncHandleVerificationTokenTask
    implements Runnable {
        private AsyncHandleVerificationTokenTask() {
        }

        @Override
        @TaskDescription(value="Let component handle the verification token")
        public void run() {
            try {
                ComponentStateMachine.this.compExecutorRef.get().executeByConsideringLimitations();
            }
            catch (ComponentExecutionException e) {
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.HANDLE_VERIFICATION_TOKEN_FAILED, e));
            }
            catch (ComponentException e) {
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.HANDLE_VERIFICATION_TOKEN_FAILED, e.getMessage()));
            }
        }
    }

    private final class AsyncPrepareTask
    implements Runnable {
        private AsyncPrepareTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @TaskDescription(value="Prepare component")
        public void run() {
            compExeStatsService.addStatsAtComponentStart(ComponentStateMachine.this.compExeRelatedInstances.compExeCtx);
            try {
                ComponentStateMachine.this.compExeRelatedInstances.component.set(this.createNewComponentInstance());
                ((ComponentExecutionContextImpl)ComponentStateMachine.this.compExeRelatedInstances.compExeCtx).setWorkingDirectory(ComponentStateMachine.this.createWorkingDirectory());
                ComponentStateMachine.this.componentContext = new ComponentContextImpl(ComponentStateMachine.this.compExeRelatedInstances.compExeCtx, ComponentStateMachine.this.compExeRelatedInstances.compCtxBridge, ComponentStateMachine.this.compExeRelatedInstances.compExeStorageBridge){

                    @Override
                    public void writeOutput(String outputName, TypedDatum value) {
                        super.writeOutput(outputName, value);
                        ((AsyncPrepareTask)AsyncPrepareTask.this).ComponentStateMachine.this.outputsWritten.put(outputName, value);
                    }
                };
                AtomicReference<Component> atomicReference = ComponentStateMachine.this.compExeRelatedInstances.component;
                synchronized (atomicReference) {
                    ComponentStateMachine.this.compExeRelatedInstances.component.get().setComponentContext(ComponentStateMachine.this.componentContext);
                }
                ComponentStateMachine.this.compExeRelatedInstances.compExeScheduler.initialize(ComponentStateMachine.this.compExeRelatedInstances.compExeCtx);
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.PREPARATION_SUCCESSFUL));
            }
            catch (ComponentExecutionException | RuntimeException e) {
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.PREPARATION_FAILED, e));
            }
        }

        private Component createNewComponentInstance() throws ComponentExecutionException {
            String message = StringUtils.format((String)"Failed to instantiate component '%s' (%s) of workflow '%s' (%s)", (Object[])new Object[]{ComponentStateMachine.this.compExeRelatedInstances.compExeCtx.getInstanceName(), ComponentStateMachine.this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier(), ComponentStateMachine.this.compExeRelatedInstances.compExeCtx.getWorkflowInstanceName(), ComponentStateMachine.this.compExeRelatedInstances.compExeCtx.getWorkflowExecutionIdentifier()});
            try {
                return (Component)Class.forName(ComponentStateMachine.this.compExeRelatedInstances.compExeCtx.getComponentDescription().getClassName()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new ComponentExecutionException(message, e);
            }
        }
    }

    private final class AsyncProcessInputsTask
    implements Runnable {
        private AsyncProcessInputsTask() {
        }

        @Override
        @TaskDescription(value="Let component process inputs")
        public void run() {
            try {
                ComponentStateMachine.this.compExeRelatedInstances.compExeRelatedStates.executionCount.incrementAndGet();
                this.writeProvenanceStart();
                ComponentStateMachine.this.compExecutorRef.get().executeByConsideringLimitations();
                this.writeProvenanceStop();
                ComponentStateMachine.this.checkForIntermediateButNoFinalHistoryDataItemWritten();
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.PROCESSING_INPUTS_SUCCESSFUL));
            }
            catch (ComponentExecutionException e) {
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.PROCESSING_INPUTS_FAILED, e));
            }
            catch (ComponentException e) {
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.PROCESSING_INPUTS_FAILED, e.getMessage()));
            }
        }

        private void writeProvenanceStart() {
            BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            Optional<ServiceReference> provenanceReference = Optional.ofNullable(context.getServiceReference(ProvenanceEventListener.class));
            Optional<ProvenanceEventListener> provenanceService = provenanceReference.map(arg_0 -> ((BundleContext)context).getService(arg_0));
            provenanceService.ifPresent(service -> service.workflowNodeExecutionStarted(ComponentStateMachine.this.componentContext.getWorkflowExecutionIdentifier(), ComponentStateMachine.this.componentContext.getInstanceName(), ComponentStateMachine.this.componentContext.getComponentIdentifier(), ComponentStateMachine.this.componentContext.getExecutionIdentifier(), ComponentStateMachine.this.componentContext.getNodeId().toString()));
        }

        private void writeProvenanceStop() {
            BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            Optional<ServiceReference> provenanceReference = Optional.ofNullable(context.getServiceReference(ProvenanceEventListener.class));
            Optional<ProvenanceEventListener> provenanceService = provenanceReference.map(arg_0 -> ((BundleContext)context).getService(arg_0));
            provenanceService.ifPresent(service -> service.workflowNodeExecutionFinished(ComponentStateMachine.this.componentContext.getExecutionIdentifier()));
        }
    }

    private final class AsyncResetTask
    implements Runnable {
        private AsyncResetTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @TaskDescription(value="Reset component")
        public void run() {
            try {
                try {
                    ComponentStateMachine.this.compExecutorRef.get().executeByConsideringLimitations();
                }
                catch (Throwable throwable) {
                    SortedSet<Integer> sortedSet = ComponentStateMachine.this.executionCountOnResets;
                    synchronized (sortedSet) {
                        ComponentStateMachine.this.executionCountOnResets.add(ComponentStateMachine.this.compExeRelatedInstances.compExeRelatedStates.executionCount.get());
                    }
                    throw throwable;
                }
                SortedSet<Integer> sortedSet = ComponentStateMachine.this.executionCountOnResets;
                synchronized (sortedSet) {
                    ComponentStateMachine.this.executionCountOnResets.add(ComponentStateMachine.this.compExeRelatedInstances.compExeRelatedStates.executionCount.get());
                }
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.RESET_SUCCESSFUL));
            }
            catch (ComponentExecutionException e) {
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.RESET_FAILED, e));
            }
            catch (ComponentException e) {
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.RESET_FAILED, e.getMessage()));
            }
        }
    }

    private final class AsyncStartTask
    implements Runnable {
        private final ComponentExecutor.ComponentExecutionType compExeType;

        protected AsyncStartTask(ComponentExecutor.ComponentExecutionType compExeType) {
            this.compExeType = compExeType;
        }

        @Override
        @TaskDescription(value="Start component")
        public void run() {
            try {
                if (this.compExeType == ComponentExecutor.ComponentExecutionType.StartAsRun) {
                    this.writeProvenanceStart();
                }
                ComponentStateMachine.this.compExecutorRef.get().executeByConsideringLimitations();
                if (this.compExeType == ComponentExecutor.ComponentExecutionType.StartAsRun) {
                    this.writeProvenanceStop();
                }
                if (this.compExeType == ComponentExecutor.ComponentExecutionType.StartAsRun) {
                    ComponentStateMachine.this.checkForIntermediateButNoFinalHistoryDataItemWritten();
                    ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.START_AS_RUN_SUCCESSFUL));
                } else {
                    ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.START_SUCCESSFUL));
                }
            }
            catch (ComponentExecutionException e) {
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.START_FAILED, e));
            }
            catch (ComponentException e) {
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.START_FAILED, e.getMessage()));
            }
        }

        private void writeProvenanceStart() {
            BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            Optional<ServiceReference> provenanceReference = Optional.ofNullable(context.getServiceReference(ProvenanceEventListener.class));
            Optional<ProvenanceEventListener> provenanceService = provenanceReference.map(arg_0 -> ((BundleContext)context).getService(arg_0));
            provenanceService.ifPresent(service -> service.workflowNodeExecutionStarted(ComponentStateMachine.this.componentContext.getWorkflowExecutionIdentifier(), ComponentStateMachine.this.componentContext.getInstanceName(), ComponentStateMachine.this.componentContext.getComponentIdentifier(), ComponentStateMachine.this.componentContext.getExecutionIdentifier(), ComponentStateMachine.this.componentContext.getNodeId().toString()));
        }

        private void writeProvenanceStop() {
            BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            Optional<ServiceReference> provenanceReference = Optional.ofNullable(context.getServiceReference(ProvenanceEventListener.class));
            Optional<ProvenanceEventListener> provenanceService = provenanceReference.map(arg_0 -> ((BundleContext)context).getService(arg_0));
            provenanceService.ifPresent(service -> service.workflowNodeExecutionFinished(ComponentStateMachine.this.componentContext.getExecutionIdentifier()));
        }
    }

    private final class AsyncTearDownTask
    implements Runnable {
        private final ComponentState compState;
        private final Component.FinalComponentState finalCompState;
        private final FinalComponentState finalStateForDm;

        AsyncTearDownTask(ComponentState compState, Component.FinalComponentState finalCompState, FinalComponentState finalStateForDm) {
            this.compState = compState;
            this.finalCompState = finalCompState;
            this.finalStateForDm = finalStateForDm;
        }

        @Override
        @TaskDescription(value="Tear down component")
        public void run() {
            if (ComponentStateMachine.this.compExeRelatedInstances.component != null) {
                try {
                    ComponentStateMachine.this.compExecutorRef.get().executeByConsideringLimitations();
                }
                catch (ComponentExecutionException e) {
                    ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.TEARED_DOWN, ComponentState.FAILED, e));
                    return;
                }
                catch (ComponentException e) {
                    ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.TEARED_DOWN, ComponentState.FAILED, e.getMessage()));
                }
                if (this.finalCompState == Component.FinalComponentState.FAILED) {
                    try {
                        ComponentStateMachine.this.checkForIntermediateButNoFinalHistoryDataItemWritten();
                    }
                    catch (ComponentExecutionException e) {
                        ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.TEARED_DOWN, ComponentState.FAILED, e));
                        return;
                    }
                }
            }
            try {
                ComponentStateMachine.this.compExeRelatedInstances.compExeStorageBridge.setFinalComponentState(this.finalStateForDm);
            }
            catch (ComponentExecutionException e) {
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.TEARED_DOWN, ComponentState.FAILED, e));
                return;
            }
            ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.TEARED_DOWN, this.compState));
        }
    }

    private class CancelAttemptSuccessfulEventProcessor
    implements EventProcessor {
        private CancelAttemptSuccessfulEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState state = currentState;
            if (ComponentStateMachine.this.checkStateChange(currentState, ComponentState.TEARING_DOWN, event)) {
                if (currentState == ComponentState.CANCELLING_AFTER_FAILURE) {
                    ComponentStateMachine.this.tearDownAsync(ComponentState.FAILED);
                } else {
                    ComponentStateMachine.this.tearDownAsync(ComponentState.CANCELED);
                }
                state = ComponentState.TEARING_DOWN;
            }
            return state;
        }
    }

    private class CancelRequestedEventProcessor
    implements EventProcessor {
        private CancelRequestedEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState state = currentState;
            if (ComponentStateMachine.this.checkStateChange(currentState, ComponentState.CANCELLING, event)) {
                state = ComponentState.CANCELLING;
                ComponentStateMachine.this.cancelAsync();
            }
            return state;
        }
    }

    private class DisposeAttemptSuccessfulEventProcessor
    implements EventProcessor {
        private DisposeAttemptSuccessfulEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState state = currentState;
            if (ComponentStateMachine.this.checkStateChange(currentState, ComponentState.DISPOSED, event)) {
                state = ComponentState.DISPOSED;
            }
            return state;
        }
    }

    private class DisposeRequestedEventProcessor
    implements EventProcessor {
        private DisposeRequestedEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState state = currentState;
            if (ComponentStateMachine.this.checkStateChange(currentState, ComponentState.DISPOSING, event)) {
                state = ComponentState.DISPOSING;
                ComponentStateMachine.this.disposeAsync();
            }
            return state;
        }
    }

    private static interface EventProcessor {
        public ComponentState processEvent(ComponentState var1, ComponentStateMachineEvent var2);
    }

    private class FailedEventProcessor
    implements EventProcessor {
        private FailedEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState state = currentState;
            if (ComponentStateMachine.this.checkStateChange(currentState, ComponentState.TEARING_DOWN, event)) {
                state = ComponentStateMachine.this.handleFailure(currentState, event);
            }
            return state;
        }
    }

    private class FinishedEventProcessor
    implements EventProcessor {
        private FinishedEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState state = currentState;
            if (ComponentStateMachine.this.checkStateChange(currentState, ComponentState.TEARING_DOWN, event)) {
                state = ComponentStateMachine.this.handleFinished();
            }
            return state;
        }
    }

    private class IdleRequestedEventProcessor
    implements EventProcessor {
        private IdleRequestedEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState state = currentState;
            ComponentState newCompState = event.getNewComponentState();
            if (newCompState == null) {
                newCompState = ComponentState.IDLING;
            }
            if (ComponentStateMachine.this.checkStateChange(currentState, newCompState, event)) {
                state = newCompState;
                ComponentStateMachine.this.idle();
            }
            return state;
        }
    }

    private class NewSchedulingStateEventProcessor
    implements EventProcessor {
        private NewSchedulingStateEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            switch (ComponentStateMachine.this.compExeRelatedInstances.compExeScheduler.getSchedulingState()) {
                case FINISHED: {
                    this.forwardFinishToNonClosedOutputs();
                    ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.FINISHED));
                    break;
                }
                case PROCESS_INPUT_DATA: {
                    this.requestProcessingInputDatums(ComponentStateMachine.this.compExeRelatedInstances.compExeScheduler.fetchEndpointDatums());
                    break;
                }
                case PROCESS_INPUT_DATA_WITH_NOT_A_VALUE_DATA: {
                    ComponentInterface compInterface = ComponentStateMachine.this.compExeRelatedInstances.compExeCtx.getComponentDescription().getComponentInstallation().getComponentInterface();
                    Map<String, EndpointDatum> endpointDatums = ComponentStateMachine.this.compExeRelatedInstances.compExeScheduler.fetchEndpointDatums();
                    if (compInterface.getCanHandleNotAValueDataTypes() || compInterface.getIsLoopDriver() && this.wasNotAValueReceivedOnlyAtSameLoopInput(endpointDatums)) {
                        this.requestProcessingInputDatums(endpointDatums);
                        break;
                    }
                    for (EndpointDatum endpointDatum : endpointDatums.values()) {
                        if (!endpointDatum.getValue().getDataType().equals((Object)DataType.NotAValue)) continue;
                        this.forwardNotAValueData(endpointDatum);
                        break;
                    }
                    ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.IDLE_REQUESTED));
                    break;
                }
                case RESET: {
                    this.forwardInternalTD(ComponentStateMachine.this.compExeRelatedInstances.compExeScheduler.getResetDatum());
                    if (((ComponentState)ComponentStateMachine.this.getState()).equals((Object)ComponentState.IDLING_AFTER_RESET)) {
                        ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.IDLE_REQUESTED, ComponentState.IDLING_AFTER_RESET));
                        break;
                    }
                    ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.RESET_REQUESTED));
                    break;
                }
                case FAILURE_FORWARD: {
                    this.forwardInternalTD(ComponentStateMachine.this.compExeRelatedInstances.compExeScheduler.getFailureDatum());
                    ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.IDLE_REQUESTED));
                    break;
                }
                case LOOP_RESET: {
                    ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.RESET_REQUESTED));
                    break;
                }
            }
            return currentState;
        }

        private boolean wasNotAValueReceivedOnlyAtSameLoopInput(Map<String, EndpointDatum> endpointDatums) {
            EndpointDescriptionsManager inputDescManager = ComponentStateMachine.this.compExeRelatedInstances.compExeCtx.getComponentDescription().getInputDescriptionsManager();
            for (Map.Entry<String, EndpointDatum> datum : endpointDatums.entrySet()) {
                if (!datum.getValue().getValue().getDataType().equals((Object)DataType.NotAValue) || !inputDescManager.getEndpointDescription(datum.getKey()).getEndpointDefinition().getEndpointCharacter().equals((Object)EndpointCharacter.OUTER_LOOP)) continue;
                return false;
            }
            return true;
        }

        private void forwardInternalTD(InternalTDImpl internalTD) {
            WorkflowGraphPath hopsToTraverse = internalTD.getHopsToTraverse();
            WorkflowGraphHop currentHop = hopsToTraverse.poll();
            ComponentStateMachine.this.compExeRelatedInstances.typedDatumToOutputWriter.writeTypedDatumToOutputConsideringOnlyCertainInputs(currentHop.getHopOuputName(), (TypedDatum)internalTD, currentHop.getTargetExecutionIdentifier().toString(), currentHop.getTargetInputName());
        }

        private void forwardFinishToNonClosedOutputs() {
            for (EndpointDescription output : ComponentStateMachine.this.compExeRelatedInstances.compExeCtx.getComponentDescription().getOutputDescriptionsManager().getEndpointDescriptions()) {
                if (ComponentStateMachine.this.compExeRelatedInstances.compCtxBridge.isOutputClosed(output.getName())) continue;
                ComponentStateMachine.this.compExeRelatedInstances.typedDatumToOutputWriter.writeTypedDatumToOutput(output.getName(), (TypedDatum)new InternalTDImpl(InternalTDImpl.InternalTDType.WorkflowFinish));
            }
        }

        private void forwardNotAValueData(EndpointDatum nAVEndpointDatum) {
            ComponentInterface compInterface = ComponentStateMachine.this.compExeRelatedInstances.compExeCtx.getComponentDescription().getComponentInstallation().getComponentInterface();
            for (EndpointDescription output : ComponentStateMachine.this.compExeRelatedInstances.compExeCtx.getComponentDescription().getOutputDescriptionsManager().getEndpointDescriptions()) {
                if (compInterface.getIsLoopDriver() && !output.getEndpointDefinition().getEndpointCharacter().equals((Object)EndpointCharacter.OUTER_LOOP)) continue;
                ComponentStateMachine.this.compExeRelatedInstances.typedDatumToOutputWriter.writeTypedDatumToOutput(output.getName(), nAVEndpointDatum.getValue());
            }
            LOG.info((Object)StringUtils.format((String)"Component '%s' of workflow '%s' did not run because of 'not a value' value at input '%s'", (Object[])new Object[]{ComponentStateMachine.this.compExeRelatedInstances.compExeCtx.getInstanceName(), ComponentStateMachine.this.compExeRelatedInstances.compExeCtx.getWorkflowInstanceName(), nAVEndpointDatum.getInputName()}));
        }

        private void requestProcessingInputDatums(Map<String, EndpointDatum> endpointDatums) {
            try {
                ComponentStateMachine.this.compExeRelatedInstances.compCtxBridge.setEndpointDatumsForExecution(endpointDatums);
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.PROCESSING_INPUT_DATUMS_REQUESTED));
            }
            catch (ComponentExecutionException componentExecutionException) {
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.PROCESSING_INPUTS_FAILED));
            }
        }
    }

    private class PauseRequestedEventProcessor
    implements EventProcessor {
        private PauseRequestedEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            if (ComponentStateMachine.this.compExeRelatedInstances.compExeScheduler.isEnabled()) {
                ComponentStateMachine.this.compExeRelatedInstances.compExeScheduler.disable();
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.PAUSE_REQUESTED));
                return currentState;
            }
            if (currentState == ComponentState.IDLING || currentState == ComponentState.IDLING_AFTER_RESET) {
                ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.IDLE_REQUESTED, currentState));
            }
            ComponentStateMachine.this.pauseWasRequested = true;
            return ComponentState.PAUSING;
        }
    }

    private class PreparationSuccessfulEventProcessor
    implements EventProcessor {
        private PreparationSuccessfulEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState state = currentState;
            if (ComponentStateMachine.this.checkStateChange(currentState, ComponentState.PREPARED, event)) {
                ComponentStateMachine.this.currentTask = null;
                state = ComponentState.PREPARED;
            }
            return state;
        }
    }

    private class PrepareRequestedEventProcessor
    implements EventProcessor {
        private PrepareRequestedEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState state = currentState;
            if (ComponentStateMachine.this.checkStateChange(currentState, ComponentState.PREPARING, event)) {
                state = ComponentState.PREPARING;
                ComponentStateMachine.this.prepareAsync();
            }
            return state;
        }
    }

    private class ProcessingInputsDatumRequestedEventProcessor
    implements EventProcessor {
        private ProcessingInputsDatumRequestedEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState state = currentState;
            if (ComponentStateMachine.this.checkStateChange(currentState, ComponentState.WAITING_FOR_RESOURCES, event)) {
                state = ComponentState.WAITING_FOR_RESOURCES;
                ComponentStateMachine.this.processInputsAsync();
            }
            return state;
        }
    }

    private class ResetRequestedEventProcessor
    implements EventProcessor {
        private ResetRequestedEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState state = currentState;
            if (ComponentStateMachine.this.checkStateChange(currentState, ComponentState.WAITING_FOR_RESOURCES, event)) {
                state = ComponentState.WAITING_FOR_RESOURCES;
                ComponentStateMachine.this.resetAsync();
            }
            return state;
        }
    }

    private class ResetSuccessfulEventProcessor
    implements EventProcessor {
        private ResetSuccessfulEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState state = currentState;
            if (ComponentStateMachine.this.checkStateChange(currentState, ComponentState.IDLING_AFTER_RESET, event)) {
                state = ComponentState.IDLING_AFTER_RESET;
                ComponentStateMachine.this.idle();
            }
            return state;
        }
    }

    private class ResultsApprovalRequestedEventProcessor
    implements EventProcessor {
        private static final int VERIFICATION_TOKEN_LENGTH = 32;

        private ResultsApprovalRequestedEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            String verificationToken = IdGenerator.secureRandomHexString((int)32);
            ComponentStateMachine.this.handleVerificationTokenAsync(verificationToken);
            return ComponentState.WAITING_FOR_APPROVAL;
        }
    }

    private class ResultsApprovedCompletedSuccessfulEventProcessor
    implements EventProcessor {
        private ResultsApprovedCompletedSuccessfulEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState newState = currentState;
            if (!ComponentStateMachine.this.isCanceling(currentState)) {
                newState = new IdleRequestedEventProcessor().processEvent(currentState, event);
            }
            return newState;
        }
    }

    private class ResultsApprovedEventProcessor
    implements EventProcessor {
        private ResultsApprovedEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentStateMachine.this.latestVerificationToken = null;
            ComponentStateMachine.this.compExeRelatedInstances.compCtxBridge.flushOutputs();
            ComponentStateMachine.this.componentContext.getLog().componentInfo("Result approved (was done by person responsible for the component) -> outputs sent");
            ComponentStateMachine.this.completeVerificationAsync(true);
            return currentState;
        }
    }

    private class ResultsRejectedCompletedSuccessfulEventProcessor
    implements EventProcessor {
        private ResultsRejectedCompletedSuccessfulEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState state = currentState;
            if (ComponentStateMachine.this.checkStateChange(currentState, ComponentState.TEARING_DOWN, event)) {
                state = ComponentState.TEARING_DOWN;
                ComponentStateMachine.this.tearDownAsync(ComponentState.RESULTS_REJECTED);
            }
            return state;
        }
    }

    private class ResultsRejectedEventProcessor
    implements EventProcessor {
        private ResultsRejectedEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentStateMachine.this.componentContext.getLog().componentWarn("Results rejected (was done by person responsible for the component) -> cancel");
            ComponentStateMachine.this.completeVerificationAsync(false);
            return currentState;
        }
    }

    private class ResumeRequestedEventProcessor
    implements EventProcessor {
        private ResumeRequestedEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState state = currentState;
            if (ComponentStateMachine.this.checkStateChange(currentState, ComponentState.RESUMING, event)) {
                state = ComponentState.RESUMING;
                ComponentStateMachine.this.postEvent(ComponentStateMachine.this.lastEventBeforePaused);
            }
            return state;
        }
    }

    private class RunningEventProcessor
    implements EventProcessor {
        private RunningEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState state = currentState;
            if (ComponentStateMachine.this.checkStateChange(currentState, event.getNewComponentState(), event)) {
                state = event.getNewComponentState();
            }
            return state;
        }
    }

    private class StartAsRunOrProcessingInputsSuccessfulEventProcessor
    implements EventProcessor {
        private StartAsRunOrProcessingInputsSuccessfulEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState newState = currentState;
            if (!ComponentStateMachine.this.isCanceling(currentState)) {
                ConfigurationDescription compConfigDesc = ComponentStateMachine.this.compExeRelatedInstances.compExeCtx.getComponentDescription().getConfigurationDescription();
                if (ComponentExecutionUtils.isManualOutputVerificationRequired(compConfigDesc)) {
                    ComponentStateMachine.this.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.RESULT_APPROVAL_REQUESTED));
                } else {
                    newState = new IdleRequestedEventProcessor().processEvent(currentState, event);
                }
            }
            return newState;
        }
    }

    private class StartRequestedEventProcessor
    implements EventProcessor {
        private StartRequestedEventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState state = currentState;
            if (ComponentStateMachine.this.checkStateChange(currentState, ComponentState.WAITING_FOR_RESOURCES, event)) {
                state = ComponentState.WAITING_FOR_RESOURCES;
                AtomicReference<Component> atomicReference = ComponentStateMachine.this.compExeRelatedInstances.component;
                synchronized (atomicReference) {
                    if (ComponentStateMachine.this.compExeRelatedInstances.component.get().treatStartAsComponentRun()) {
                        ComponentStateMachine.this.compExeRelatedInstances.compExeRelatedStates.executionCount.incrementAndGet();
                    }
                }
                ComponentStateMachine.this.startAsync();
            }
            return state;
        }
    }

    private class StartSuccessfulEventProcessor
    implements EventProcessor {
        private StartSuccessfulEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            if (!ComponentStateMachine.this.isCanceling(currentState)) {
                return new IdleRequestedEventProcessor().processEvent(currentState, event);
            }
            return currentState;
        }
    }

    private class TearedDownEventProcessor
    implements EventProcessor {
        private TearedDownEventProcessor() {
        }

        @Override
        public ComponentState processEvent(ComponentState currentState, ComponentStateMachineEvent event) {
            ComponentState state = currentState;
            if (ComponentStateMachine.this.checkStateChange(currentState, event.getNewComponentState(), event)) {
                ComponentStateMachine.this.handleFailureEvent(event);
                state = event.getNewComponentState();
            }
            return state;
        }
    }
}

