/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.eventlog.api;

import de.rcenvironment.core.eventlog.api.EventLogEntry;
import de.rcenvironment.core.eventlog.api.EventType;
import de.rcenvironment.core.eventlog.backends.api.EventLogBackend;
import de.rcenvironment.core.eventlog.internal.EventLogEntryImpl;
import de.rcenvironment.core.eventlog.internal.EventLogFallbackBackend;
import de.rcenvironment.core.eventlog.internal.EventLogNOPBackend;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EventLog {
    private static EventLog sharedInstance = new EventLog(new EventLogFallbackBackend());
    private final EventLogBackend[] backends;

    protected EventLog(EventLogBackend ... backends) {
        this.backends = backends;
    }

    public static synchronized void initialize(EventLogBackend ... backends) {
        if (sharedInstance != null && !(EventLog.sharedInstance.backends[0] instanceof EventLogFallbackBackend)) {
            throw new IllegalStateException("Already initialized with custom backend");
        }
        if (backends.length == 0) {
            throw new IllegalStateException("At least one backend is required");
        }
        sharedInstance = new EventLog(backends);
    }

    @Deprecated
    public static synchronized void disableForIntegrationTesting() {
        sharedInstance = new EventLog(new EventLogNOPBackend());
    }

    public static EventLogEntry newEntry(EventType eventType) {
        return new EventLogEntryImpl(eventType);
    }

    public static synchronized void append(EventLogEntry entry) {
        if (sharedInstance == null) {
            throw new IllegalStateException("Not initialized");
        }
        sharedInstance.appendInternal(entry);
    }

    public static synchronized void append(EventType eventType, Map<String, String> data) {
        if (sharedInstance == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (data == null) {
            data = new HashMap<String, String>();
        }
        sharedInstance.appendInternal(new EventLogEntryImpl(Instant.now(), eventType, data));
    }

    public static synchronized void append(EventType eventType, String key, String value) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(key, value);
        EventLog.append(eventType, data);
    }

    public static synchronized void close() {
        if (sharedInstance == null) {
            EventLog.getStandardLog().warn((Object)"Event log requested to close without being initialized first; ignoring call");
            return;
        }
        EventLogBackend[] eventLogBackendArray = EventLog.sharedInstance.backends;
        int n = EventLog.sharedInstance.backends.length;
        int n2 = 0;
        while (n2 < n) {
            EventLogBackend backend = eventLogBackendArray[n2];
            try {
                backend.close();
            }
            catch (IOException e) {
                EventLog.getStandardLog().error((Object)("Error closing event log backend: " + e.toString()));
            }
            ++n2;
        }
        sharedInstance = null;
    }

    protected void appendInternal(EventLogEntry logEntry) {
        EventLogBackend[] eventLogBackendArray = this.backends;
        int n = this.backends.length;
        int n2 = 0;
        while (n2 < n) {
            EventLogBackend backend = eventLogBackendArray[n2];
            try {
                backend.append((EventLogEntryImpl)logEntry);
            }
            catch (IOException e) {
                EventLog.getStandardLog().error((Object)("Error writing to event log: " + e.toString()));
            }
            ++n2;
        }
    }

    private static Log getStandardLog() {
        return LogFactory.getLog(EventLog.class);
    }
}

