/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.client.session.impl;

import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSession;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionListener;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionSetup;
import de.rcenvironment.core.utils.ssh.jsch.SshSessionConfiguration;
import de.rcenvironment.core.utils.ssh.jsch.SshSessionConfigurationFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshUplinkConnectionSetupImpl
implements SshUplinkConnectionSetup {
    private SshSessionConfiguration config;
    private String id;
    private String displayName;
    private String qualifier;
    private ClientSideUplinkSession session;
    private boolean connectOnStartup;
    private boolean autoRetry;
    private boolean usePassphrase;
    private boolean isGateway;
    private AtomicBoolean wantToReconnect;
    private int consecutiveConnectionFailures;
    private volatile boolean waitingForRetry;
    private String destinationIdPrefix;
    private Log log = LogFactory.getLog(this.getClass());

    public SshUplinkConnectionSetupImpl(String id, String displayName, String qualifier, String host, int port, String userName, String keyFileLocation, boolean usePassphrase, boolean connectOnStartUp, boolean autoRetry, boolean isGateway, SshUplinkConnectionListener listener) {
        this.config = keyFileLocation == null || keyFileLocation.isEmpty() ? SshSessionConfigurationFactory.createSshSessionConfigurationWithAuthPhrase((String)host, (int)port, (String)userName, null) : SshSessionConfigurationFactory.createSshSessionConfigurationWithKeyFileLocation((String)host, (int)port, (String)userName, (String)keyFileLocation);
        this.id = id;
        this.connectOnStartup = connectOnStartUp;
        this.autoRetry = autoRetry;
        this.displayName = displayName;
        this.qualifier = qualifier;
        this.usePassphrase = usePassphrase;
        this.consecutiveConnectionFailures = 0;
        this.waitingForRetry = false;
        this.isGateway = isGateway;
        this.wantToReconnect = new AtomicBoolean(autoRetry);
        listener.onCreated(this);
    }

    @Override
    public String getHost() {
        return this.config.getDestinationHost();
    }

    @Override
    public int getPort() {
        return this.config.getPort();
    }

    @Override
    public String getUsername() {
        return this.config.getSshAuthUser();
    }

    @Override
    public String getKeyfileLocation() {
        return this.config.getSshKeyFileLocation();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean isConnected() {
        return this.session != null && this.session.isActive();
    }

    @Override
    public boolean isWaitingForRetry() {
        return this.waitingForRetry;
    }

    @Override
    public ClientSideUplinkSession getSession() {
        return this.session;
    }

    @Override
    public void setSession(ClientSideUplinkSession session) {
        if (session != null && this.session != null) {
            this.log.warn((Object)("Attaching new Uplink session " + session.getLocalSessionId() + " before the previous session " + this.session.getLocalSessionId() + " was disposed"));
        }
        this.session = session;
        this.wantToReconnect.set(this.autoRetry);
    }

    @Override
    public void disconnect() {
        this.wantToReconnect.set(false);
        this.session.initiateCleanShutdownIfRunning();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean getConnectOnStartUp() {
        return this.connectOnStartup;
    }

    @Override
    public boolean getUsePassphrase() {
        return this.usePassphrase;
    }

    @Override
    public boolean getAutoRetry() {
        return this.autoRetry;
    }

    @Override
    public void setWaitingForRetry(boolean waitingForRetry) {
        this.waitingForRetry = waitingForRetry;
        if (!waitingForRetry) {
            this.consecutiveConnectionFailures = 0;
        }
    }

    @Override
    public void resetConsecutiveConnectionFailures() {
        this.consecutiveConnectionFailures = 0;
    }

    @Override
    public void raiseConsecutiveConnectionFailures() {
        ++this.consecutiveConnectionFailures;
    }

    @Override
    public int getConsecutiveConnectionFailures() {
        return this.consecutiveConnectionFailures;
    }

    @Override
    public String getDestinationIdPrefix() {
        return this.destinationIdPrefix;
    }

    @Override
    public void setDestinationIdPrefix(String destinationIdPrefix) {
        this.destinationIdPrefix = destinationIdPrefix;
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public boolean isGateway() {
        return this.isGateway;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public boolean wantToReconnect() {
        return this.wantToReconnect.get();
    }
}

