/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.workflow.execution.internal;

import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.notification.DistributedNotificationService;
import de.rcenvironment.core.notification.NotificationSubscriber;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.workflow.execution.internal.WorkflowStateNotificationHandler;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import org.apache.commons.logging.LogFactory;

class WorkflowRunAdapter {
    private static final int INTERVAL_BETWEEN_HEARTBEAT_CHECKS_IN_MS = 1000;
    private static final long MAX_TIME_BETWEEN_HEARTBEATS_IN_MS = 20000L;
    private final Semaphore workflowFinished = new Semaphore(0);
    private final LongSupplier timeService;
    private final AsyncTaskService taskService;
    private WorkflowState workflowState;
    private AtomicLong timestampOfLastHeartbeat;

    protected WorkflowRunAdapter(LongSupplier timeService, AsyncTaskService taskService) {
        this.timeService = timeService;
        this.taskService = taskService;
    }

    public void awaitWorkflowTermination() throws InterruptedException {
        ScheduledFuture backgroundTask = this.taskService.scheduleAtFixedInterval("Check for workflow heartbeat", () -> {
            if (this.timeService.getAsLong() - this.getTimestampOfLastHeartbeat() > 20000L) {
                LogFactory.getLog(WorkflowRunAdapter.class).debug((Object)"Finishing wait for workflow termination due to missing heartbeat");
                this.workflowState = WorkflowState.FAILED;
                this.workflowFinished.release();
            }
        }, 1000L);
        this.workflowFinished.acquire();
        backgroundTask.cancel(false);
    }

    public void onWorkflowTermination(WorkflowState finalStatus) {
        this.workflowFinished.release();
        this.workflowState = finalStatus;
    }

    public boolean executionFailed() {
        return WorkflowState.FAILED.equals((Object)this.workflowState);
    }

    private void onWorkflowHeartbeat() {
        this.timestampOfLastHeartbeat.set(this.timeService.getAsLong());
    }

    public long getTimestampOfLastHeartbeat() {
        return this.timestampOfLastHeartbeat.get();
    }

    static /* synthetic */ void access$0(WorkflowRunAdapter workflowRunAdapter) {
        workflowRunAdapter.onWorkflowHeartbeat();
    }

    public static class Builder {
        private String workflowExecutionIdentifier;
        private DistributedNotificationService notificationService;
        private LongSupplier timeService;
        private AsyncTaskService taskService;

        public Builder workflowExecutionIdentifier(String executionIdentifier) {
            this.workflowExecutionIdentifier = executionIdentifier;
            return this;
        }

        public Builder distributedNotificationService(DistributedNotificationService service) {
            this.notificationService = service;
            return this;
        }

        public Builder timeService(LongSupplier service) {
            this.timeService = service;
            return this;
        }

        public Builder taskService(AsyncTaskService service) {
            this.taskService = service;
            return this;
        }

        public WorkflowRunAdapter buildAndRegisterForWorkflowStateUpdates() throws RemoteOperationException {
            Objects.requireNonNull(this.timeService);
            Objects.requireNonNull(this.taskService);
            WorkflowRunAdapter product = new WorkflowRunAdapter(this.timeService, this.taskService);
            product.timestampOfLastHeartbeat = new AtomicLong(this.timeService.getAsLong());
            this.notificationService.subscribe("rce.component.workflow.state:" + this.workflowExecutionIdentifier, (NotificationSubscriber)new WorkflowStateNotificationHandler(this.workflowExecutionIdentifier, () -> WorkflowRunAdapter.access$0(product), product::onWorkflowTermination), null);
            return product;
        }
    }
}

