/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.xpathchooser;

import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataDefinition;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.EndpointActionType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointEditDialog;
import de.rcenvironment.core.gui.xpathchooser.Messages;
import de.rcenvironment.core.gui.xpathchooser.VariableEntry;
import de.rcenvironment.core.gui.xpathchooser.XPathChooserDialog;
import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class XPathEditDialog
extends EndpointEditDialog {
    private static final int TEXT_HEIGHT = 60;
    private static final String CHANNEL_XPATH = "variable.xpath";
    private static final int DIALOG_WIDTH = 345;
    private static final int DIALOG_HEIGHT = 435;

    public XPathEditDialog(Shell parentShell, EndpointActionType actionType, ComponentInstanceProperties configuration, EndpointType direction, String id, boolean isStatic, EndpointMetaDataDefinition metaData, Map<String, String> metadataValues) {
        super(parentShell, actionType, configuration, direction, id, isStatic, metaData, metadataValues);
    }

    protected Point getInitialSize() {
        return new Point(345, 435);
    }

    protected Control createConfigurationArea(Composite parent) {
        Control superControl = super.createConfigurationArea(parent);
        this.createXPathChoosingButton(parent);
        return superControl;
    }

    private void createXPathChoosingButton(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, false);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)gd);
        Button selectButton = new Button(container, 0);
        selectButton.setText(Messages.selectButton);
        GridData g = new GridData();
        g.horizontalAlignment = 3;
        g.grabExcessHorizontalSpace = true;
        selectButton.setLayoutData((Object)g);
        selectButton.addListener(13, event -> this.createXPathDialog());
    }

    private void createXPathDialog() {
        Widget address;
        VariableEntry newVar;
        String xpath;
        XPathChooserDialog dialog = new XPathChooserDialog(super.getShell(), null);
        if (dialog.getChooser() != null && dialog.open() == 0 && (xpath = (newVar = dialog.getSelectedVariable()).getXpath()) != null && !xpath.isEmpty() && (address = super.getWidget(CHANNEL_XPATH)) instanceof Text) {
            ((Text)address).setText(xpath);
        }
    }

    protected Text createLabelAndTextfield(Composite container, String text, String dataType, String value) {
        new Label(container, 0).setText(text);
        Text result = new Text(container, 2626);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.heightHint = 60;
        result.setLayoutData((Object)layoutData);
        result.setText(value);
        this.addVerifyListener(dataType, value, result);
        return result;
    }
}

