/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.workflowintegration.editor.pages;

import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessageStore;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowPlaceholderHandler;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.integration.common.editor.IIntegrationEditorPage;
import de.rcenvironment.core.gui.integration.common.editor.IntegrationEditor;
import de.rcenvironment.core.gui.integration.common.editor.IntegrationEditorButtonBar;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.WorkflowIntegrationEditor;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.WorkflowIntegrationEditorInput;
import de.rcenvironment.core.gui.integration.workflowintegration.handlers.WIOpenConnectionEditorHandler;
import de.rcenvironment.core.gui.integration.workflowintegration.handlers.WIWorkflowNodeDisEnableHandler;
import de.rcenvironment.core.gui.resources.api.ColorManager;
import de.rcenvironment.core.gui.resources.api.ColorSource;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardColors;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditor;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditorContextMenuProvider;
import de.rcenvironment.core.gui.workflow.editor.WorkflowScalableFreeformRootEditPart;
import de.rcenvironment.core.gui.workflow.editor.WorkflowZoomManager;
import de.rcenvironment.core.gui.workflow.editor.commands.WorkflowNodeDisEnableCommand;
import de.rcenvironment.core.gui.workflow.parts.ConnectionPart;
import de.rcenvironment.core.gui.workflow.parts.ReadOnlyWorkflowEditorEditPartFactory;
import de.rcenvironment.core.gui.workflow.parts.WorkflowNodePart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowPart;
import de.rcenvironment.core.gui.workflow.view.outline.OutlineView;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class WorkflowEditorPage
extends WorkflowEditor
implements IIntegrationEditorPage {
    private static final Image VALIDATION_ERROR_IMAGE = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.FAILED);
    private static final String COMPONENT_PLACEHOLDER_MESSAGE = "This workflow component is configured to require user input when starting the workflow.\n   Since exposing those inputs is currently not supported for integrated workflows,\n   this component needs to be disabled.";
    private static final String ONLY_DISABLED_MESSAGE = "The integrated workflow consists only of disabled components.\nPlease enable at least one component to ensure that the workflow is executable.";
    private static final String PLACEHOLDER_MESSAGE = "At least one component is configured to require user input when starting the workflow.\nSince exposing those inputs is currently not supported for integrated workflows, all of these components need to be disabled.";
    private static final String WORKFLOWINTEGRATION_EDITOR_SCOPE = "de.rcenvironment.rce.gui.integration.workflowintegration.editor.scope";
    private static final String DEFAULT_MESSAGE = "Delete individual connections via the connection editor or disable components in order to map\nopen inputs/outputs of the integrated workflow to inputs/outputs of the component.";
    private static final String TITLE = "Integrated Workflow";
    private static final String HELP_CONTEXT_ID = "de.rcenvironment.core.gui.integration.workflowintegration.integration_workflowEditor";
    private WorkflowIntegrationEditor integrationEditor;
    private IntegrationEditorButtonBar buttonBar;
    private Composite editorArea;
    private boolean pageValid = false;
    private CLabel messageComposite;
    private TabbedPropertySheetPage tabbedPropertySheetPage;

    public WorkflowEditorPage(WorkflowIntegrationEditor integrationEditor) {
        this.integrationEditor = integrationEditor;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    protected void setInput(IEditorInput input) {
        if (input instanceof WorkflowIntegrationEditorInput) {
            this.workflowDescription = (WorkflowDescription)input.getAdapter(WorkflowDescription.class);
            this.setPartName(this.workflowDescription.getName());
            Display.getDefault().asyncExec(() -> {
                if (this.getViewer().getControl() != null) {
                    this.getViewer().setContents((Object)this.workflowDescription);
                    this.validateComponents();
                }
            });
        } else {
            super.setInput(input);
            this.integrationEditor.getController().setWorkflowDescription(this.getWorkflowDescription());
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    private void validateComponents() {
        ComponentValidationMessageStore componentValidationMessageStore = ComponentValidationMessageStore.getInstance();
        componentValidationMessageStore.emptyMessageStore();
        this.getWorkflowNodeParts().stream().forEach(workflowNodePart -> {
            WorkflowNode workflowNode = (WorkflowNode)workflowNodePart.getModel();
            workflowNode.getConfigurationDescription().getConfiguration().keySet().stream().filter(key -> WorkflowPlaceholderHandler.isActivePlaceholder((String)((String)workflowNode.getConfigurationDescription().getConfiguration().get(key)), (ConfigurationDescription)workflowNode.getConfigurationDescription())).forEach(key -> {
                ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
                messages.add(new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, key, "Placeholders not supported.", COMPONENT_PLACEHOLDER_MESSAGE));
                componentValidationMessageStore.addValidationMessagesByComponentId(workflowNode.getIdentifierAsObject().toString(), messages);
            });
            workflowNodePart.updateValid();
        });
        this.updatePageValid();
    }

    public boolean isPageValid() {
        return this.pageValid;
    }

    private void updatePageValid() {
        Optional<Object> message = Optional.empty();
        boolean noPlaceholders = this.getWorkflowNodeParts().stream().map(AbstractEditPart::getModel).filter(WorkflowNode.class::isInstance).map(WorkflowNode.class::cast).noneMatch(node -> !ComponentValidationMessageStore.getInstance().getMessagesByComponentId(node.getIdentifierAsObject().toString()).isEmpty() && node.isEnabled());
        boolean anyComponentEnabled = this.getWorkflowNodeParts().stream().map(AbstractEditPart::getModel).filter(WorkflowNode.class::isInstance).map(WorkflowNode.class::cast).anyMatch(WorkflowNode::isEnabled);
        if (!anyComponentEnabled) {
            message = Optional.of(ONLY_DISABLED_MESSAGE);
        } else if (!noPlaceholders) {
            message = Optional.of(PLACEHOLDER_MESSAGE);
        }
        this.setMessage(message);
        this.pageValid = noPlaceholders && anyComponentEnabled;
        this.integrationEditor.updateValid();
    }

    private List<WorkflowNodePart> getWorkflowNodeParts() {
        ArrayList<WorkflowNodePart> parts = new ArrayList<WorkflowNodePart>();
        for (Object o : this.getViewer().getRootEditPart().getChildren()) {
            if (!(o instanceof WorkflowPart)) continue;
            WorkflowPart wfPart = (WorkflowPart)o;
            for (Object part : wfPart.getChildren()) {
                if (!(part instanceof WorkflowNodePart)) continue;
                parts.add((WorkflowNodePart)part);
            }
        }
        return parts;
    }

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 4);
        container.setLayout((Layout)new GridLayout(1, true));
        CLabel pageTitle = new CLabel(container, 0);
        pageTitle.setLayoutData((Object)new GridData(768));
        pageTitle.setText(TITLE);
        pageTitle.setMargins(4, 3, 4, 3);
        pageTitle.setBackground(ColorManager.getInstance().getSharedColor((ColorSource)StandardColors.RCE_LIGHT_GREY));
        this.messageComposite = new CLabel(container, 0);
        this.messageComposite.setLayoutData((Object)new GridData(768));
        this.messageComposite.setText(DEFAULT_MESSAGE);
        this.messageComposite.setBackground(ColorManager.getInstance().getSharedColor((ColorSource)StandardColors.RCE_WHITE));
        this.editorArea = new Composite(container, 2048);
        this.editorArea.setLayout((Layout)new GridLayout());
        this.editorArea.setLayoutData((Object)new GridData(1808));
        super.createPartControl(this.editorArea);
        this.editorArea.setFocus();
        this.getViewer().getControl().setLayoutData((Object)new GridData(1808));
        this.buttonBar = new IntegrationEditorButtonBar(container, (IntegrationEditor)this.integrationEditor);
    }

    private void setMessage(Optional<String> message) {
        if (!message.isPresent()) {
            this.messageComposite.setText(DEFAULT_MESSAGE);
            this.messageComposite.setImage(null);
            this.integrationEditor.setWorkflowEditorPageImage(null);
        } else {
            this.messageComposite.setText(message.get());
            this.messageComposite.setImage(VALIDATION_ERROR_IMAGE);
            this.integrationEditor.setWorkflowEditorPageImage(VALIDATION_ERROR_IMAGE);
        }
    }

    public void setFocus() {
        this.editorArea.setFocus();
    }

    public void setSaveButtonEnabled(boolean enable) {
        this.buttonBar.setSaveButtonEnabled(enable);
    }

    public void mouseDoubleClick(MouseEvent ev) {
        ConnectionPart connectionPart = this.selectConnection(ev);
        if (connectionPart != null) {
            WorkflowNode source = null;
            WorkflowNode target = null;
            if (connectionPart.getSource().getModel() instanceof WorkflowNode) {
                source = (WorkflowNode)connectionPart.getSource().getModel();
            }
            if (connectionPart.getTarget().getModel() instanceof WorkflowNode) {
                target = (WorkflowNode)connectionPart.getTarget().getModel();
            }
            WIOpenConnectionEditorHandler openConnectionEditorHandler = new WIOpenConnectionEditorHandler(source, target);
            try {
                openConnectionEditorHandler.execute(new ExecutionEvent());
            }
            catch (ExecutionException e1) {
                e1.printStackTrace();
            }
        } else {
            this.switchComponentActivation();
        }
    }

    public String getContributorId() {
        return "de.rcenvironment.rce.gui.integration.workflowintegration.WorkflowEditorPage";
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            return new OutlineView(this.getGraphicalViewer());
        }
        if (type == IPropertySheetPage.class) {
            if (this.tabbedPropertySheetPage == null || this.tabbedPropertySheetPage.getControl() == null || this.tabbedPropertySheetPage.getControl().isDisposed()) {
                this.tabbedPropertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
            }
            return this.tabbedPropertySheetPage;
        }
        if (type == IContextProvider.class) {
            return new IContextProvider(){

                public String getSearchExpression(Object arg0) {
                    return null;
                }

                public int getContextChangeMask() {
                    return 0;
                }

                public IContext getContext(Object arg0) {
                    return HelpSystem.getContext((String)WorkflowEditorPage.HELP_CONTEXT_ID);
                }
            };
        }
        if (type == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        return super.getAdapter(type);
    }

    protected void initializeGraphicalViewer() {
        this.setViewer(this.getGraphicalViewer());
        WorkflowScalableFreeformRootEditPart rootEditPart = new WorkflowScalableFreeformRootEditPart();
        this.getViewer().setRootEditPart((RootEditPart)rootEditPart);
        this.getViewer().setEditPartFactory((EditPartFactory)new ReadOnlyWorkflowEditorEditPartFactory());
        this.getCommandStack().setUndoLimit(10);
        this.getCommandStack().addCommandStackEventListener(event -> {
            if (event.getCommand().getClass().equals(WorkflowNodeDisEnableCommand.class)) {
                this.validateComponents();
            }
        });
        this.getViewer().setContents((Object)this.workflowDescription);
        WorkflowEditorContextMenuProvider cmProvider = new WorkflowEditorContextMenuProvider((EditPartViewer)this.getViewer(), this.getActionRegistry());
        this.getViewer().setContextMenu((MenuManager)cmProvider);
        this.getSite().registerContextMenu((MenuManager)cmProvider, (ISelectionProvider)this.getViewer());
        WorkflowZoomManager zoomManager = (WorkflowZoomManager)rootEditPart.getZoomManager();
        this.getActionRegistry().registerAction((IAction)new ZoomInAction((ZoomManager)zoomManager));
        this.getActionRegistry().registerAction((IAction)new ZoomOutAction((ZoomManager)zoomManager));
        this.getViewer().setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        this.getViewer().addSelectionChangedListener(selectionChangedEvent -> {
            StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
            for (Object structuredSelectionObject : structuredSelection.toList()) {
                if (!(structuredSelectionObject instanceof ConnectionPart)) continue;
                ConnectionPart connectionPart = (ConnectionPart)structuredSelectionObject;
                if (!this.getViewer().getSelectedEditParts().contains(connectionPart)) continue;
                connectionPart.getConnectionFigure().setForegroundColor(ColorConstants.blue);
                connectionPart.showLabel();
            }
            this.removeConnectionColorsAndLabel();
        });
        int[] eventTypes = new int[]{8, 29};
        WorkflowEditorPage.removeListeners((Widget)this.getViewer().getControl(), eventTypes);
        this.getViewer().getControl().addMouseListener((MouseListener)this);
        this.getGraphicalViewer().getControl().setBackground(Display.getDefault().getSystemColor(15));
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext(WORKFLOWINTEGRATION_EDITOR_SCOPE);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.getResourceListener());
    }

    public static void removeListeners(Widget ctrl, int[] eventTypes) {
        int[] nArray = eventTypes;
        int n = eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Listener[] listeners;
            int eventType = nArray[n2];
            Listener[] listenerArray = listeners = ctrl.getListeners(eventType);
            int n3 = listeners.length;
            int n4 = 0;
            while (n4 < n3) {
                Listener listener = listenerArray[n4];
                ctrl.removeListener(eventType, listener);
                ++n4;
            }
            ++n2;
        }
    }

    private void switchComponentActivation() {
        List selectedParts = this.getViewer().getSelectedEditParts();
        if (selectedParts.isEmpty() || selectedParts.size() > 1) {
            return;
        }
        if (selectedParts.iterator().hasNext() && selectedParts.iterator().next() instanceof WorkflowNodePart) {
            try {
                new WIWorkflowNodeDisEnableHandler().execute(new ExecutionEvent());
            }
            catch (ExecutionException executionException) {}
        }
    }

    public void setBackButtonEnabled(boolean enable) {
        this.buttonBar.setBackButtonEnabled(enable);
    }

    public void setNextButtonEnabled(boolean enable) {
        this.buttonBar.setNextButtonEnabled(enable);
    }

    public boolean hasChanges() {
        return this.isDirty();
    }
}

