/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.workflowintegration.editor;

import de.rcenvironment.core.gui.integration.common.editor.IntegrationEditor;
import de.rcenvironment.core.gui.integration.common.editor.IntegrationEditorPage;
import de.rcenvironment.core.gui.integration.workflowintegration.WorkflowIntegrationController;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.WorkflowIntegrationEditorInput;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.pages.ComponentDescriptionPage;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.pages.MappingPage;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.pages.MappingTreeContentProvider;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.pages.WorkflowEditorPage;
import de.rcenvironment.core.utils.common.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class WorkflowIntegrationEditor
extends IntegrationEditor
implements IPartListener {
    private static final String DIALOG_TITLE = "Workflow Integration";
    private static final String BUTTON_UPDATE = "Update Integration";
    private static final String BUTTON_INTEGRATE = "Integrate Workflow";
    private static final Log LOG = LogFactory.getLog(WorkflowIntegrationEditor.class);
    private static final String COMPONENT_DESCRIPTION = "Component Description";
    private static final String WORKFLOW_EDITOR = "Integrated Workflow";
    private static final String MAPPING = "Mapping";
    private WorkflowIntegrationController workflowIntegrationController;
    private CTabFolder container;
    private WorkflowEditorPage workflowEditorPage;
    private MappingTreeContentProvider mappingTreeContentProvider;
    private int workflowEditorPageIndex;
    private IAction undoAction;
    private IAction redoAction;

    public WorkflowIntegrationEditor() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener)this);
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.updateContent();
        this.updateActions();
    }

    private void updateActions() {
        boolean enable = this.getSelectedPage() instanceof WorkflowEditorPage && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart() == this;
        IToolBarManager toolBarManager = this.getEditorSite().getActionBars().getToolBarManager();
        toolBarManager.find("org.eclipse.gef.zoom_in").setVisible(enable);
        toolBarManager.find("org.eclipse.gef.zoom_out").setVisible(enable);
        toolBarManager.find("org.eclipse.gef.zoom_widget").setVisible(enable);
        if (this.undoAction != null && this.redoAction != null) {
            if (enable) {
                toolBarManager.add(this.undoAction);
                toolBarManager.add(this.redoAction);
                this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undoAction);
                this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), this.redoAction);
                this.getEditorSite().getActionBarContributor().setActiveEditor((IEditorPart)this.workflowEditorPage);
            } else {
                toolBarManager.remove(toolBarManager.find(this.undoAction.getId()));
                toolBarManager.remove(toolBarManager.find(this.redoAction.getId()));
                this.getEditorSite().getActionBars().clearGlobalActionHandlers();
            }
        }
        this.getEditorSite().getActionBars().updateActionBars();
        toolBarManager.update(true);
    }

    protected void createPages() {
        this.container = (CTabFolder)this.getContainer();
        this.container.setBackground(this.container.getDisplay().getSystemColor(1));
        this.container.setVisible(false);
        try {
            this.createComponentDescriptionPage();
            this.createWorkflowEditorPage();
            this.createMappingPage();
        }
        catch (PartInitException e) {
            LOG.warn((Object)StringUtils.format((String)"Error opening the workflow integration editor.\n%s", (Object[])new Object[]{e.getMessage()}));
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"Error opening editor", (String)("Could not open the editor.\n" + e.getMessage()));
        }
        this.container.setVisible(true);
    }

    private void createComponentDescriptionPage() {
        ComponentDescriptionPage componentDescriptionPage = new ComponentDescriptionPage(this, this.container);
        componentDescriptionPage.setText(COMPONENT_DESCRIPTION);
        componentDescriptionPage.setControl((Control)componentDescriptionPage.generatePage());
    }

    private void createWorkflowEditorPage() throws PartInitException {
        this.workflowEditorPage = new WorkflowEditorPage(this);
        this.workflowEditorPageIndex = this.addPage((IEditorPart)this.workflowEditorPage, this.getEditorInput());
        this.setPageText(this.workflowEditorPageIndex, WORKFLOW_EDITOR);
        ActionRegistry registry = (ActionRegistry)this.workflowEditorPage.getAdapter(ActionRegistry.class);
        this.undoAction = registry.getAction((Object)ActionFactory.UNDO.getId());
        this.redoAction = registry.getAction((Object)ActionFactory.REDO.getId());
    }

    private void createMappingPage() {
        this.mappingTreeContentProvider = new MappingTreeContentProvider();
        MappingPage mappingPage = new MappingPage(this, this.container, this.mappingTreeContentProvider);
        mappingPage.setText(MAPPING);
        mappingPage.setControl((Control)mappingPage.generatePage());
        mappingPage.update();
        if (this.isEditMode()) {
            this.mappingTreeContentProvider.restoreCheckedMappingNodes(this.getController().getPersistedEndpointAdapters());
            mappingPage.refreshTree();
        }
    }

    public void integrate() {
        this.getController().createEndpointAdapters(this.mappingTreeContentProvider.getEndpointAdapters());
        if (this.getController().integrateWorkflow()) {
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
        } else {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error integrating component.", (String)"The integration of the workflow was not successfull. Please see the the log for more details.");
        }
    }

    public boolean isEditMode() {
        return this.getController().isEditMode();
    }

    public WorkflowIntegrationController getController() {
        return this.workflowIntegrationController;
    }

    public WorkflowEditorPage getWorkflowEditor() {
        return this.workflowEditorPage;
    }

    public void setWorkflowEditorPageImage(Image image) {
        this.setPageImage(this.workflowEditorPageIndex, image);
    }

    protected void setInput(IEditorInput input) throws IllegalArgumentException {
        if (input instanceof WorkflowIntegrationEditorInput) {
            this.workflowIntegrationController = (WorkflowIntegrationController)((Object)input.getAdapter(WorkflowIntegrationController.class));
            this.getController().setValue("isActive", true, WorkflowIntegrationController.ConfigurationContext.COMMON_SETTINGS);
        }
        this.setPartName(input.getName());
        super.setInput(input);
    }

    public void updatePartName() {
        this.setPartName(this.workflowIntegrationController.getEditorTitle());
    }

    public void dispose() {
        if (this.getWorkflowEditor() != null) {
            this.getWorkflowEditor().dispose();
        }
        IToolBarManager toolBarManager = this.getEditorSite().getActionBars().getToolBarManager();
        toolBarManager.remove(toolBarManager.find(this.undoAction.getId()));
        toolBarManager.remove(toolBarManager.find(this.redoAction.getId()));
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().removePartListener((IPartListener)this);
        super.dispose();
    }

    public void updateContent() {
        CTabItem selection = ((CTabFolder)this.getContainer()).getSelection();
        if (selection instanceof IntegrationEditorPage) {
            ((IntegrationEditorPage)selection).update();
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IContentOutlinePage.class || adapter == ZoomManager.class || adapter == ActionRegistry.class || adapter == IPropertySheetPage.class) {
            return (T)this.getWorkflowEditor().getAdapter(adapter);
        }
        return (T)super.getAdapter(adapter);
    }

    public void partActivated(IWorkbenchPart part) {
        if (part == this) {
            this.updateActions();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (part == this) {
            this.updateActions();
        }
    }

    public void partBroughtToTop(IWorkbenchPart arg0) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart arg0) {
    }

    public void doSave(IProgressMonitor arg0) {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().bringToTop((IWorkbenchPart)this);
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)"Unable to save for Workflow Integration Editor tabs.", (String)StringUtils.format((String)"The Workflow Integration configuration of editor tab '%s' cannot be saved to a file.\nIn order to persist a Workflow Integration configuration, please use the button '%s' in the Workflow Integration Editor.", (Object[])new Object[]{this.getTitle(), this.getButtonTextIntegrate()}));
    }

    public String getButtonTextIntegrate() {
        if (this.isEditMode()) {
            return BUTTON_UPDATE;
        }
        return BUTTON_INTEGRATE;
    }

    public String getDialogTitle() {
        return DIALOG_TITLE;
    }
}

