/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamodel.api;

import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.BigTableTD;
import de.rcenvironment.core.datamodel.types.api.BooleanTD;
import de.rcenvironment.core.datamodel.types.api.DateTimeTD;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.EmptyTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.IntegerTD;
import de.rcenvironment.core.datamodel.types.api.InternalTD;
import de.rcenvironment.core.datamodel.types.api.MatrixTD;
import de.rcenvironment.core.datamodel.types.api.NotAValueTD;
import de.rcenvironment.core.datamodel.types.api.ShortTextTD;
import de.rcenvironment.core.datamodel.types.api.SmallTableTD;
import de.rcenvironment.core.datamodel.types.api.StructuredDataTD;
import de.rcenvironment.core.datamodel.types.api.VectorTD;
import de.rcenvironment.core.utils.common.StringUtils;

public enum DataType {
    ShortText("Short Text", "STxt", ShortTextTD.class),
    Boolean("Boolean", "Bool", BooleanTD.class),
    Integer("Integer", "Int", IntegerTD.class),
    Float("Float", "Flt", FloatTD.class),
    Vector("Vector", "Vctr", VectorTD.class),
    Matrix("Matrix", "Mtrx", MatrixTD.class),
    SmallTable("Small Table", "SmlT", SmallTableTD.class),
    DateTime("Date/Time", "Date", DateTimeTD.class),
    FileReference("File", "File", FileReferenceTD.class),
    DirectoryReference("Directory", "Dir", DirectoryReferenceTD.class),
    Empty("Empty", "Epty", EmptyTD.class),
    BigTable("Big Table", "BigT", BigTableTD.class),
    StructuredData("Structured Data", "SDat", StructuredDataTD.class),
    NotAValue("Not-a-value", "Ind", NotAValueTD.class),
    Internal("Internal", "Intern", InternalTD.class);

    private String displayName;
    private String shortName;
    private Class<? extends TypedDatum> tdClass;

    private DataType(String displayName, String shortName, Class<? extends TypedDatum> tdClass) {
        this.displayName = displayName;
        this.shortName = shortName;
        this.tdClass = tdClass;
    }

    public Class<? extends TypedDatum> getTDClass() {
        return this.tdClass;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public boolean isValidCellType() {
        return this == Boolean || this == Integer || this == Float || this == DateTime || this == ShortText;
    }

    public static DataType byTDClass(Class<? extends TypedDatum> inputClass) {
        DataType[] dataTypeArray = DataType.values();
        int n = dataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType type = dataTypeArray[n2];
            if (type.tdClass == inputClass) {
                return type;
            }
            ++n2;
        }
        throw new IllegalArgumentException("No match for class " + inputClass);
    }

    public static DataType byShortName(String shortName) {
        DataType[] dataTypeArray = DataType.values();
        int n = dataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType type = dataTypeArray[n2];
            if (shortName.equals(type.getShortName())) {
                return type;
            }
            ++n2;
        }
        throw new IllegalArgumentException(StringUtils.format((String)"No matching data type for given short name found: '%s'", (Object[])new Object[]{shortName}));
    }

    public static DataType byDisplayName(String displayName) {
        DataType[] dataTypeArray = DataType.values();
        int n = dataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType type = dataTypeArray[n2];
            if (displayName.equals(type.getDisplayName())) {
                return type;
            }
            ++n2;
        }
        throw new IllegalArgumentException("No match for classname " + displayName);
    }

    public String toString() {
        return this.displayName;
    }
}

