/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.toolintegration.cpacs;

import de.rcenvironment.core.gui.integration.toolintegration.cpacs.Messages;
import de.rcenvironment.core.gui.utils.common.components.PropertyTabGuiHelper;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RelativeXMLFilePathChooserButtonListener
implements SelectionListener {
    private Text linkedTextfield;
    private Shell shell;
    private Map<String, Object> configurationMap;
    private String title;

    public RelativeXMLFilePathChooserButtonListener(String title, Text linkedTextfield, Shell shell, Map<String, Object> configurationMap) {
        this.title = title;
        this.linkedTextfield = linkedTextfield;
        this.shell = shell;
        this.configurationMap = configurationMap;
    }

    public void widgetSelected(SelectionEvent arg0) {
        List launchConfigs = (List)this.configurationMap.get("launchSettings");
        String toolDirectory = (String)((Map)launchConfigs.iterator().next()).get("toolDirectory");
        String selectedPath = PropertyTabGuiHelper.selectFileFromFileSystem((Shell)this.shell, (String[])new String[]{"*.xml;*.xsl", "*.xml", "*.xsl"}, (String)this.title, (String)toolDirectory);
        if (selectedPath != null) {
            File selectedFile = new File(selectedPath.replace(String.valueOf(toolDirectory) + File.separator, ""));
            if (!selectedFile.isAbsolute()) {
                this.linkedTextfield.setText(selectedFile.getPath());
            } else {
                MessageDialog.openError((Shell)this.shell, (String)Messages.fileNotRelativeTitle, (String)Messages.fileNotRelativeText);
                this.linkedTextfield.setText("");
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
        this.widgetSelected(arg0);
    }

    public void updateConfiguration(Map<String, Object> newConfigurationMap) {
        this.configurationMap = newConfigurationMap;
    }
}

