/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.console;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.management.WorkflowHostSetListener;
import de.rcenvironment.core.component.workflow.execution.api.ConsoleModelSnapshot;
import de.rcenvironment.core.component.workflow.execution.api.ConsoleRowFilter;
import de.rcenvironment.core.component.workflow.execution.api.ConsoleRowModelService;
import de.rcenvironment.core.gui.resources.api.FontManager;
import de.rcenvironment.core.gui.resources.api.FontSource;
import de.rcenvironment.core.gui.resources.api.StandardFonts;
import de.rcenvironment.core.gui.utils.incubator.TableColumnMinimalWidthControlListener;
import de.rcenvironment.core.gui.workflow.Activator;
import de.rcenvironment.core.gui.workflow.parts.WorkflowRunNodePart;
import de.rcenvironment.core.gui.workflow.view.console.ConsoleColumnSorter;
import de.rcenvironment.core.gui.workflow.view.console.ConsoleContentProvider;
import de.rcenvironment.core.gui.workflow.view.console.ConsoleLabelProvider;
import de.rcenvironment.core.gui.workflow.view.console.CopyToClipboardHelper;
import de.rcenvironment.core.gui.workflow.view.console.CopyToClipboardListener;
import de.rcenvironment.core.gui.workflow.view.console.DecoratedConsoleLabelProvider;
import de.rcenvironment.core.gui.workflow.view.console.Messages;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ConsoleView
extends ViewPart {
    public static final String ID = "de.rcenvironment.gui.WorkflowComponentConsole";
    private static final int COMBO_NO_SELECTION = -1;
    private static ConsoleView instance;
    private static final boolean STDERR_PRESELECTED = true;
    private static final boolean STDOUT_PRESELECTED = true;
    private static final boolean COMP_LOG_PRESELECTED = true;
    private static final int COLUMN_WIDTH_TYPE = 70;
    private static final int COLUMN_WIDTH_TIME = 150;
    private static final int COLUMN_WIDTH_STD = 500;
    private static final int COLUMN_WIDTH_COMPONENT = 100;
    private static final int COLUMN_WIDTH_WORKFLOW = 400;
    private static final int INITIAL_SELECTION = 0;
    private static final int NO_SPACE = 0;
    private static final int WORKFLOW_WIDTH = 250;
    private static final int COMPONENT_WIDTH = 250;
    private static final int TEXT_WIDTH = 250;
    private static final long MODEL_QUERY_MIN_INTERVAL = 500L;
    private Button checkboxStderr;
    private Button checkboxStdout;
    private Button checkboxMetaInfo;
    private Combo workflowCombo;
    private Combo componentCombo;
    private TableViewer consoleRowTableViewer;
    private ConsoleColumnSorter consoleColumnSorter;
    private Text searchTextField;
    private int lastKnownSequenceId = 0;
    private final Timer modelQueryTimer = new Timer();
    private final ConsoleRowModelService consoleModel;
    private final ConsoleRowFilter rowFilter = new ConsoleRowFilter();
    private volatile boolean scrollLock = false;
    private Button deleteSearchButton;
    private Display display;
    private ServiceRegistryPublisherAccess serviceRegistryAccess;
    private MenuItem copyLineItem;
    private MenuItem copyMessageItem;
    private Map<String, Collection<String>> componentMap;

    public ConsoleView() {
        instance = this;
        this.serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)((Object)this));
        this.consoleModel = (ConsoleRowModelService)this.serviceRegistryAccess.getService(ConsoleRowModelService.class);
        this.modelQueryTimer.schedule((TimerTask)new QueryModelForChangesTask(), 500L, 500L);
    }

    public static ConsoleView getInstance() {
        return instance;
    }

    private void updateComponentCombo(String selectedWorkflow) {
        String oldSelection = this.getComponentSelection();
        String[] newList = this.convertToDisplayArray(this.getComponentList(selectedWorkflow), "Components");
        this.componentCombo.setItems(newList);
        this.componentCombo.select(0);
        int i = 1;
        while (i < newList.length) {
            if (newList[i].equals(oldSelection)) {
                this.componentCombo.select(i);
                break;
            }
            ++i;
        }
    }

    public Collection<String> getComponentList(String selectedWorkflow) {
        if (this.componentMap == null) {
            return new ArrayList<String>();
        }
        if (selectedWorkflow != null) {
            if (this.componentMap.containsKey(selectedWorkflow)) {
                List<String> list = this.componentMap.get(selectedWorkflow).stream().collect(Collectors.toList());
                Collections.sort(list);
                return list;
            }
            return new ArrayList<String>();
        }
        List<String> list = this.componentMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()).stream().collect(Collectors.toList());
        Collections.sort(list);
        return list;
    }

    private String[] convertToDisplayArray(Collection<String> input, String firstEntry) {
        String[] result = new String[input.size() + 1];
        result[0] = StringUtils.format((String)"[All %s]", (Object[])new Object[]{firstEntry});
        int i = 1;
        Iterator<String> iterator = input.iterator();
        while (iterator.hasNext()) {
            String wf;
            result[i] = wf = iterator.next();
            ++i;
        }
        return result;
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getShell().getDisplay();
        parent.setLayout((Layout)new GridLayout(3, false));
        this.createWorkflowListingArrangement(parent);
        this.createComponentListingArrangement(parent);
        this.createSearchArrangement(parent);
        this.createLevelArrangement(parent);
        this.createTableArrangement(parent);
        this.consoleRowTableViewer.getTable().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                ConsoleView.this.copyLineItem.setEnabled(!ConsoleView.this.consoleRowTableViewer.getSelection().isEmpty());
                ConsoleView.this.copyMessageItem.setEnabled(!ConsoleView.this.consoleRowTableViewer.getSelection().isEmpty());
            }
        });
        this.searchTextField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent arg0) {
                ConsoleView.this.rowFilter.setSearchTerm(ConsoleView.this.searchTextField.getText());
                ConsoleView.this.applyNewRowFilter(true);
                ConsoleView.this.deleteSearchButton.setEnabled(!ConsoleView.this.searchTextField.getText().equals(""));
            }
        });
        SelectionListener changeListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ConsoleView.this.rowFilter.setIncludeMetaInfo(ConsoleView.this.checkboxMetaInfo.getSelection());
                ConsoleView.this.rowFilter.setIncludeLifecylceEvents(ConsoleView.this.checkboxMetaInfo.getSelection());
                ConsoleView.this.rowFilter.setIncludeStdout(ConsoleView.this.checkboxStdout.getSelection());
                ConsoleView.this.rowFilter.setIncludeStderr(ConsoleView.this.checkboxStderr.getSelection());
                ConsoleView.this.rowFilter.setWorkflow(ConsoleView.this.getWorkflowSelection());
                ConsoleView.this.rowFilter.setComponent(ConsoleView.this.getComponentSelection());
                ConsoleView.this.applyNewRowFilter(true);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        };
        this.deleteSearchButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ConsoleView.this.searchTextField.setText("");
                ConsoleView.this.rowFilter.setSearchTerm("");
                ConsoleView.this.applyNewRowFilter(true);
                if (ConsoleView.this.searchTextField.getText().equals("")) {
                    ConsoleView.this.deleteSearchButton.setEnabled(false);
                } else {
                    ConsoleView.this.deleteSearchButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.checkboxStderr.addSelectionListener(changeListener);
        this.checkboxStdout.addSelectionListener(changeListener);
        this.checkboxMetaInfo.addSelectionListener(changeListener);
        this.componentCombo.addSelectionListener(changeListener);
        this.workflowCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ConsoleView.this.rowFilter.setWorkflow(ConsoleView.this.getWorkflowSelection());
                ConsoleView.this.updateComponentCombo(ConsoleView.this.getWorkflowSelection());
                ConsoleView.this.rowFilter.setComponent(ConsoleView.this.getComponentSelection());
                ConsoleView.this.applyNewRowFilter(true);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.consoleColumnSorter = new ConsoleColumnSorter();
        this.consoleRowTableViewer.setSorter((ViewerSorter)this.consoleColumnSorter);
        Action[] actionArray = this.createToolbarActions();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            this.getViewSite().getActionBars().getToolBarManager().add((IAction)action);
            ++n2;
        }
        this.applyNewRowFilter(true);
        this.registerWorkflowHostSetListener();
        this.addHotkeysToTable(this.consoleRowTableViewer);
    }

    private void registerWorkflowHostSetListener() {
        this.serviceRegistryAccess.registerService(WorkflowHostSetListener.class, (Object)new WorkflowHostSetListener(){

            public void onReachableWorkflowHostsChanged(Set<InstanceNodeSessionId> reachableWfHosts, Set<InstanceNodeSessionId> addedWfHosts, Set<InstanceNodeSessionId> removedWfHosts) {
                ConsoleView.this.consoleModel.updateSubscriptions();
                ConsoleView.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).ConsoleView.this.consoleRowTableViewer.getTable().isDisposed()) {
                            (this).ConsoleView.this.consoleRowTableViewer.refresh();
                        }
                    }
                });
            }
        });
    }

    private void applyNewRowFilter(boolean triggerUpdate) {
        this.consoleModel.setRowFilter(this.rowFilter);
        if (triggerUpdate) {
            this.triggerImmediateUpdate();
        }
        this.consoleRowTableViewer.setSelection((ISelection)new StructuredSelection());
    }

    private void triggerImmediateUpdate() {
        this.modelQueryTimer.schedule((TimerTask)new QueryModelForChangesTask(), 0L);
    }

    public void dispose() {
        this.modelQueryTimer.cancel();
        super.dispose();
        if (this.serviceRegistryAccess != null) {
            this.serviceRegistryAccess.dispose();
        }
    }

    private String getWorkflowSelection() {
        if (this.workflowCombo.getSelectionIndex() != -1 && this.workflowCombo.getSelectionIndex() != 0) {
            return this.workflowCombo.getItem(this.workflowCombo.getSelectionIndex());
        }
        return null;
    }

    private String getComponentSelection() {
        if (this.componentCombo.getSelectionIndex() != -1 && this.componentCombo.getSelectionIndex() != 0) {
            return this.componentCombo.getItem(this.componentCombo.getSelectionIndex());
        }
        return null;
    }

    public void setFocus() {
        this.consoleRowTableViewer.getControl().setFocus();
    }

    private void syncApplySnapshot(ConsoleModelSnapshot snapshot) {
        if (this.consoleRowTableViewer != null && !this.consoleRowTableViewer.getTable().isDisposed()) {
            this.consoleRowTableViewer.getTable().getDisplay().syncExec((Runnable)new ApplySnapshotRunnable(snapshot));
        }
    }

    private void createLevelArrangement(Composite parentComposite) {
        Composite filterComposite = new Composite(parentComposite, 0);
        filterComposite.setLayout((Layout)new GridLayout(4, false));
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 3;
        filterComposite.setLayoutData((Object)gd);
        Label label = new Label(filterComposite, 0);
        label.setText("Message Types: ");
        this.checkboxMetaInfo = new Button(filterComposite, 32);
        this.checkboxMetaInfo.setText(Messages.compLog);
        this.checkboxMetaInfo.setSelection(true);
        this.checkboxStdout = new Button(filterComposite, 32);
        this.checkboxStdout.setText(Messages.stdout);
        this.checkboxStdout.setSelection(true);
        this.checkboxStderr = new Button(filterComposite, 32);
        this.checkboxStderr.setText(Messages.stderr);
        this.checkboxStderr.setSelection(true);
    }

    private void createWorkflowListingArrangement(Composite parentComposite) {
        Composite workflowComposite = new Composite(parentComposite, 0);
        workflowComposite.setLayout((Layout)new GridLayout());
        this.workflowCombo = new Combo(workflowComposite, 12);
        this.workflowCombo.select(0);
        GridData gd = new GridData();
        gd.widthHint = 250;
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        this.workflowCombo.setLayoutData((Object)gd);
    }

    private void createComponentListingArrangement(Composite parentComposite) {
        Composite componentComposite = new Composite(parentComposite, 0);
        componentComposite.setLayout((Layout)new GridLayout());
        this.componentCombo = new Combo(componentComposite, 12);
        this.componentCombo.select(0);
        GridData gd = new GridData();
        gd.widthHint = 250;
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        this.componentCombo.setLayoutData((Object)gd);
    }

    private void createSearchArrangement(Composite parentComposite) {
        Composite searchComposite = new Composite(parentComposite, 0);
        searchComposite.setLayout((Layout)new GridLayout(2, false));
        this.searchTextField = new Text(searchComposite, 128);
        this.searchTextField.setMessage(Messages.search);
        GridData gd = new GridData(4, 4, false, false);
        gd.widthHint = 250;
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        this.searchTextField.setLayoutData((Object)gd);
        this.searchTextField.setSize(250, -1);
        this.deleteSearchButton = new Button(searchComposite, 524288);
        this.deleteSearchButton.setText(Messages.resetSearch);
        if (this.searchTextField.getText().equals("")) {
            this.deleteSearchButton.setEnabled(false);
        }
    }

    private void createTableArrangement(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        tableComposite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        tableComposite.setLayoutData((Object)gd);
        this.consoleRowTableViewer = new TableViewer(tableComposite, 268501762);
        String[] titles = new String[]{Messages.type, Messages.timestamp, Messages.message, Messages.component, Messages.workflow};
        int[] bounds = new int[]{70, 150, 500, 100, 400};
        int i = 0;
        while (i < bounds.length) {
            final int index = i;
            TableViewerColumn viewerColumn = new TableViewerColumn(this.consoleRowTableViewer, 0);
            final TableColumn column = viewerColumn.getColumn();
            column.setText(titles[i]);
            column.setWidth(bounds[i]);
            column.setResizable(true);
            column.setMoveable(true);
            column.addControlListener((ControlListener)new TableColumnMinimalWidthControlListener());
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConsoleView.this.consoleColumnSorter.setColumn(index);
                    int direction = ConsoleView.this.consoleRowTableViewer.getTable().getSortDirection();
                    direction = ConsoleView.this.consoleRowTableViewer.getTable().getSortColumn() == column ? (direction == 128 ? 1024 : 128) : 128;
                    ConsoleView.this.consoleRowTableViewer.getTable().setSortDirection(direction);
                    ConsoleView.this.consoleRowTableViewer.getTable().setSortColumn(column);
                    ConsoleView.this.consoleRowTableViewer.refresh();
                }
            });
            ++i;
        }
        this.consoleRowTableViewer.setContentProvider((IContentProvider)new ConsoleContentProvider());
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.consoleRowTableViewer.setLabelProvider((IBaseLabelProvider)new DecoratedConsoleLabelProvider((ILabelProvider)new ConsoleLabelProvider(), decorator));
        Table table = this.consoleRowTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setFont(FontManager.getInstance().getFont((FontSource)StandardFonts.CONSOLE_TEXT_FONT));
        table.setForeground(parent.getDisplay().getSystemColor(2));
        Menu contextMenu = new Menu((Control)parent);
        this.copyLineItem = new MenuItem(contextMenu, 8);
        this.copyMessageItem = new MenuItem(contextMenu, 8);
        this.copyMessageItem.setText(String.valueOf(Messages.copyMessage) + "\tCtrl+Alt+C");
        this.copyMessageItem.setImage(Activator.getInstance().getImageRegistry().get("de.rcenvironment.rce.gui.copy"));
        this.copyMessageItem.addSelectionListener((SelectionListener)new CopyToClipboardListener(this.consoleRowTableViewer));
        this.copyLineItem.setText(String.valueOf(Messages.copyLine) + "\tCtrl+C");
        this.copyLineItem.setImage(Activator.getInstance().getImageRegistry().get("de.rcenvironment.rce.gui.copy"));
        this.copyLineItem.addSelectionListener((SelectionListener)new CopyToClipboardListener(this.consoleRowTableViewer));
        this.consoleRowTableViewer.getControl().setMenu(contextMenu);
    }

    private Action[] createToolbarActions() {
        Action scrollLockAction = new Action(Messages.scrollLock, 2){

            public void run() {
                ConsoleView.this.scrollLock = !ConsoleView.this.scrollLock;
            }
        };
        scrollLockAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)WorkflowRunNodePart.ComponentStateFigureImpl.class.getResource("/resources/icons/scrollLock.gif")));
        Action deleteAction = new Action(Messages.clear, ImageDescriptor.createFromImage((Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"))){

            public void run() {
                ConsoleView.this.consoleModel.clearAll();
            }
        };
        return new Action[]{scrollLockAction, deleteAction};
    }

    private void addHotkeysToTable(final TableViewer table) {
        table.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 97) {
                    table.getTable().selectAll();
                } else if (e.stateMask == 262144 && e.keyCode == 99 && ConsoleView.this.copyLineItem.isEnabled()) {
                    CopyToClipboardHelper helper = new CopyToClipboardHelper(table);
                    helper.copyToClipboard("CopyLine");
                } else if (e.stateMask == 327680 && e.keyCode == 99 && ConsoleView.this.copyLineItem.isEnabled()) {
                    CopyToClipboardHelper helper = new CopyToClipboardHelper(table);
                    helper.copyToClipboard("CopyMessage");
                }
            }
        });
    }

    private class ApplySnapshotRunnable
    implements Runnable {
        private ConsoleModelSnapshot snapshot;

        ApplySnapshotRunnable(ConsoleModelSnapshot snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        public void run() {
            if (ConsoleView.this.workflowCombo.isDisposed()) {
                return;
            }
            if (this.snapshot.isWorkflowListChanged()) {
                String oldSelection = ConsoleView.this.getWorkflowSelection();
                String[] newList = ConsoleView.this.convertToDisplayArray(this.snapshot.getWorkflowList(), "Workflows");
                ConsoleView.this.workflowCombo.setItems(newList);
                ConsoleView.this.workflowCombo.select(0);
                int i = 1;
                while (i < newList.length) {
                    if (newList[i].equals(oldSelection)) {
                        ConsoleView.this.workflowCombo.select(i);
                        break;
                    }
                    ++i;
                }
            }
            if (this.snapshot.hasComponentListChanged()) {
                ConsoleView.this.componentMap = this.snapshot.getWorkflowComponentsMap();
                ConsoleView.this.updateComponentCombo(ConsoleView.this.getWorkflowSelection());
            }
            if (this.snapshot.hasFilteredRowListChanged()) {
                ConsoleView.this.consoleRowTableViewer.setInput((Object)this.snapshot.getFilteredRows());
                if (!ConsoleView.this.scrollLock) {
                    ConsoleView.this.consoleRowTableViewer.getTable().setTopIndex(this.snapshot.getFilteredRows().size());
                    ConsoleView.this.consoleRowTableViewer.getTable().getVerticalBar().setSelection(ConsoleView.this.consoleRowTableViewer.getTable().getVerticalBar().getMaximum() + this.snapshot.getFilteredRows().size());
                }
                ConsoleView.this.consoleRowTableViewer.refresh(true);
            }
        }
    }

    private class QueryModelForChangesTask
    extends TimerTask {
        private QueryModelForChangesTask() {
        }

        @Override
        public void run() {
            ConsoleModelSnapshot snapshot = ConsoleView.this.consoleModel.getSnapshotIfModifiedSince(ConsoleView.this.lastKnownSequenceId);
            if (snapshot == null) {
                return;
            }
            ConsoleView.this.lastKnownSequenceId = snapshot.getSequenceId();
            ConsoleView.this.syncApplySnapshot(snapshot);
        }
    }
}

