/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands.endpoint;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.util.Map;
import java.util.UUID;

public class AddDynamicOutputCommand
extends WorkflowNodeCommand {
    protected String endpointId;
    protected String name;
    protected DataType type;
    protected Map<String, String> metaData;
    protected String group;
    protected Refreshable[] refreshable;
    private boolean executable = true;
    private boolean undoable = false;

    public AddDynamicOutputCommand(String endpointId, String name, DataType type, Map<String, String> metaData, String group, Refreshable ... refreshable) {
        this.endpointId = endpointId;
        this.name = name;
        this.type = type;
        this.metaData = metaData;
        this.group = group;
        this.refreshable = refreshable;
    }

    public AddDynamicOutputCommand(String endpointId, String name, DataType type, Map<String, String> metaData, Refreshable ... refreshable) {
        this(endpointId, name, type, metaData, (String)null, refreshable);
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean canExecute() {
        return this.executable;
    }

    @Override
    public void execute() {
        if (this.executable) {
            EndpointDescriptionsManager outputManager = this.getProperties().getOutputDescriptionsManager();
            outputManager.addDynamicEndpointDescription(this.endpointId, this.name, this.type, this.metaData, UUID.randomUUID().toString(), this.group, true);
            this.executable = false;
            this.undoable = true;
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    @Override
    public boolean canUndo() {
        return this.undoable;
    }

    @Override
    public void undo() {
        if (this.undoable) {
            EndpointDescriptionsManager outputManager = this.getProperties().getOutputDescriptionsManager();
            outputManager.removeDynamicEndpointDescription(this.name);
            this.executable = true;
            this.undoable = false;
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }
}

