/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.export.matching;

import de.rcenvironment.core.datamanagement.export.matching.BooleanTDMatcher;
import de.rcenvironment.core.datamanagement.export.matching.DateTimeTDMatcher;
import de.rcenvironment.core.datamanagement.export.matching.DirectoryReferenceTDMatcher;
import de.rcenvironment.core.datamanagement.export.matching.FileReferenceTDMatcher;
import de.rcenvironment.core.datamanagement.export.matching.FloatTDMatcher;
import de.rcenvironment.core.datamanagement.export.matching.IntegerTDMatcher;
import de.rcenvironment.core.datamanagement.export.matching.MatchResult;
import de.rcenvironment.core.datamanagement.export.matching.Matcher;
import de.rcenvironment.core.datamanagement.export.matching.MatrixTDMatcher;
import de.rcenvironment.core.datamanagement.export.matching.NotAValueMatcher;
import de.rcenvironment.core.datamanagement.export.matching.ShortTextTDMatcher;
import de.rcenvironment.core.datamanagement.export.matching.VectorTDMatcher;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.SmallTableTD;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class SmallTableTDMatcher
implements Matcher<SmallTableTD> {
    private Map<DataType, Matcher> matchers = new HashMap<DataType, Matcher>();

    @Override
    public MatchResult matches(SmallTableTD actual, SmallTableTD expected) {
        MatchResult result = new MatchResult();
        int actualRow = actual.getRowCount();
        int actualColumn = actual.getColumnCount();
        int expectedRow = expected.getRowCount();
        int expectedColumn = expected.getColumnCount();
        if (actualRow != expectedRow || actualColumn != expectedColumn) {
            result.addFailureCause("The dimensions of the small tables are not the same.");
            return result;
        }
        this.initMatchers();
        int i = 0;
        while (i < actualRow) {
            int j = 0;
            while (j < actualColumn) {
                TypedDatum actualTD = actual.getTypedDatumOfCell(i, j);
                TypedDatum expectedTD = expected.getTypedDatumOfCell(i, j);
                if (!actualTD.getDataType().getClass().equals(expectedTD.getDataType().getClass())) {
                    result.addFailureCause(StringUtils.format((String)"The types in row %s and column %s are not the same.", (Object[])new Object[]{i, j}));
                    return result;
                }
                Matcher matcher = this.matchers.get(actualTD.getDataType());
                if (matcher == null) {
                    throw new IllegalArgumentException(StringUtils.format((String)"No matcher found for type %s", (Object[])new Object[]{actualTD.getDataType().toString()}));
                }
                MatchResult nestedMatchResult = matcher.matches(actualTD, expectedTD);
                if (!nestedMatchResult.hasMatched()) {
                    result.addFailureCause(StringUtils.format((String)"The values of type %s in row %s and column %s are not the same.", (Object[])new Object[]{actualTD.getDataType().toString(), i, j}));
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private void initMatchers() {
        if (this.matchers.isEmpty()) {
            this.matchers.put(DataType.Boolean, new BooleanTDMatcher());
            this.matchers.put(DataType.Integer, new IntegerTDMatcher());
            this.matchers.put(DataType.Float, new FloatTDMatcher());
            this.matchers.put(DataType.NotAValue, new NotAValueMatcher());
            this.matchers.put(DataType.ShortText, new ShortTextTDMatcher());
            this.matchers.put(DataType.DateTime, new DateTimeTDMatcher());
            this.matchers.put(DataType.DirectoryReference, new DirectoryReferenceTDMatcher());
            this.matchers.put(DataType.FileReference, new FileReferenceTDMatcher());
            this.matchers.put(DataType.Matrix, new MatrixTDMatcher());
            this.matchers.put(DataType.Vector, new VectorTDMatcher());
            this.matchers.put(DataType.SmallTable, new SmallTableTDMatcher());
        }
    }
}

