/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.export.matching;

import java.util.LinkedList;
import java.util.List;

public class MatchResult {
    private List<Cause> causes;

    public List<Cause> getCauses() {
        return this.causes;
    }

    public void addFailureCause(String cause) {
        if (this.causes == null) {
            this.causes = new LinkedList<Cause>();
        }
        this.causes.add(new Cause(cause));
    }

    public void addFailureCause(String cause, MatchResult nestedCause) {
        if (this.causes == null) {
            this.causes = new LinkedList<Cause>();
        }
        this.causes.add(new Cause(cause, nestedCause));
    }

    public boolean hasMatched() {
        return this.causes == null || this.causes.size() == 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.printOneLevelOfMatchResult(builder, "");
        return builder.toString();
    }

    private void printOneLevelOfMatchResult(StringBuilder builder, String indentation) {
        if (this.causes != null) {
            for (Cause cause : this.causes) {
                builder.append(String.valueOf(indentation) + cause.getCause() + System.lineSeparator());
                if (!cause.hasNestedCause()) continue;
                cause.getNestedCause().printOneLevelOfMatchResult(builder, String.valueOf(indentation) + "    ");
            }
        }
    }

    public final class Cause {
        private String cause;
        private MatchResult nestedCause;

        private Cause(String cause, MatchResult nestedCause) {
            this.cause = cause;
            this.nestedCause = nestedCause;
        }

        private Cause(String cause) {
            this(cause, null);
        }

        public String getCause() {
            return this.cause;
        }

        public MatchResult getNestedCause() {
            return this.nestedCause;
        }

        public boolean hasNestedCause() {
            return this.nestedCause != null;
        }
    }
}

