/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.datamanagement.browser;

import de.rcenvironment.core.gui.datamanagement.browser.DMBrowserImages;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNode;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeType;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DMLabelProvider
extends ColumnLabelProvider {
    public Image getImage(Object element) {
        ImageManager imageManager = ImageManager.getInstance();
        Image result = DMBrowserImages.IMG_DEFAULT;
        DMBrowserNode node = (DMBrowserNode)element;
        if (node.getType() == DMBrowserNodeType.Workflow && node.getIcon() == null) {
            result = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.WORKFLOW_16);
        } else if (node.getType() == DMBrowserNodeType.Workflow && node.getIcon() != null) {
            result = node.getIcon();
        } else if (node.getType() == DMBrowserNodeType.Workflow_Disabled) {
            result = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.WORKFLOW_DISABLED_16);
        } else if (node.getType() == DMBrowserNodeType.Timeline) {
            result = DMBrowserImages.IMG_TIMELINE;
        } else if (node.getType() == DMBrowserNodeType.Components) {
            result = DMBrowserImages.IMG_COMPONENTS;
        } else if ((node.getType() == DMBrowserNodeType.Component || node.getType() == DMBrowserNodeType.HistoryObject) && node.getIcon() != null) {
            result = node.getIcon();
        } else if (node.getType() == DMBrowserNodeType.DMDirectoryReference) {
            result = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.FOLDER_16);
        } else if (node.getType() == DMBrowserNodeType.DMFileResource) {
            result = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.FILE_16);
            if (node.getAssociatedFilename() != null && node.getAssociatedFilename().matches(".*\\.wf")) {
                result = imageManager.getSharedImage((ImageSource)StandardImages.WORKFLOW_16);
            }
        } else if (node.getType() == DMBrowserNodeType.InformationText) {
            result = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.INFORMATION_16);
        } else if (node.getType() == DMBrowserNodeType.ComponentHostInformation) {
            result = DMBrowserImages.IMG_COMPONENTS;
        } else if (node.getType() == DMBrowserNodeType.WarningText) {
            result = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.WARNING_16);
        } else if (node.getType() == DMBrowserNodeType.HistoryRoot) {
            result = DMBrowserImages.IMG_DEFAULT;
        } else if (node.getType() == DMBrowserNodeType.WorkflowRunInformation) {
            result = DMBrowserImages.IMG_WF_RUN_INFO;
        } else if (node.getType() == DMBrowserNodeType.Loading) {
            result = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.REFRESH_16);
        } else if (node.getType() == DMBrowserNodeType.ShortText) {
            result = imageManager.getSharedImage((ImageSource)StandardImages.DATATYPE_SHORTTEXT_16);
        } else if (node.getType() == DMBrowserNodeType.Boolean) {
            result = imageManager.getSharedImage((ImageSource)StandardImages.DATATYPE_BOOLEAN_16);
        } else if (node.getType() == DMBrowserNodeType.Integer) {
            result = imageManager.getSharedImage((ImageSource)StandardImages.DATATYPE_INTEGER_16);
        } else if (node.getType() == DMBrowserNodeType.Float) {
            result = imageManager.getSharedImage((ImageSource)StandardImages.DATATYPE_FLOAT_16);
        } else if (node.getType() == DMBrowserNodeType.Vector) {
            result = imageManager.getSharedImage((ImageSource)StandardImages.DATATYPE_VECTOR_16);
        } else if (node.getType() == DMBrowserNodeType.SmallTable) {
            result = imageManager.getSharedImage((ImageSource)StandardImages.DATATYPE_SMALLTABLE_16);
        } else if (node.getType() == DMBrowserNodeType.Indefinite) {
            result = imageManager.getSharedImage((ImageSource)StandardImages.DATATYPE_INDEFINITE_16);
        } else if (node.getType() == DMBrowserNodeType.File) {
            result = imageManager.getSharedImage((ImageSource)StandardImages.DATATYPE_FILE_16);
        } else if (node.getType() == DMBrowserNodeType.Directory) {
            result = imageManager.getSharedImage((ImageSource)StandardImages.DATATYPE_DIRECTORY_16);
        } else if (node.getType() == DMBrowserNodeType.Matrix) {
            result = imageManager.getSharedImage((ImageSource)StandardImages.DATATYPE_MATRIX_16);
        } else if (node.getType() == DMBrowserNodeType.Input) {
            result = imageManager.getSharedImage((ImageSource)StandardImages.INPUT_16);
        } else if (node.getType() == DMBrowserNodeType.Output) {
            result = imageManager.getSharedImage((ImageSource)StandardImages.OUTPUT_16);
        } else if (node.getType() == DMBrowserNodeType.LogFolder) {
            result = imageManager.getSharedImage((ImageSource)StandardImages.FILES_16);
        } else if (node.getType() == DMBrowserNodeType.ToolInputOutputFolder) {
            result = imageManager.getSharedImage((ImageSource)StandardImages.TOOL_INPUT_OUTPUT_16);
        } else if (node.getType() == DMBrowserNodeType.IntermediateInputsFolder) {
            result = imageManager.getSharedImage((ImageSource)StandardImages.INTERMEDIATE_INPUT_16);
        } else if (node.getType() == DMBrowserNodeType.CommonText) {
            result = imageManager.getSharedImage((ImageSource)StandardImages.COMMON_TEXT_16);
        } else if (node.getType() == DMBrowserNodeType.Custom && node.getIcon() != null) {
            result = node.getIcon();
        } else if (node.getType() == DMBrowserNodeType.SqlFolder) {
            result = imageManager.getSharedImage((ImageSource)StandardImages.SQL_STATEMENTS);
        }
        return result;
    }

    public String getText(Object element) {
        DMBrowserNode node = (DMBrowserNode)element;
        return node.getTitle();
    }

    public String getToolTipText(Object element) {
        DMBrowserNode node = (DMBrowserNode)element;
        return node.getToolTip();
    }

    public Color getForeground(Object element) {
        DMBrowserNode node = (DMBrowserNode)element;
        if (!node.isEnabled()) {
            return Display.getCurrent().getSystemColor(16);
        }
        return super.getForeground(element);
    }
}

