/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.instancemanagement.internal;

import de.rcenvironment.core.command.spi.ParsedBooleanParameter;
import de.rcenvironment.core.command.spi.ParsedIntegerParameter;
import de.rcenvironment.core.command.spi.ParsedMultiParameter;
import de.rcenvironment.core.command.spi.ParsedStringParameter;
import de.rcenvironment.core.instancemanagement.InstanceConfigurationOperationSequence;
import de.rcenvironment.core.instancemanagement.internal.ConfigurationConnection;
import de.rcenvironment.core.instancemanagement.internal.ConfigurationSshConnection;
import de.rcenvironment.core.instancemanagement.internal.ConfigurationUplinkConnection;
import de.rcenvironment.core.instancemanagement.internal.InstanceConfigurationOperationDescriptor;
import de.rcenvironment.core.instancemanagement.internal.SSHAccountParameters;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class InstanceConfigurationOperationSequenceImpl
implements InstanceConfigurationOperationSequence {
    private final List<InstanceConfigurationOperationDescriptor> entries = new ArrayList<InstanceConfigurationOperationDescriptor>();
    private boolean listExported;

    InstanceConfigurationOperationSequenceImpl() {
    }

    public synchronized List<InstanceConfigurationOperationDescriptor> getConfigurationSteps() {
        this.listExported = true;
        return this.entries;
    }

    @Override
    public InstanceConfigurationOperationSequence setProfileVersion(String version) {
        if (!this.entries.isEmpty()) {
            throw new IllegalStateException("The 'set profile version' operation can only be added as the first configuration step");
        }
        this.appendStep(new InstanceConfigurationOperationDescriptor("--set-rce-version", version));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence resetConfiguration() {
        if (!this.entries.isEmpty()) {
            throw new IllegalStateException("The 'reset' operation can only be added as the first configuration step");
        }
        this.appendStep(new InstanceConfigurationOperationDescriptor("--reset", new Object[0]));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence wipeConfiguration() {
        if (!this.entries.isEmpty()) {
            throw new IllegalStateException("The 'wipe' operation can only be added as the first configuration step");
        }
        this.appendStep(new InstanceConfigurationOperationDescriptor("--wipe", new Object[0]));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence applyTemplate(String templateName) {
        if (!this.entries.isEmpty()) {
            throw new IllegalStateException("The 'apply template' operation can only be added as the first configuration step");
        }
        this.appendStep(new InstanceConfigurationOperationDescriptor("--apply-template", templateName));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence applyTemplateFile(File templateFilePath) {
        if (!this.entries.isEmpty()) {
            throw new IllegalStateException("The 'apply template file' operation can only be added as the first configuration step");
        }
        this.appendStep(new InstanceConfigurationOperationDescriptor("--apply-template", templateFilePath));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence setName(String name) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--set-name", name));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence setComment(String comment) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--set-comment", comment));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence setWorkflowHostFlag(boolean value) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--set-workflow-host-option", value));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence setRelayFlag(boolean value) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--set-relay-option", value));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence setCustomNodeId(String value) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--set-custom-node-id", value));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence setTempDirPath(String tempPath) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--set-tempdir-path", tempPath));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence addNetworkConnection(String connectionName, String host, int port, boolean autoConnect, int autoRetryInitialDelay, int autoRetryMaximumDelay, float autoRetryDelayMultiplier) {
        ConfigurationConnection configConnection = new ConfigurationConnection(connectionName, host, port, autoConnect, autoRetryInitialDelay, autoRetryMaximumDelay, autoRetryDelayMultiplier);
        this.appendStep(new InstanceConfigurationOperationDescriptor("--add-connection", configConnection));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence addNetworkConnectionFromStringParameters(List<String> parameters) {
        if (parameters.size() != 7) {
            throw new IllegalArgumentException("Number of parameter elements must be 7");
        }
        String connectionName = parameters.get(0);
        String host = parameters.get(1);
        int port = Integer.parseInt(parameters.get(2));
        boolean autoConnect = Boolean.parseBoolean(parameters.get(3));
        int autoRetryInitialDelay = Integer.parseInt(parameters.get(4));
        int autoRetryMaximumDelay = Integer.parseInt(parameters.get(5));
        float autoRetryDelayMultiplier = Float.parseFloat(parameters.get(6));
        return this.addNetworkConnection(connectionName, host, port, autoConnect, autoRetryInitialDelay, autoRetryMaximumDelay, autoRetryDelayMultiplier);
    }

    @Override
    public InstanceConfigurationOperationSequence removeConnection(String name) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--remove-connection", name));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence addServerPort(String serverPortName, String serverPortIp, int serverPortNumber) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--add-server-port", serverPortName, serverPortIp, serverPortNumber));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence setIpFilterEnabled(boolean ipFilterState) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--set-ip-filter-option", ipFilterState));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence enableSshServer(String ipAddress, int port) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--configure-ssh-server", ipAddress, port));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence disableSshServer() {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--disable-ssh-server", new Object[0]));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence addSshAccount(SSHAccountParameters parameters) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--add-ssh-account", parameters.getUserName(), parameters.getUserRole(), parameters.isEnabled(), parameters.getPassword()));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence addSshAccount(String username, String role, boolean enabled, String password) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--add-ssh-account", username, role, enabled, password));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence addSshAccountFromStringParameters(List<String> parameters) {
        String username = parameters.get(0);
        String role = parameters.get(1);
        Boolean enabled = Boolean.parseBoolean(parameters.get(2));
        String password = parameters.get(3);
        this.appendStep(new InstanceConfigurationOperationDescriptor("--add-ssh-account", username, role, enabled, password));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence removeSshAccount(String username) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--remove-ssh-account", username));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence enableImSshAccessWithDefaultRole(int accessPort) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--enable-im-ssh-access", accessPort));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence enableImSshAccessWithRole(int accessPort, String role) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--enable-im-ssh-access", accessPort, role));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence setRequestTimeout(long timeout) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--set-request-timeout", timeout));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence setForwardingTimeout(long timeout) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--set-forwarding-timeout", timeout));
        return this;
    }

    private synchronized void appendStep(InstanceConfigurationOperationDescriptor step) {
        if (this.listExported) {
            throw new IllegalStateException();
        }
        this.entries.add(step);
    }

    @Override
    public InstanceConfigurationOperationSequence addAllowedInboundIP(String ip) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--add-allowed-inbound-ip", ip));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence removeAllowedInboundIP(String ip) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--remove-allowed-inbound-ip", ip));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence addSshConnection(String connectionName, String displayName, String host, int port, String loginName) {
        ConfigurationSshConnection configSshConnection = new ConfigurationSshConnection(connectionName, displayName, host, port, loginName);
        this.appendStep(new InstanceConfigurationOperationDescriptor("--add-ssh-connection", configSshConnection));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence addSshConnectionFromStringParameters(List<String> parameters) {
        if (parameters.size() != 5) {
            throw new IllegalArgumentException("Number of parameter elements must be 5");
        }
        String connectionName = parameters.get(0);
        String displayName = parameters.get(1);
        String host = parameters.get(2);
        int port = Integer.parseInt(parameters.get(3));
        String loginName = parameters.get(4);
        return this.addSshConnection(connectionName, displayName, host, port, loginName);
    }

    @Override
    public InstanceConfigurationOperationSequence removeSshConnection(String name) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--remove-ssh-connection", name));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence addUplinkConnection(ParsedMultiParameter parsedParameters) {
        ParsedStringParameter connectionId = (ParsedStringParameter)parsedParameters.getResult()[0];
        ParsedStringParameter hostName = (ParsedStringParameter)parsedParameters.getResult()[1];
        ParsedIntegerParameter port = (ParsedIntegerParameter)parsedParameters.getResult()[2];
        ParsedStringParameter clientId = (ParsedStringParameter)parsedParameters.getResult()[3];
        ParsedBooleanParameter isGateway = (ParsedBooleanParameter)parsedParameters.getResult()[4];
        ParsedBooleanParameter connectOnStartup = (ParsedBooleanParameter)parsedParameters.getResult()[5];
        ParsedBooleanParameter autoRetry = (ParsedBooleanParameter)parsedParameters.getResult()[6];
        ParsedStringParameter userName = (ParsedStringParameter)parsedParameters.getResult()[7];
        ParsedStringParameter verification = (ParsedStringParameter)parsedParameters.getResult()[8];
        ParsedStringParameter passwordParameter = (ParsedStringParameter)parsedParameters.getResult()[9];
        String password = null;
        if (verification.getResult().equals("password")) {
            password = passwordParameter.getResult();
        }
        ConfigurationUplinkConnection uplinkConnection = new ConfigurationUplinkConnection(connectionId.getResult(), hostName.getResult(), port.getResult(), userName.getResult(), connectionId.getResult(), clientId.getResult(), null, connectOnStartup.getResult(), autoRetry.getResult(), isGateway.getResult(), password);
        this.appendStep(new InstanceConfigurationOperationDescriptor("--add-uplink-connection", uplinkConnection));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence addUplinkConnectionFromStringParameters(List<String> parameters) {
        String connectionId = parameters.get(0);
        String hostName = parameters.get(1);
        int port = Integer.parseInt(parameters.get(2));
        String clientId = parameters.get(3);
        boolean isGateway = Boolean.parseBoolean(parameters.get(4));
        boolean connectOnStartup = Boolean.parseBoolean(parameters.get(5));
        boolean autoRetry = Boolean.parseBoolean(parameters.get(6));
        String userName = parameters.get(7);
        String password = null;
        if (parameters.get(8).equals("password")) {
            password = parameters.get(9);
        }
        ConfigurationUplinkConnection uplinkConnection = new ConfigurationUplinkConnection(connectionId, hostName, port, userName, connectionId, clientId, null, connectOnStartup, autoRetry, isGateway, password);
        this.appendStep(new InstanceConfigurationOperationDescriptor("--add-uplink-connection", uplinkConnection));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence removeUplinkConnection(String id) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--remove-uplink-connection", id));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence publishComponent(String name) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--publish-component", name));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence unpublishComponent(String name) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--unpublish-component", name));
        return this;
    }

    @Override
    public InstanceConfigurationOperationSequence setBackgroundMonitoring(String id, int interval) {
        this.appendStep(new InstanceConfigurationOperationDescriptor("--set-background-monitoring", id, interval));
        return this;
    }
}

