/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.introduction;

import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Map;
import java.util.Properties;

final class NavigateToLinkParameters {
    private static final String LINK_VALUE = "openLink";
    private static final String LINK_VALUE_NEWS = "news";
    private static final String LINK_VALUE_NEWSLETTER = "newsletter";
    private static final String LINK_VALUE_TWITTER = "twitter";
    private static final String LINK_VALUE_GITHUB = "github";
    private final Properties backingProperties = new Properties();

    private NavigateToLinkParameters(Properties properties) {
        this.backingProperties.putAll((Map<?, ?>)properties);
    }

    public static NavigateToLinkParameters createFromProperties(Properties properties) {
        NavigateToLinkParameters.assertParameterValue(properties);
        return new NavigateToLinkParameters(properties);
    }

    private static void assertParameterValue(Properties properties) {
        String linkValue;
        switch (linkValue = properties.getProperty(LINK_VALUE)) {
            case "github": 
            case "twitter": 
            case "news": 
            case "newsletter": {
                return;
            }
        }
        String errorMessage = StringUtils.format((String)"Properties given for constructing instance of %s do not contain valid value for key %s. Contained value: %s. Valid values: %s, %s, %s, %s", (Object[])new Object[]{NavigateToLinkParameters.class.getName(), LINK_VALUE, linkValue, LINK_VALUE_GITHUB, LINK_VALUE_NEWS, LINK_VALUE_NEWSLETTER, LINK_VALUE_TWITTER});
        throw new IllegalArgumentException(errorMessage);
    }

    public String getKeyOfParameterValue() {
        return this.backingProperties.getProperty(LINK_VALUE);
    }
}

