/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.ui;

import com.googlecode.lanterna.gui.Action;
import com.googlecode.lanterna.gui.Component;
import com.googlecode.lanterna.gui.GUIScreen;
import com.googlecode.lanterna.gui.component.Button;
import com.googlecode.lanterna.gui.component.Label;
import com.googlecode.lanterna.gui.component.Panel;
import com.googlecode.lanterna.gui.dialog.MessageBox;
import com.googlecode.lanterna.gui.layout.LayoutParameter;
import org.apache.commons.lang3.text.WordUtils;

public final class LanternaUtils {
    private static LayoutParameter lp;
    private static final int WORD_WRAPPING_MAX_LINE_LENGTH = 60;
    private static final String DIALOG_TITLE_SUCCESS = "Success";
    private static final String DIALOG_TITLE_ERROR = "Error";

    private LanternaUtils() {
    }

    public static String applyWordWrapping(String input) {
        return LanternaUtils.applyWordWrapping(input, 60);
    }

    public static String applyWordWrapping(String input, int width) {
        return WordUtils.wrap((String)input, (int)width, (String)"\n", (boolean)true);
    }

    public static Panel createOkCancelButtonPanel(Action okAction, Action cancelAction) {
        Button buttonOk = new Button("Ok", okAction);
        Button buttonCancel = new Button("Cancel", cancelAction);
        Panel buttonPanel = new Panel(Panel.Orientation.HORISONTAL);
        buttonPanel.addComponent((Component)new Label("                   "), new LayoutParameter[0]);
        buttonPanel.addComponent((Component)buttonOk, new LayoutParameter[0]);
        buttonPanel.addComponent((Component)buttonCancel, new LayoutParameter[0]);
        return buttonPanel;
    }

    public static void showSuccessMessageBox(GUIScreen guiScreen, String message) {
        MessageBox.showMessageBox((GUIScreen)guiScreen, (String)DIALOG_TITLE_SUCCESS, (String)LanternaUtils.applyWordWrapping(message));
    }

    public static void showErrorMessageBox(GUIScreen guiScreen, String message) {
        MessageBox.showMessageBox((GUIScreen)guiScreen, (String)DIALOG_TITLE_ERROR, (String)LanternaUtils.applyWordWrapping(message));
    }
}

